/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.core;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.CandidateRange;
import com.mapinfo.mapmarker.GeocodeResult;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.MMGeneralGeocoderException;
import com.mapinfo.mapmarker.MMInternalFatalException;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.ICountryGeographyInfo;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.dp.IDataManager;
import com.mapinfo.mapmarker.core.IGeocoder;
import com.mapinfo.mapmarker.core.address.IAddressGeocoder;
import com.mapinfo.mapmarker.core.browse.IBrowseGeocoder;
import com.mapinfo.mapmarker.core.custom.ICustomGeocoder;
import com.mapinfo.mapmarker.core.geographic.IGeographicGeocoder;
import com.mapinfo.mapmarker.core.parser.ParserException;
import com.mapinfo.mapmarker.core.postal.IPostalGeocoder;
import com.mapinfo.mapmarker.core.standardize.IStandardizeGeocoder;
import com.mapinfo.mapmarker.utils.MapMarkerResourceLoader;
import java.util.ResourceBundle;

public final class CoreGeocoder
implements IGeocoder {
    private static String m_localStrings = "com.mapinfo.mapmarker.GeocodableAddressStrings";
    private ResourceBundle m_errorBundle;
    private IHandler m_handler;

    public CoreGeocoder(IHandler handler) {
        this.m_handler = handler;
    }

    @Override
    public void setErrorBundle(ResourceBundle bundle) {
        this.m_errorBundle = bundle;
    }

    @Override
    public GeocodeResult geocode(IConstraints constraints) throws MMInternalFatalException, MapMarkerInternalException {
        if (constraints.getHandler() == null) {
            this.prepareAndParse(0, constraints);
        }
        if (!constraints.getHandler().isGeocodeSupported()) {
            throw new MMGeneralGeocoderException(2307);
        }
        IAddressGeocoder geo = constraints.getHandler().getAddressGeocoder();
        if (geo == null) {
            throw new MMGeneralGeocoderException(2307);
        }
        return geo.geocode(constraints, this.m_errorBundle);
    }

    @Override
    public GeocodeResult standardize(IConstraints constraints) throws MapMarkerInternalException {
        if (constraints.getHandler() == null) {
            this.prepareAndParse(5, constraints);
        }
        if (!constraints.getHandler().isStandardizeSupported()) {
            throw new MMGeneralGeocoderException(2307);
        }
        IStandardizeGeocoder geo = constraints.getHandler().getStandardizeGeocoder();
        if (geo == null) {
            throw new MMGeneralGeocoderException(2307);
        }
        return geo.standardize(constraints);
    }

    @Override
    public GeocodeResult geocodePostal(IConstraints constraints) throws MapMarkerInternalException, MMInternalFatalException {
        if (constraints.getHandler() == null) {
            this.prepareAndParse(1, constraints);
        }
        if (!constraints.getHandler().isGeocodePostalSupported()) {
            throw new MMGeneralGeocoderException(2307);
        }
        IPostalGeocoder geo = constraints.getHandler().getPostalGeocoder();
        if (geo == null) {
            throw new MMGeneralGeocoderException(2307);
        }
        return geo.geocodePostal(constraints);
    }

    @Override
    public GeocodeResult browse(IConstraints constraints) throws MapMarkerInternalException, MMInternalFatalException {
        if (constraints.getHandler() == null) {
            this.prepareAndParse(6, constraints);
        }
        if (!constraints.getHandler().isBrowseSupported()) {
            throw new MMGeneralGeocoderException(2307);
        }
        IBrowseGeocoder geo = constraints.getHandler().getBrowseGeocoder();
        if (geo == null) {
            throw new MMGeneralGeocoderException(2307);
        }
        return geo.browse(constraints);
    }

    @Override
    public GeocodeResult geocodeCustom(int geocodeType, IConstraints constraints) throws MapMarkerInternalException {
        if (constraints.getHandler() == null) {
            this.prepareAndParse(geocodeType, constraints);
        }
        if (!constraints.getHandler().isGeocodeCustomSupported()) {
            throw new MMGeneralGeocoderException(2307);
        }
        ICustomGeocoder geo = constraints.getHandler().getCustomGeocoder();
        if (geo == null) {
            throw new MMGeneralGeocoderException(2307);
        }
        return geo.geocodeCustom(geocodeType, constraints);
    }

    @Override
    public GeocodeResult geocodeGeographic(IConstraints constraints) throws MapMarkerInternalException, MMInternalFatalException {
        if (constraints.getHandler() == null) {
            this.prepareAndParse(4, constraints);
        }
        if (!constraints.getHandler().isGeocodeGeographicSupported()) {
            throw new MMGeneralGeocoderException(2307);
        }
        IGeographicGeocoder geo = constraints.getHandler().getGeographicGeocoder();
        if (geo == null) {
            throw new MMGeneralGeocoderException(2307);
        }
        return geo.geocodeGeographic(constraints);
    }

    @Override
    public CandidateAddress getIndexedCandidate(int i, IConstraints preferences) throws MapMarkerInternalException {
        IConstraints localPrefs = this.convertConstraints(preferences);
        if (i >= localPrefs.getHandler().getGeocodeResult().getNumberCandidates()) {
            return null;
        }
        ICandidate cand = (ICandidate)localPrefs.getHandler().getMatchResults().get(i);
        return cand.toCandidateAddress(localPrefs.getHandler().getParsedAddress(), localPrefs);
    }

    @Override
    public CandidateAddress getIndexedCoords(int candIndex, CandidateRange range, IConstraints preferences) throws MapMarkerInternalException {
        IConstraints localPrefs = this.convertConstraints(preferences);
        if (candIndex > localPrefs.getHandler().getGeocodeResult().getNumberCandidates()) {
            return null;
        }
        InternalCandidateAddress cand = (InternalCandidateAddress)localPrefs.getHandler().getMatchResults().get(candIndex);
        return cand.reinterpolate(localPrefs.getHandler().getParsedAddress(), range, localPrefs);
    }

    public ResourceBundle getErrorBundle() {
        return this.m_errorBundle;
    }

    public String getLocalStrings() {
        return m_localStrings;
    }

    public void setLocalStrings(String localStrings) {
        m_localStrings = localStrings;
    }

    @Override
    public IConstraints convertConstraints(IConstraints constraints) {
        return this.m_handler.getLocalConstraintsHelper().convertToLocalConstraints(constraints, this.m_handler);
    }

    @Override
    public void prepareAndParse(int geocodeType, IConstraints constraints) throws ParserException, MapMarkerInternalException {
        if (this.m_errorBundle == null) {
            this.m_errorBundle = MapMarkerResourceLoader.loadForLocale(constraints.getClientLocale(), m_localStrings);
        }
        constraints.setHandler(this.m_handler);
        constraints.getHandler().getParseHandler().getParsedAddresses(constraints.getHandler().getInputAddress(), constraints);
    }

    @Override
    public ICountryGeographyInfo getCountryGeographyInfo() {
        IDataManager data = this.m_handler.getDataManager();
        if (data != null) {
            return data.getCountryGeographyInfo();
        }
        return null;
    }
}

