/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.core;

import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.core.CoreParseHandler;
import com.mapinfo.mapmarker.core.FatalHandlerException;
import com.mapinfo.mapmarker.core.ICoreParseHandler;
import com.mapinfo.mapmarker.core.IParseHandler;
import com.mapinfo.mapmarker.core.IScoringHelper;
import com.mapinfo.mapmarker.core.address.CoreAddressGeocoder;
import com.mapinfo.mapmarker.core.address.CoreStreetGeocoder;
import com.mapinfo.mapmarker.core.address.CoreStreetIntersectionGeocoder;
import com.mapinfo.mapmarker.core.address.IAddressGeocoder;
import com.mapinfo.mapmarker.core.address.ICoreAddressGeocoder;
import com.mapinfo.mapmarker.core.address.ICoreStreetGeocoder;
import com.mapinfo.mapmarker.core.address.ICoreStreetIntersectionGeocoder;
import com.mapinfo.mapmarker.core.address.IStreetGeocoder;
import com.mapinfo.mapmarker.core.address.IStreetIntersectionGeocoder;
import com.mapinfo.mapmarker.core.browse.CoreBrowseFilter;
import com.mapinfo.mapmarker.core.browse.CoreBrowseGeocoder;
import com.mapinfo.mapmarker.core.browse.IBrowseFilter;
import com.mapinfo.mapmarker.core.browse.IBrowseGeocoder;
import com.mapinfo.mapmarker.core.browse.ICoreBrowseFilter;
import com.mapinfo.mapmarker.core.browse.ICoreBrowseGeocoder;
import com.mapinfo.mapmarker.core.geographic.CoreGeographicCentroidFilter;
import com.mapinfo.mapmarker.core.geographic.CoreGeographicGeocoder;
import com.mapinfo.mapmarker.core.geographic.ICoreGeographicCentroidFilter;
import com.mapinfo.mapmarker.core.geographic.ICoreGeographicGeocoder;
import com.mapinfo.mapmarker.core.geographic.IGeographicCentroidFilter;
import com.mapinfo.mapmarker.core.geographic.IGeographicGeocoder;
import com.mapinfo.mapmarker.core.geographic.IGeographicMatcher;
import com.mapinfo.mapmarker.core.parser.CoreParser;
import com.mapinfo.mapmarker.core.parser.ICoreParser;
import com.mapinfo.mapmarker.core.parser.IParser;
import com.mapinfo.mapmarker.core.postal.CorePostalCentroidFilter;
import com.mapinfo.mapmarker.core.postal.CorePostalGeocoder;
import com.mapinfo.mapmarker.core.postal.ICorePostalCentroidFilter;
import com.mapinfo.mapmarker.core.postal.ICorePostalGeocoder;
import com.mapinfo.mapmarker.core.postal.IPostalCentroidFilter;
import com.mapinfo.mapmarker.core.postal.IPostalGeocoder;
import com.mapinfo.mapmarker.core.postal.IPostalMatcher;
import com.mapinfo.mapmarker.core.standardize.CoreStandardizeGeocoder;
import com.mapinfo.mapmarker.core.standardize.ICoreStandardizeGeocoder;
import com.mapinfo.mapmarker.core.standardize.IStandardizeGeocoder;

public class HandlerValidator {
    public static boolean validateHandler(IHandler handler, boolean bRequireAddressGeocoder, boolean bRequirePostalCentroids, boolean bRequireGeographicCentroids, boolean bRequireBrowse, boolean bRequireStandardize, boolean bRequireCustom) throws FatalHandlerException {
        boolean bValid = true;
        if (bRequireAddressGeocoder) {
            HandlerValidator.validateAddressGeocoder(handler);
        }
        if (bRequirePostalCentroids) {
            HandlerValidator.validatePostalGeocoder(handler);
        }
        if (bRequireGeographicCentroids) {
            HandlerValidator.validateGeographicGeocoder(handler);
        }
        if (bRequireBrowse) {
            HandlerValidator.validateBrowseGeocoder(handler);
        }
        if (bRequireStandardize) {
            HandlerValidator.validateStandardizeGeocoder(handler);
        }
        if (bRequireCustom && handler.getCustomGeocoder() == null) {
            throw new FatalHandlerException(2508);
        }
        if (handler.getDataManager() == null) {
            throw new FatalHandlerException(2501);
        }
        if (handler.getLocalConstraintsHelper() == null) {
            throw new FatalHandlerException(2500);
        }
        if (handler.getMatchConstraintsConverter() == null) {
            throw new FatalHandlerException(2500);
        }
        HandlerValidator.validateParser(handler);
        return bValid;
    }

    private static void validateAddressGeocoder(IHandler handler) throws FatalHandlerException {
        IAddressGeocoder geo = handler.getAddressGeocoder();
        if (geo == null) {
            throw new FatalHandlerException(2503);
        }
        if (geo instanceof CoreAddressGeocoder) {
            if (!(handler instanceof ICoreAddressGeocoder)) {
                throw new FatalHandlerException(2503);
            }
            HandlerValidator.validateGeographicCentroidFilter(handler);
            HandlerValidator.validatePostalCentroidFilter(handler);
            IStreetGeocoder st = ((ICoreAddressGeocoder)((Object)handler)).getStreetGeocoder();
            if (st == null) {
                throw new FatalHandlerException(2503);
            }
            if (st instanceof CoreStreetGeocoder) {
                if (!(handler instanceof ICoreStreetGeocoder)) {
                    throw new FatalHandlerException(2503);
                }
                if (((ICoreStreetGeocoder)((Object)handler)).getMatcher() == null) {
                    throw new FatalHandlerException(2503);
                }
                IScoringHelper score = ((ICoreStreetGeocoder)((Object)handler)).getScoringHelper();
                if (score == null) {
                    throw new FatalHandlerException(2503);
                }
                if (score.makeStringScorer() == null) {
                    throw new FatalHandlerException(2503);
                }
                IStreetIntersectionGeocoder xg = ((ICoreStreetGeocoder)((Object)handler)).getStreetIntersectionGeocoder();
                if (xg == null) {
                    throw new FatalHandlerException(2503);
                }
                if (xg instanceof CoreStreetIntersectionGeocoder) {
                    if (!(handler instanceof ICoreStreetIntersectionGeocoder)) {
                        throw new FatalHandlerException(2503);
                    }
                    if (((ICoreStreetIntersectionGeocoder)((Object)handler)).getIntersectionHelper() == null) {
                        throw new FatalHandlerException(2503);
                    }
                    if (((ICoreStreetIntersectionGeocoder)((Object)handler)).getStreetSingleAddressGeocoder() == null) {
                        throw new FatalHandlerException(2503);
                    }
                }
                if (((ICoreStreetGeocoder)((Object)handler)).getStreetSingleAddressGeocoder() == null) {
                    throw new FatalHandlerException(2503);
                }
            }
        }
    }

    private static void validatePostalGeocoder(IHandler handler) throws FatalHandlerException {
        IPostalGeocoder postal = handler.getPostalGeocoder();
        if (postal == null) {
            throw new FatalHandlerException(2504);
        }
        if (postal instanceof CorePostalGeocoder) {
            if (!(handler instanceof ICorePostalGeocoder)) {
                throw new FatalHandlerException(2504);
            }
            HandlerValidator.validatePostalCentroidFilter(handler);
            IPostalMatcher matcher = ((ICorePostalGeocoder)((Object)handler)).getPostalMatcher();
            if (matcher == null) {
                throw new FatalHandlerException(2504);
            }
        }
    }

    private static void validateGeographicGeocoder(IHandler handler) throws FatalHandlerException {
        IGeographicGeocoder geo = handler.getGeographicGeocoder();
        if (geo == null) {
            throw new FatalHandlerException(2505);
        }
        if (geo instanceof CoreGeographicGeocoder) {
            if (!(handler instanceof ICoreGeographicGeocoder)) {
                throw new FatalHandlerException(2505);
            }
            HandlerValidator.validateGeographicCentroidFilter(handler);
            IGeographicMatcher matcher = ((ICoreGeographicGeocoder)((Object)handler)).getGeographicMatcher();
            if (matcher == null) {
                throw new FatalHandlerException(2505);
            }
        }
    }

    private static void validateBrowseGeocoder(IHandler handler) throws FatalHandlerException {
        IBrowseGeocoder browse = handler.getBrowseGeocoder();
        if (browse == null) {
            throw new FatalHandlerException(2506);
        }
        if (browse instanceof CoreBrowseGeocoder) {
            if (!(handler instanceof ICoreBrowseGeocoder)) {
                throw new FatalHandlerException(2506);
            }
            IBrowseFilter filter = ((ICoreBrowseGeocoder)((Object)handler)).getBrowseFilter();
            if (filter == null) {
                throw new FatalHandlerException(2506);
            }
            if (filter instanceof CoreBrowseFilter && !(handler instanceof ICoreBrowseFilter)) {
                throw new FatalHandlerException(2506);
            }
        }
        if (handler.getBrowseHelper() == null) {
            throw new FatalHandlerException(2506);
        }
    }

    private static void validateStandardizeGeocoder(IHandler handler) throws FatalHandlerException {
        IStandardizeGeocoder std = handler.getStandardizeGeocoder();
        if (std == null) {
            throw new FatalHandlerException(2507);
        }
        if (std instanceof CoreStandardizeGeocoder) {
            if (!(handler instanceof ICoreStandardizeGeocoder)) {
                throw new FatalHandlerException(2507);
            }
            if (((ICoreStandardizeGeocoder)((Object)handler)).getStandardizeHelper() == null) {
                throw new FatalHandlerException(2507);
            }
        }
    }

    private static void validatePostalCentroidFilter(IHandler handler) throws FatalHandlerException {
        IPostalCentroidFilter filter = ((ICorePostalGeocoder)((Object)handler)).getPostalCentroidFilter();
        if (filter == null) {
            throw new FatalHandlerException(2509);
        }
        if (filter instanceof CorePostalCentroidFilter && !(handler instanceof ICorePostalCentroidFilter)) {
            throw new FatalHandlerException(2509);
        }
    }

    private static void validateGeographicCentroidFilter(IHandler handler) throws FatalHandlerException {
        IGeographicCentroidFilter filter = ((ICoreGeographicGeocoder)((Object)handler)).getGeographicCentroidFilter();
        if (filter == null) {
            throw new FatalHandlerException(2510);
        }
        if (filter instanceof CoreGeographicCentroidFilter && !(handler instanceof ICoreGeographicCentroidFilter)) {
            throw new FatalHandlerException(2510);
        }
    }

    private static void validateParser(IHandler handler) throws FatalHandlerException {
        IParseHandler parse = handler.getParseHandler();
        if (parse == null) {
            throw new FatalHandlerException(2511);
        }
        if (parse instanceof CoreParseHandler && !(handler instanceof ICoreParseHandler)) {
            throw new FatalHandlerException(2511);
        }
        if (handler instanceof ICoreParseHandler) {
            IParser parser = ((ICoreParseHandler)((Object)handler)).getParser();
            if (parser == null) {
                throw new FatalHandlerException(2511);
            }
            if (parser instanceof CoreParser) {
                if (!(handler instanceof ICoreParser)) {
                    throw new FatalHandlerException(2511);
                }
                if (((ICoreParser)((Object)handler)).getIntersectionParser() == null) {
                    throw new FatalHandlerException(2511);
                }
                if (((ICoreParser)((Object)handler)).getParseHelper() == null) {
                    throw new FatalHandlerException(2511);
                }
                if (((ICoreParser)((Object)handler)).getPreParseHandler() == null) {
                    throw new FatalHandlerException(2511);
                }
                if (((ICoreParser)((Object)handler)).getRuleHandler() == null) {
                    throw new FatalHandlerException(2502);
                }
            }
        }
    }
}

