/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.core.address;

import com.mapinfo.mapmarker.GeocodeResult;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.MMInternalFatalException;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.InternalIntersectionCandidateAddress;
import com.mapinfo.mapmarker.common.ParsedInputAddress;
import com.mapinfo.mapmarker.common.ParsedInputAddressUtils;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.core.IPOBoxHandler;
import com.mapinfo.mapmarker.core.IRetrievedCandidates;
import com.mapinfo.mapmarker.core.IScoringHelper;
import com.mapinfo.mapmarker.core.address.CoreStreetIntersectionGeocoder;
import com.mapinfo.mapmarker.core.address.CoreStreetSingleAddressGeocoder;
import com.mapinfo.mapmarker.core.address.ICoreStreetGeocoder;
import com.mapinfo.mapmarker.core.address.IResettableStreetSingleAddressGeocoder;
import com.mapinfo.mapmarker.core.address.IStreetGeocoder;
import com.mapinfo.mapmarker.core.address.IStreetIntersectionGeocoder;
import com.mapinfo.mapmarker.utils.MMJLog;
import java.util.Iterator;
import java.util.List;

public final class CoreStreetGeocoder
implements IStreetGeocoder {
    private String lineSeparator = System.getProperty("line.separator");

    public static boolean doPOBoxValidation() {
        return System.getProperty("POB_VALIDATION") != null;
    }

    public CoreStreetGeocoder(IHandler handler) {
        ((ICoreStreetGeocoder)((Object)handler)).setStreetIntersectionGeocoder(new CoreStreetIntersectionGeocoder());
        ((ICoreStreetGeocoder)((Object)handler)).setStreetSingleAddressGeocoder(new CoreStreetSingleAddressGeocoder());
    }

    @Override
    public IRetrievedCandidates getStreetCandidates(Address inputAddress, ScoringAddress scoringAddress, IConstraints constraints, int debugLevel) throws MapMarkerInternalException, MMInternalFatalException {
        IRetrievedCandidates candidates = null;
        candidates = constraints.getHandler().getDataManager().retrieveCandidates(inputAddress, scoringAddress, constraints);
        return candidates;
    }

    @Override
    public List handleStreetMatching(ScoringAddress inputAddress, IRetrievedCandidates candidates, IConstraints constraints, int debugLevel) throws MapMarkerInternalException {
        List matchResults = null;
        matchResults = ((ICoreStreetGeocoder)((Object)constraints.getHandler())).getMatcher().matchAddress(constraints, inputAddress, candidates);
        if (debugLevel >= 2) {
            MMJLog.getLog().debug("Candidates after matching: ");
            this.printCandidateInfo(candidates);
        }
        return matchResults;
    }

    private void doPossibleXsectPoBox(IHandler handler, GeocodeResult geocodeResult, IConstraints constraints, int debugLevel) throws MapMarkerInternalException, MMInternalFatalException {
        Address xsectAddr1 = null;
        Address xsectAddr2 = null;
        xsectAddr1 = ((ICoreStreetGeocoder)((Object)handler)).getFirstParsedAddress();
        xsectAddr2 = ((ICoreStreetGeocoder)((Object)handler)).getSecondParsedAddress();
        boolean addr1HasPOB = xsectAddr1.hasAdditionalFields() && xsectAddr1.getAdditionalFields().get(AddressImpl.KEY_POBOX) != null;
        IScoringHelper scoringHandler = ((ICoreStreetGeocoder)((Object)handler)).getScoringHelper();
        Address tempAddr = addr1HasPOB ? this.makePOBoxAddress(scoringHandler.makeParsedAddressCopy(xsectAddr1), (IPOBoxHandler)((Object)handler)) : this.makePOBoxAddress(scoringHandler.makeParsedAddressCopy(xsectAddr2), (IPOBoxHandler)((Object)handler));
        tempAddr.getAdditionalFields().remove(AddressImpl.KEY_POBOX);
        tempAddr.getAdditionalFields().remove(AddressImpl.KEY_POBOX_NUMBER);
        tempAddr.getAdditionalFields().put(AddressImpl.POB_IN_MAIN_ADDRESS_FIELD, "true");
        tempAddr.getAdditionalFields().put("XSECT_POBOX", "");
        ((ICoreStreetGeocoder)((Object)handler)).setSearchParsedAddress(tempAddr);
        handler.setParsedAddress(tempAddr);
        constraints.setCustomString("POBOX_MATCH_IN_PROGRESS", "true");
        constraints.setCustomString("XSECT_POBOX", "");
        geocodeResult.setIntersectionStatus(false);
        this.geocodeSingleAddress(constraints, debugLevel, geocodeResult);
        if (geocodeResult.getNumberCloseCandidates() == 0) {
            handler.getParsedAddress().getAdditionalFields().remove("XSECT_POBOX");
            geocodeResult.setNumberCandidates(0);
            constraints.setCustomString("POBOX_MATCH_IN_PROGRESS", "false");
            constraints.setCustomString("XSECT_POBOX", null);
            handler.setParsedAddress(xsectAddr1);
        }
    }

    @Override
    public void geocodeIntersection(IConstraints constraints, int debugLevel, GeocodeResult geocodeResult) throws MapMarkerInternalException, MMInternalFatalException {
        geocodeResult.setIntersectionStatus(true);
        IHandler handler = constraints.getHandler();
        boolean isDualAddress = handler instanceof IPOBoxHandler && ((IPOBoxHandler)((Object)handler)).isDualAddress();
        boolean isPOBox = handler instanceof IPOBoxHandler && ((IPOBoxHandler)((Object)handler)).hasInputPOBox();
        boolean doPOBoxFirst = isDualAddress && Boolean.valueOf(constraints.getCustomString("PreferPOBoxOverStreet", "false")) != false;
        boolean triedPOBOX = false;
        if (isDualAddress && isPOBox && doPOBoxFirst) {
            this.doPossibleXsectPoBox(handler, geocodeResult, constraints, debugLevel);
            if (geocodeResult.getNumberCloseCandidates() > 0) {
                return;
            }
            triedPOBOX = true;
        }
        geocodeResult.setIntersectionStatus(true);
        if (debugLevel >= 1) {
            MMJLog.getLog().debug("First Parsed Address: " + ((ICoreStreetGeocoder)((Object)handler)).getFirstParsedAddress().toString());
            MMJLog.getLog().debug(this.lineSeparator);
            MMJLog.getLog().debug("Second Parsed Address: " + ((ICoreStreetGeocoder)((Object)handler)).getSecondParsedAddress().toString());
        }
        handler.getLocalConstraintsHelper().addLocalIntersectionConstraints(constraints, handler);
        IScoringHelper scoringHandler = ((ICoreStreetGeocoder)((Object)handler)).getScoringHelper();
        if (scoringHandler == null) {
            // empty if block
        }
        if (((ICoreStreetGeocoder)((Object)handler)).getFirstParsedAddress().getPlaceName() != null) {
            ((ICoreStreetGeocoder)((Object)handler)).getFirstParsedAddress().setPlaceName("");
        }
        if (((ICoreStreetGeocoder)((Object)handler)).getSecondParsedAddress().getPlaceName() != null) {
            ((ICoreStreetGeocoder)((Object)handler)).getSecondParsedAddress().setPlaceName("");
        }
        ScoringAddress firstScoringAddress = scoringHandler.makeScoringAddress(((ICoreStreetGeocoder)((Object)handler)).getFirstParsedAddress(), constraints, handler);
        ScoringAddress secondScoringAddress = scoringHandler.makeScoringAddress(((ICoreStreetGeocoder)((Object)handler)).getSecondParsedAddress(), constraints, handler);
        IRetrievedCandidates firstAddressCandidates = ((ICoreStreetGeocoder)((Object)handler)).getStreetGeocoder().getStreetCandidates(((ICoreStreetGeocoder)((Object)handler)).getFirstParsedAddress(), firstScoringAddress, constraints, debugLevel);
        IRetrievedCandidates secondAddressCandidates = ((ICoreStreetGeocoder)((Object)handler)).getStreetGeocoder().getStreetCandidates(((ICoreStreetGeocoder)((Object)handler)).getSecondParsedAddress(), secondScoringAddress, constraints, debugLevel);
        if (debugLevel >= 3) {
            MMJLog.getLog().debug("Unmatched Candidates for address 1: ");
            this.printCandidateInfo(firstAddressCandidates);
            MMJLog.getLog().debug("Unmatched Candidates for address 2: ");
            this.printCandidateInfo(secondAddressCandidates);
        }
        List matchResults = null;
        boolean bBothHadCands = false;
        if (firstAddressCandidates.getCandidates().size() != 0 && secondAddressCandidates.getCandidates().size() != 0) {
            IStreetIntersectionGeocoder xsect;
            bBothHadCands = true;
            List firstAddressMatchResults = ((ICoreStreetGeocoder)((Object)handler)).getStreetGeocoder().handleStreetMatching(firstScoringAddress, firstAddressCandidates, constraints, debugLevel);
            List secondAddressMatchResults = ((ICoreStreetGeocoder)((Object)handler)).getStreetGeocoder().handleStreetMatching(secondScoringAddress, secondAddressCandidates, constraints, debugLevel);
            if (debugLevel >= 2) {
                MMJLog.getLog().debug("Matched Candidates for First Address: ");
                this.printCandidateInfo(firstAddressCandidates);
                MMJLog.getLog().debug("Matched Candidates for Second Address: ");
                this.printCandidateInfo(secondAddressCandidates);
            }
            if ((xsect = ((ICoreStreetGeocoder)((Object)handler)).getStreetIntersectionGeocoder()) != null) {
                matchResults = xsect.buildIntersectionCandidateList(firstAddressMatchResults, secondAddressMatchResults, handler);
            }
            if (!triedPOBOX && matchResults == null && isDualAddress && isPOBox) {
                this.doPossibleXsectPoBox(handler, geocodeResult, constraints, debugLevel);
                if (geocodeResult.getNumberCloseCandidates() > 0) {
                    return;
                }
            }
            if (debugLevel >= 2) {
                MMJLog.getLog().debug("IntersectionCandidates are: ");
                this.printIntersectionCandidateInfo(matchResults);
            }
            geocodeResult.setDataLicensed(firstAddressCandidates.getDataLicensed());
            this.countCandidates(matchResults, geocodeResult);
            this.countCloseMatches(matchResults, geocodeResult);
        } else if (!triedPOBOX && isDualAddress && isPOBox) {
            this.doPossibleXsectPoBox(handler, geocodeResult, constraints, debugLevel);
            if (geocodeResult.getNumberCloseCandidates() > 0) {
                return;
            }
        }
        if (constraints.isReturnParsedInputAddress()) {
            ParsedInputAddress parsedInputAddress = this.populateParsedInputAddress(handler, constraints);
            geocodeResult.setParsedInput(parsedInputAddress);
        }
        handler.setGeocodeResult(geocodeResult);
        if (bBothHadCands) {
            handler.setMatchResults(matchResults);
        }
    }

    @Override
    public void geocodeSingleAddress(IConstraints constraints, int debugLevel, GeocodeResult geocodeResult) throws MapMarkerInternalException, MMInternalFatalException {
        boolean doPOBoxFirst;
        geocodeResult.setIntersectionStatus(false);
        IHandler handler = constraints.getHandler();
        IScoringHelper scoringHandler = ((ICoreStreetGeocoder)((Object)handler)).getScoringHelper();
        if (scoringHandler == null) {
            // empty if block
        }
        ((ICoreStreetGeocoder)((Object)handler)).setSearchParsedAddress(scoringHandler.makeParsedAddressCopy(handler.getParsedAddress()));
        Address originalDualParsedAddress = null;
        boolean isDualAddress = handler instanceof IPOBoxHandler && ((IPOBoxHandler)((Object)handler)).isDualAddress() && constraints.getCustomString("XSECT_POBOX") == null;
        boolean isPOBox = handler instanceof IPOBoxHandler && ((IPOBoxHandler)((Object)handler)).hasInputPOBox();
        boolean bl = doPOBoxFirst = isDualAddress && Boolean.valueOf(constraints.getCustomString("PreferPOBoxOverStreet", "false")) != false;
        if (isDualAddress) {
            String street = this.buildParsedStreetDualAddress(handler.getParsedAddress());
            constraints.setCustomString("DualAddressParsedStreet", street);
            String box = this.buildParsedPoBoxDualAddress(handler);
            constraints.setCustomString("DualAddressParsedPOBox", box);
        }
        if (doPOBoxFirst) {
            originalDualParsedAddress = ((ICoreStreetGeocoder)((Object)handler)).getScoringHelper().makeParsedAddressCopy(handler.getParsedAddress());
            Address tempAddress = ((ICoreStreetGeocoder)((Object)handler)).getSearchParsedAddress();
            ((ICoreStreetGeocoder)((Object)handler)).setSearchParsedAddress(this.makePOBoxAddress(tempAddress, (IPOBoxHandler)((Object)handler)));
            handler.setParsedAddress(tempAddress);
            handler.getParsedAddress().getAdditionalFields().put("POBOX_MATCH_IN_PROGRESS", "");
            constraints.setCustomString("POBOX_MATCH_IN_PROGRESS", "true");
        } else if (!isDualAddress && isPOBox) {
            constraints.setCustomString("POBOX_MATCH_IN_PROGRESS", "true");
        } else {
            if (originalDualParsedAddress != null) {
                handler.setParsedAddress(originalDualParsedAddress);
            }
            constraints.removeCustomObject("POBOX_MATCH_IN_PROGRESS");
        }
        if (debugLevel >= 1) {
            MMJLog.getLog().debug("Parsed address: " + handler.getParsedAddress().toString());
        }
        handler.getLocalConstraintsHelper().addLocalStreetConstraints(constraints, handler);
        boolean m_tryMoreCases = true;
        List savedMatchedCandidates = null;
        List matchResults = null;
        while (m_tryMoreCases) {
            ScoringAddress scoringAddress = scoringHandler.makeScoringAddress(handler.getParsedAddress(), constraints, handler);
            IRetrievedCandidates candidates = ((ICoreStreetGeocoder)((Object)handler)).getStreetGeocoder().getStreetCandidates(((ICoreStreetGeocoder)((Object)handler)).getSearchParsedAddress(), scoringAddress, constraints, debugLevel);
            if (debugLevel >= 3) {
                MMJLog.getLog().debug("Unmatched Candidates: ");
                this.printCandidateInfo(candidates);
            }
            if (candidates.getCandidates().size() != 0) {
                matchResults = ((ICoreStreetGeocoder)((Object)handler)).getStreetGeocoder().handleStreetMatching(scoringAddress, candidates, constraints, debugLevel);
            } else {
                geocodeResult.setDataLicensed(candidates.getDataLicensed());
            }
            if (candidates.getCandidates().size() != 0) {
                handler.setGeocodeResult(geocodeResult);
                this.countCandidates(matchResults, geocodeResult);
                this.countCloseMatches(matchResults, geocodeResult);
            }
            if (debugLevel >= 1) {
                MMJLog.getLog().debug(geocodeResult.toString());
            }
            if (geocodeResult.getNumberCloseCandidates() == 0) {
                if (!constraints.isReturnCloseCandidatesOnly() && geocodeResult.getNumberCandidates() != 0) {
                    if (savedMatchedCandidates == null) {
                        savedMatchedCandidates = matchResults;
                    } else if (candidates.getCandidates().size() != 0) {
                        ((ICoreStreetGeocoder)((Object)handler)).getStreetSingleAddressGeocoder().combineCandidateLists(savedMatchedCandidates, matchResults);
                        handler.setGeocodeResult(geocodeResult);
                        this.countCandidates(savedMatchedCandidates, geocodeResult);
                    }
                }
                handler.setIntermediateMatchResults(matchResults);
                m_tryMoreCases = ((ICoreStreetGeocoder)((Object)handler)).getStreetSingleAddressGeocoder().generateNewCase(constraints);
                if (m_tryMoreCases && debugLevel >= 1) {
                    MMJLog.getLog().debug("Parsed address: " + handler.getParsedAddress().toString());
                    MMJLog.getLog().debug("Search parsed address: " + ((ICoreStreetGeocoder)((Object)handler)).getSearchParsedAddress());
                }
                if (m_tryMoreCases || !isDualAddress) continue;
                if (doPOBoxFirst) {
                    if (!isPOBox) continue;
                    Address pa = originalDualParsedAddress;
                    handler.setParsedAddress(pa);
                    ((ICoreStreetGeocoder)((Object)handler)).setSearchParsedAddress(pa);
                    m_tryMoreCases = true;
                    if (((ICoreStreetGeocoder)((Object)handler)).getStreetSingleAddressGeocoder() instanceof IResettableStreetSingleAddressGeocoder) {
                        ((IResettableStreetSingleAddressGeocoder)((ICoreStreetGeocoder)((Object)handler)).getStreetSingleAddressGeocoder()).resetRetryCases(constraints);
                    }
                    constraints.removeCustomObject("POBOX_MATCH_IN_PROGRESS");
                    isPOBox = false;
                    continue;
                }
                if (constraints.containsCustomObjectKey("POBOX_MATCH_IN_PROGRESS")) continue;
                m_tryMoreCases = true;
                constraints.setCustomString("POBOX_MATCH_IN_PROGRESS", "true");
                Address spa = ((ICoreStreetGeocoder)((Object)handler)).getSearchParsedAddress();
                ((ICoreStreetGeocoder)((Object)handler)).setSearchParsedAddress(this.makePOBoxAddress(spa, (IPOBoxHandler)((Object)handler)));
                Address pa = handler.getParsedAddress();
                handler.setParsedAddress(this.makePOBoxAddress(pa, (IPOBoxHandler)((Object)handler)));
                handler.getParsedAddress().getAdditionalFields().put("POBOX_MATCH_IN_PROGRESS", "");
                if (!(((ICoreStreetGeocoder)((Object)handler)).getStreetSingleAddressGeocoder() instanceof IResettableStreetSingleAddressGeocoder)) continue;
                ((IResettableStreetSingleAddressGeocoder)((ICoreStreetGeocoder)((Object)handler)).getStreetSingleAddressGeocoder()).resetRetryCases(constraints);
                continue;
            }
            m_tryMoreCases = false;
            if (constraints.isReturnCloseCandidatesOnly() || savedMatchedCandidates == null) continue;
            ((ICoreStreetGeocoder)((Object)handler)).getStreetSingleAddressGeocoder().combineCandidateLists(savedMatchedCandidates, matchResults);
        }
        handler.setMatchResults(matchResults);
        if (savedMatchedCandidates != null) {
            ((ICoreStreetGeocoder)((Object)handler)).getStreetSingleAddressGeocoder().removeDuplicateCandidates(savedMatchedCandidates);
            matchResults = savedMatchedCandidates;
            handler.setMatchResults(matchResults);
            handler.setGeocodeResult(geocodeResult);
            this.countCandidates(matchResults, geocodeResult);
            this.countCloseMatches(matchResults, geocodeResult);
        }
        if (constraints.isReturnParsedInputAddress()) {
            ParsedInputAddress parsedInputAddress = this.populateParsedInputAddress(handler, constraints);
            geocodeResult.setParsedInput(parsedInputAddress);
        }
    }

    protected ParsedInputAddress populateParsedInputAddress(IHandler handler, IConstraints constraints) {
        boolean isDualAddress;
        Address pa = handler.getParsedAddress();
        String c_code = null;
        if (pa.getMainAddress() == null && pa.getPostThoroughfareType() == null && pa.getPreThoroughfareType() == null) {
            Address tmpaddr = handler.getInputAddress();
            if (tmpaddr.getPostThoroughfareType() != null) {
                pa.setPostThoroughfareType(tmpaddr.getPostThoroughfareType());
            } else if (tmpaddr.getPreThoroughfareType() != null) {
                pa.setPreThoroughfareType(tmpaddr.getPreThoroughfareType());
            }
        }
        pa.getAdditionalFields().put("input_mainaddress", handler.getInputAddress().getMainAddress());
        if (handler.getInputAddress().getAdditionalFields().get("highest_scoring_language") != null) {
            c_code = (String)handler.getInputAddress().getAdditionalFields().get("highest_scoring_language");
            pa.getAdditionalFields().put("highest_scoring_language", c_code);
        }
        ParsedInputAddress parsedInputAddress = (ParsedInputAddress)handler.getParsedInputAddressHelper().AdjustParsedInputAddress(pa);
        if (handler.isParsedIntersection() && parsedInputAddress.getFormattedInputStreet() != null && ((ICoreStreetGeocoder)((Object)handler)).getSecondParsedAddress() != null) {
            Address addr = ((ICoreStreetGeocoder)((Object)handler)).getSecondParsedAddress();
            addr.getAdditionalFields().put("input_mainaddress", handler.getInputAddress().getMainAddress());
            addr.getAdditionalFields().put("highest_scoring_language", c_code);
            ParsedInputAddress pia2 = (ParsedInputAddress)handler.getParsedInputAddressHelper().AdjustParsedInputAddress(addr);
            ParsedInputAddress xsectPia = new ParsedInputAddress();
            xsectPia.setCountry(pia2.getCountry());
            xsectPia.setMainAddress(parsedInputAddress.getFormattedInputStreet());
            xsectPia.setGenericField2(pia2.getFormattedInputStreet());
            xsectPia.setAreaName1(pia2.getAreaName1());
            xsectPia.setAreaName2(pia2.getAreaName2());
            xsectPia.setAreaName3(pia2.getAreaName3());
            xsectPia.setAreaName4(pia2.getAreaName4());
            xsectPia.setPostCode1(pia2.getPostCode1());
            xsectPia.setPostCode2(pia2.getPostCode2());
            if (xsectPia.getMainAddress() != null) {
                StringBuilder FormattedInStreet = new StringBuilder(xsectPia.getMainAddress());
                String specifier = ParsedInputAddressUtils.getSpecialIntersectionSpecifier(xsectPia.getAdditionalFieldForKey("input_mainaddress"));
                FormattedInStreet.append(' ');
                if (specifier != null) {
                    FormattedInStreet.append(specifier);
                } else {
                    FormattedInStreet.append("&& ");
                }
                FormattedInStreet.append(xsectPia.getGenericField2());
                xsectPia.setFormattedInputStreet(FormattedInStreet.toString());
                return xsectPia;
            }
        }
        parsedInputAddress.getAdditionalFields().remove("input_mainaddress");
        if (parsedInputAddress.getAdditionalFields().size() > 1) {
            String savedFInstreet = (String)parsedInputAddress.getAdditionalFields().get("FormattedInputStreet");
            parsedInputAddress.getAdditionalFields().clear();
            parsedInputAddress.getAdditionalFields().put("FormattedInputStreet", savedFInstreet);
        }
        parsedInputAddress.setGenericField1(null);
        parsedInputAddress.setGenericField2(null);
        parsedInputAddress.setGenericField3(null);
        parsedInputAddress.setGenericField4(null);
        boolean bl = isDualAddress = handler instanceof IPOBoxHandler && ((IPOBoxHandler)((Object)handler)).isDualAddress();
        if (isDualAddress) {
            String check;
            if (Boolean.valueOf(constraints.getCustomString("POBOX_MATCH_IN_PROGRESS", "false")).booleanValue()) {
                check = constraints.getCustomString("DualAddressParsedStreet");
                if (check != null) {
                    parsedInputAddress.getAdditionalFields().put("DualAddressParsedStreet", check);
                }
                parsedInputAddress.setUnitType(null);
                parsedInputAddress.setUnitValue(null);
            } else {
                check = constraints.getCustomString("DualAddressParsedPOBox");
                if (check != null) {
                    parsedInputAddress.getAdditionalFields().put("DualAddressParsedPOBox", check);
                }
            }
            constraints.removeCustomObject("DualAddressParsedStreet");
            constraints.removeCustomObject("DualAddressParsedPOBox");
        }
        return parsedInputAddress;
    }

    private void countCandidates(List candidateList, GeocodeResult geocodeResult) {
        if (candidateList == null || candidateList.isEmpty()) {
            return;
        }
        geocodeResult.setNumberCandidates(candidateList.size());
    }

    private void countCloseMatches(List candidateList, GeocodeResult geocodeResult) {
        int closeMatchCount = 0;
        if (candidateList == null || candidateList.isEmpty()) {
            return;
        }
        Iterator candidateIterator = candidateList.iterator();
        boolean done = false;
        while (candidateIterator.hasNext() && !done) {
            ICandidate candidate = (ICandidate)candidateIterator.next();
            if (candidate.isCloseMatch()) {
                ++closeMatchCount;
                continue;
            }
            done = true;
        }
        geocodeResult.setNumberCloseCandidates(closeMatchCount);
    }

    private void printIntersectionCandidateInfo(List matchResults) {
        if (matchResults == null || matchResults.isEmpty()) {
            MMJLog.getLog().debug("No Candidates.");
            return;
        }
        for (InternalIntersectionCandidateAddress intersection : matchResults) {
            MMJLog.getLog().debug(intersection.toString());
        }
    }

    private void printCandidateInfo(IRetrievedCandidates candidates) {
        if (candidates.getCandidates() != null && !candidates.getCandidates().isEmpty()) {
            List candidatesList = candidates.getCandidates();
            for (ICandidate thisOne : candidatesList) {
                MMJLog.getLog().debug(thisOne.toString());
                MMJLog.getLog().debug(this.lineSeparator);
            }
        } else {
            MMJLog.getLog().debug("No Candidates.");
        }
    }

    protected Address makePOBoxAddress(Address address, IPOBoxHandler handler) {
        address.setMainAddress(handler.getPOBoxKey());
        address.setAddressNumber(handler.getPOBoxNumber());
        address.setPreAddress(null);
        address.setPostAddress(null);
        address.setPreDirectional(null);
        address.setPreThoroughfareType(null);
        address.setPostDirectional(null);
        address.setPostThoroughfareType(null);
        address.setUnitValue(null);
        address.setUnitType(null);
        return address;
    }

    protected String buildParsedStreetDualAddress(Address address) {
        StringBuilder stringBuilder = new StringBuilder(40);
        String tmp = address.getAddressNumber();
        if (tmp != null && !tmp.isEmpty()) {
            stringBuilder.append(tmp);
            stringBuilder.append(' ');
        }
        if ((tmp = address.getPreAddress()) != null && !tmp.isEmpty()) {
            stringBuilder.append(tmp);
            stringBuilder.append(' ');
        }
        if ((tmp = address.getPreDirectional()) != null && !tmp.isEmpty()) {
            stringBuilder.append(tmp);
            stringBuilder.append(' ');
        }
        if ((tmp = address.getPreThoroughfareType()) != null && !tmp.isEmpty()) {
            stringBuilder.append(tmp);
            stringBuilder.append(' ');
        }
        if ((tmp = address.getMainAddress()) != null && !tmp.isEmpty()) {
            stringBuilder.append(tmp);
            stringBuilder.append(' ');
        }
        if ((tmp = address.getPostThoroughfareType()) != null && !tmp.isEmpty()) {
            stringBuilder.append(tmp);
            stringBuilder.append(' ');
        }
        if ((tmp = address.getPostDirectional()) != null && !tmp.isEmpty()) {
            stringBuilder.append(tmp);
            stringBuilder.append(' ');
        }
        if ((tmp = address.getPostAddress()) != null && !tmp.isEmpty()) {
            stringBuilder.append(tmp);
            stringBuilder.append(' ');
        }
        if (stringBuilder.length() > 0) {
            return stringBuilder.toString().trim();
        }
        return null;
    }

    protected String buildParsedPoBoxDualAddress(IHandler handler) {
        String tmp;
        if (handler instanceof IPOBoxHandler && (tmp = ((IPOBoxHandler)((Object)handler)).getPOBoxKey()) != null) {
            StringBuilder stringBuilder = new StringBuilder(12);
            stringBuilder.append(tmp);
            if (stringBuilder.length() > 0 && (tmp = ((IPOBoxHandler)((Object)handler)).getPOBoxNumber()) != null) {
                stringBuilder.append(' ');
                stringBuilder.append(tmp);
            }
            return stringBuilder.toString();
        }
        return null;
    }
}

