/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.core.geographic;

import com.mapinfo.mapmarker.GeocodeResult;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.MMInternalFatalException;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.core.IRetrievedCandidates;
import com.mapinfo.mapmarker.core.geographic.ICoreGeographicGeocoder;
import com.mapinfo.mapmarker.core.geographic.IGeographicGeocoder;
import com.mapinfo.mapmarker.utils.DebugLevel;
import com.mapinfo.mapmarker.utils.MMJLog;
import java.util.Iterator;
import java.util.List;

public final class CoreGeographicGeocoder
implements IGeographicGeocoder {
    private static String lineSeparator = System.getProperty("line.separator");

    @Override
    public GeocodeResult geocodeGeographic(IConstraints constraints) throws MapMarkerInternalException, MMInternalFatalException {
        List matchResults;
        GeocodeResult geocodeResult = new GeocodeResult();
        IHandler handler = constraints.getHandler();
        if (handler.getParsedAddressArray() == null) {
            return geocodeResult;
        }
        if (DebugLevel.getDebugLevel(1) >= 1) {
            MMJLog.getLog().debug("ParsedAddress for Geographic geocode:");
            MMJLog.getLog().debug(handler.getParsedAddress().toString());
        }
        handler.getLocalConstraintsHelper().addLocalGeographicConstraints(constraints, handler);
        IRetrievedCandidates candidates = handler.getDataManager().retrieveGeographicCentroids(handler.getParsedAddress(), constraints);
        if (DebugLevel.getDebugLevel(1) >= 3) {
            MMJLog.getLog().debug("Unmatched geographic candidates:");
            this.printCandidateInfo(candidates);
        }
        if (candidates.getCandidates().size() != 0) {
            matchResults = ((ICoreGeographicGeocoder)((Object)handler)).getGeographicMatcher().matchGeographic(constraints, handler.getParsedAddress(), candidates);
            this.countCandidates(matchResults, geocodeResult);
            this.countCloseMatches(matchResults, geocodeResult);
            handler.setGeocodeResult(geocodeResult);
            handler.setMatchResults(matchResults);
        }
        if (DebugLevel.getDebugLevel(1) >= 2) {
            MMJLog.getLog().debug("Matched geographic candidates:");
            this.printCandidateInfo(candidates);
        }
        if (geocodeResult.getNumberCloseCandidates() > 1) {
            matchResults = ((ICoreGeographicGeocoder)((Object)constraints.getHandler())).getGeographicCentroidFilter().filterGeographicCloseMatches(handler);
            this.countCandidates(matchResults, geocodeResult);
            this.countCloseMatches(matchResults, geocodeResult);
            handler.setGeocodeResult(geocodeResult);
            handler.setMatchResults(matchResults);
        }
        return geocodeResult;
    }

    private void countCandidates(List candidateList, GeocodeResult geocodeResult) {
        if (candidateList == null || candidateList.isEmpty()) {
            return;
        }
        geocodeResult.setNumberCandidates(candidateList.size());
    }

    private void countCloseMatches(List candidateList, GeocodeResult geocodeResult) {
        int closeMatchCount = 0;
        if (candidateList == null || candidateList.isEmpty()) {
            return;
        }
        Iterator candidateIterator = candidateList.iterator();
        boolean done = false;
        while (candidateIterator.hasNext() && !done) {
            ICandidate candidate = (ICandidate)candidateIterator.next();
            if (candidate.isCloseMatch()) {
                ++closeMatchCount;
                continue;
            }
            done = true;
        }
        geocodeResult.setNumberCloseCandidates(closeMatchCount);
    }

    private void printCandidateInfo(IRetrievedCandidates candidates) {
        if (candidates.getCandidates() != null && !candidates.getCandidates().isEmpty()) {
            List candidatesList = candidates.getCandidates();
            for (ICandidate thisOne : candidatesList) {
                MMJLog.getLog().debug(thisOne.toString());
                MMJLog.getLog().debug(lineSeparator);
            }
        } else {
            MMJLog.getLog().debug("No Candidates.");
        }
    }
}

