/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.core.interpolator;

import com.mapinfo.mapmarker.core.reverseGeocode.ReverseGeocodeUtils;
import com.mapinfo.mapmarker.utils.geometry.SegmentGeometryUtils;
import com.mapinfo.mapmarker.utils.geometry.SplitSegment;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.unit.AngularUnit;
import com.mapinfo.midev.unit.Length;
import com.mapinfo.midev.unit.LinearUnit;
import java.util.List;

public class Interpolator {
    public static DirectPosition interpolate(List points, boolean onLeftSide, double percentage, Length cornerOffset, Length streetOffset) {
        int pointCount;
        int n = pointCount = points == null ? 0 : points.size();
        if (pointCount < 1) {
            return null;
        }
        DirectPosition point0 = (DirectPosition)points.get(0);
        boolean bFoundDifferentPoint = false;
        for (int i = 1; i < pointCount; ++i) {
            DirectPosition nextPoint = (DirectPosition)points.get(i);
            if (point0.equals((Object)nextPoint)) continue;
            bFoundDifferentPoint = true;
            break;
        }
        if (!bFoundDifferentPoint) {
            return point0;
        }
        PointOnLine position = Interpolator.calcPositionOnPath(cornerOffset, points, percentage);
        DirectPosition result = Interpolator.setBackPerpendicular(position, streetOffset, onLeftSide);
        return result;
    }

    public static DirectPosition interpolateShapePath(List points) {
        return Interpolator.interpolate(points, true, 0.5, null, null);
    }

    public static DirectPosition projectFromSegment(List<DirectPosition> segment, DirectPosition point, Length offset) {
        DirectPosition pointToProjectFrom = null;
        SplitSegment split = SegmentGeometryUtils.split(segment, point);
        if (split.getSegment1() != null) {
            pointToProjectFrom = (DirectPosition)split.getSegment1().get(split.getSegment1().size() - 1);
        }
        if (pointToProjectFrom == null || ReverseGeocodeUtils.getDistance(point, segment) < ReverseGeocodeUtils.getDistance(point, pointToProjectFrom)) {
            pointToProjectFrom = Interpolator.findClosestPoint(point, segment);
        }
        return Interpolator.projectFrom(pointToProjectFrom, point, offset);
    }

    private static DirectPosition projectFrom(DirectPosition from, DirectPosition other, Length offset) {
        if (from.equals((Object)other)) {
            return null;
        }
        double offsetInDegrees = Interpolator.convertToDegrees(offset);
        double segmentLength = Interpolator.calcSegmentLength(from, other);
        double percentage = offsetInDegrees / segmentLength;
        double x = from.getX() + percentage * (other.getX() - from.getX());
        double y = from.getY() + percentage * (other.getY() - from.getY());
        return new DirectPosition(x, y);
    }

    private static DirectPosition findClosestPoint(DirectPosition point, List<DirectPosition> segment) {
        DirectPosition closest = null;
        double closestDistance = Double.MAX_VALUE;
        for (DirectPosition possible : segment) {
            double distance = ReverseGeocodeUtils.getDistance(point, possible);
            if (!(distance < closestDistance)) continue;
            closestDistance = distance;
            closest = possible;
        }
        return closest;
    }

    private static PointOnLine calcPositionOnPath(Length inset, List path, double interpolationFraction) {
        int pointCount = path.size();
        if (pointCount == 1) {
            return new PointOnLine((DirectPosition)path.get(0), new Line((DirectPosition)path.get(0), (DirectPosition)path.get(0)));
        }
        PointOnLine result = null;
        double insetInDegrees = 0.0;
        if (inset != null) {
            insetInDegrees = Interpolator.convertToDegrees(inset);
        }
        double totalLength = 0.0;
        for (int i = 0; i < pointCount - 1; ++i) {
            totalLength += Interpolator.calcSegmentLength((DirectPosition)path.get(i), (DirectPosition)path.get(i + 1));
        }
        if (insetInDegrees > totalLength / 2.0) {
            insetInDegrees = totalLength / 2.0;
        }
        double interpolationLength = insetInDegrees + interpolationFraction * (totalLength - 2.0 * insetInDegrees);
        double position = 0.0;
        for (int i = 0; i < pointCount - 1; ++i) {
            DirectPosition nextPoint;
            DirectPosition currentPoint = (DirectPosition)path.get(i);
            double length = Interpolator.calcSegmentLength(currentPoint, nextPoint = (DirectPosition)path.get(i + 1));
            if (!(length > 0.0)) continue;
            if (position + length < interpolationLength) {
                position += length;
                continue;
            }
            double fractionalLength = (interpolationLength - position) / length;
            double x = currentPoint.getX() + fractionalLength * (nextPoint.getX() - currentPoint.getX());
            double y = currentPoint.getY() + fractionalLength * (nextPoint.getY() - currentPoint.getY());
            result = new PointOnLine(new DirectPosition(x, y), new Line(currentPoint, nextPoint));
            break;
        }
        if (result == null) {
            result = new PointOnLine((DirectPosition)path.get(0), new Line((DirectPosition)path.get(0), (DirectPosition)path.get(0)));
        }
        return result;
    }

    private static DirectPosition setBackPerpendicular(PointOnLine position, Length setback, boolean onLeftSide) {
        DirectPosition point = position.getPoint();
        Line line = position.getLine();
        DirectPosition result = new DirectPosition(position.getPoint());
        if (setback != null && setback.getValue() != 0.0) {
            double setbackInDegrees = Interpolator.convertToDegrees(setback);
            double latitudeFactor = Math.cos(Math.toRadians(point.getY()));
            if (onLeftSide) {
                if (line.getEnd().getX() == line.getStart().getX()) {
                    if (line.getEnd().getY() > line.getStart().getY()) {
                        result.setX(result.getX() - setbackInDegrees / latitudeFactor);
                    } else {
                        result.setX(result.getX() + setbackInDegrees / latitudeFactor);
                    }
                } else {
                    double slope = (line.getEnd().getY() - line.getStart().getY()) / (line.getEnd().getX() - line.getStart().getX());
                    double parametricDelta = setbackInDegrees / Math.sqrt(1.0 + slope * slope);
                    if (line.getEnd().getX() > line.getStart().getX()) {
                        result.setX(result.getX() - slope * parametricDelta / latitudeFactor);
                        result.setY(result.getY() + parametricDelta);
                    } else {
                        result.setX(result.getX() + slope * parametricDelta / latitudeFactor);
                        result.setY(result.getY() - parametricDelta);
                    }
                }
            } else if (line.getEnd().getX() == line.getStart().getX()) {
                if (line.getEnd().getY() > line.getStart().getY()) {
                    result.setX(result.getX() + setbackInDegrees / latitudeFactor);
                } else {
                    result.setX(result.getX() - setbackInDegrees / latitudeFactor);
                }
            } else {
                double slope = (line.getEnd().getY() - line.getStart().getY()) / (line.getEnd().getX() - line.getStart().getX());
                double parametricDelta = setbackInDegrees / Math.sqrt(1.0 + slope * slope);
                if (line.getEnd().getX() > line.getStart().getX()) {
                    result.setX(result.getX() + slope * parametricDelta / latitudeFactor);
                    result.setY(result.getY() - parametricDelta);
                } else {
                    result.setX(result.getX() - slope * parametricDelta / latitudeFactor);
                    result.setY(result.getY() + parametricDelta);
                }
            }
        }
        return result;
    }

    private static double calcSegmentLength(DirectPosition start, DirectPosition end) {
        double deltaY = end.getY() - start.getY();
        double avgY = (start.getY() + end.getY()) / 2.0;
        double deltaX = Math.cos(Math.toRadians(avgY)) * (start.getX() - end.getX());
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY);
    }

    private static double convertToDegrees(Length length) {
        double valueInMeters = length.getValue(LinearUnit.METER);
        double valueInRadians = valueInMeters / 6370997.0;
        return AngularUnit.convert((double)valueInRadians, (AngularUnit)AngularUnit.RADIAN, (AngularUnit)AngularUnit.DEGREE);
    }

    private static class Line {
        private DirectPosition start;
        private DirectPosition end;

        Line(DirectPosition to, DirectPosition from) {
            this.start = to;
            this.end = from;
        }

        DirectPosition getStart() {
            return this.start;
        }

        DirectPosition getEnd() {
            return this.end;
        }
    }

    private static class PointOnLine {
        private DirectPosition point;
        private Line line;

        PointOnLine(DirectPosition p, Line l) {
            this.point = p;
            this.line = l;
        }

        DirectPosition getPoint() {
            return this.point;
        }

        Line getLine() {
            return this.line;
        }
    }
}

