/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.core.multicountry;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.Constraints;
import com.mapinfo.mapmarker.GeocodableAddressCreationException;
import com.mapinfo.mapmarker.GeocodeResult;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.IGeocodeConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.core.CoreGeocoder;
import com.mapinfo.mapmarker.core.CoreHandler;
import com.mapinfo.mapmarker.core.IGeocoder;
import com.mapinfo.mapmarker.core.multicountry.IGeocodeInputFilter;
import com.mapinfo.mapmarker.core.parser.CoreCountryParseRule;
import com.mapinfo.mapmarker.core.parser.CoreIntersectionParser;
import com.mapinfo.mapmarker.core.parser.CoreParser;
import com.mapinfo.mapmarker.core.parser.IParseRule;
import com.mapinfo.mapmarker.core.singleline.IGeocoderFactory;
import com.mapinfo.mapmarker.core.singleline.ISingleLineParser;
import com.mapinfo.mapmarker.core.singleline.SingleLineGeocoder;
import com.mapinfo.mapmarker.utils.StringUtilities;

public class DefaultGeocodeInputFilter
implements IGeocodeInputFilter {
    IConstraints localConstraints;
    ISingleLineParser localSingleLineParser;
    IParseRule localParseMainAddressRule;
    IParseRule localParsePostAddressRule;
    ParseOnlyGeocodingFactory factory;

    public DefaultGeocodeInputFilter(String countryCode) throws InstantiationException {
        IParseRule mainRule;
        ISingleLineParser parser;
        IConstraints constraints;
        IParseRule postRule;
        Class<?> clazz;
        StringBuilder base = new StringBuilder("com.mapinfo.mapmarker.");
        base.append(countryCode);
        base.append('.');
        StringBuilder sb = new StringBuilder(base);
        sb.append("parser.");
        sb.append(countryCode);
        sb.append("_ParsePostAddressRule");
        try {
            clazz = Class.forName(sb.toString());
            postRule = (IParseRule)clazz.newInstance();
        }
        catch (Throwable t) {
            postRule = null;
        }
        sb = new StringBuilder(base);
        sb.append(countryCode);
        sb.append("_Constraints");
        try {
            clazz = Class.forName(sb.toString());
            constraints = (IConstraints)clazz.newInstance();
        }
        catch (Throwable t) {
            constraints = new Constraints();
        }
        sb = new StringBuilder(base);
        sb.append("singleline.");
        sb.append(countryCode);
        sb.append("SingleLineParser");
        try {
            clazz = Class.forName(sb.toString());
            parser = (ISingleLineParser)clazz.newInstance();
        }
        catch (Throwable t) {
            parser = null;
        }
        sb = new StringBuilder(base);
        sb.append("parser.");
        sb.append(countryCode);
        sb.append("_ParseMainAddressRule");
        try {
            clazz = Class.forName(sb.toString());
            mainRule = (IParseRule)clazz.newInstance();
        }
        catch (Throwable t) {
            mainRule = null;
        }
        if (mainRule == null && postRule == null) {
            throw new InstantiationException();
        }
        this.localConstraints = constraints;
        this.localSingleLineParser = parser;
        this.localParseMainAddressRule = mainRule;
        this.localParsePostAddressRule = postRule;
        this.factory = new ParseOnlyGeocodingFactory(this.localParseMainAddressRule, this.localParsePostAddressRule);
    }

    public DefaultGeocodeInputFilter(IConstraints constraints, ISingleLineParser parser, IParseRule mainRule, IParseRule postRule) {
        this.localConstraints = constraints;
        this.localSingleLineParser = parser;
        this.localParseMainAddressRule = mainRule;
        this.localParsePostAddressRule = postRule;
        this.factory = new ParseOnlyGeocodingFactory(this.localParseMainAddressRule, this.localParsePostAddressRule);
    }

    @Override
    public double scoreAddressForCountry(Address address, String concatenatedFields) {
        String tfareType;
        double score = 0.0;
        CandidateAddress cand = this.getBestParsing(address);
        if (cand == null) {
            return 0.0;
        }
        if (StringUtilities.isEmpty(cand.getPostCode1()) && StringUtilities.isEmpty(cand.getAreaName3())) {
            return 0.01;
        }
        if (!StringUtilities.isEmpty(cand.getPostCode1())) {
            score += 0.3;
        }
        if (!StringUtilities.isEmpty(cand.getAreaName3())) {
            score += 0.15;
        }
        if (!StringUtilities.isEmpty(cand.getAreaName1())) {
            score += 0.1;
        }
        if (StringUtilities.isEmpty(tfareType = cand.getPreThoroughfareType())) {
            tfareType = cand.getPostThoroughfareType();
        }
        if (!StringUtilities.isEmpty(tfareType) && !StringUtilities.isEmpty(cand.getMainAddress())) {
            score += 0.4;
        }
        return score;
    }

    public CandidateAddress getBestParsing(Address address) {
        try {
            IGeocoder geocoder = SingleLineGeocoder.getGeocoder(this.factory, this.localSingleLineParser, address, this.localConstraints);
            geocoder.prepareAndParse(0, this.localConstraints);
            GeocodeResult gr = geocoder.standardize(this.localConstraints);
            if (gr.getNumberCandidates() > 0) {
                return geocoder.getIndexedCandidate(0, this.localConstraints);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static class ParseOnlyGeocodingFactory
    implements IGeocoderFactory {
        IParseRule main;
        IParseRule post;

        public ParseOnlyGeocodingFactory(IParseRule mainAddressRule, IParseRule postAddressRule) {
            this.main = mainAddressRule;
            this.post = postAddressRule;
        }

        @Override
        public IGeocoder createGeocoder(Address address, IGeocodeConstraints constraints) throws GeocodableAddressCreationException {
            CoreHandler coreHandler = new CoreHandler();
            CoreParser coreParser = new CoreParser();
            coreParser.addRule(2, new CoreCountryParseRule());
            coreParser.addRule(4, this.post);
            if (this.main != null) {
                coreParser.addRule(1, this.main);
            }
            coreHandler.setParser(coreParser);
            coreHandler.setIntersectionParser(new CoreIntersectionParser());
            coreHandler.setInputAddress(address);
            coreHandler.setStandardizeSupported(true);
            return new CoreGeocoder(coreHandler);
        }
    }
}

