/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.core.multicountry;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.CandidateRange;
import com.mapinfo.mapmarker.Constraints;
import com.mapinfo.mapmarker.GeocodableAddressCreationException;
import com.mapinfo.mapmarker.GeocodeResult;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.IGeocodeConstraints;
import com.mapinfo.mapmarker.MMGeneralGeocoderException;
import com.mapinfo.mapmarker.MMInternalFatalException;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.CountryGeographyInfoImpl;
import com.mapinfo.mapmarker.common.ICountryGeographyInfo;
import com.mapinfo.mapmarker.core.IGeocoder;
import com.mapinfo.mapmarker.core.multicountry.CandidateAddressComparator;
import com.mapinfo.mapmarker.core.multicountry.CountryTuner;
import com.mapinfo.mapmarker.core.multicountry.MultiCountryGeocoderHelper;
import com.mapinfo.mapmarker.user.ClientGeocodeResponse;
import com.mapinfo.mapmarker.user.GeocodeConstraints;
import com.mapinfo.mapmarker.user.MMJEngine;
import com.mapinfo.mapmarker.user.MapMarkerJavaAPI;
import com.mapinfo.mapmarker.utils.MMJLog;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;

public class MultiCountryGeocoder
implements IGeocoder {
    private static String m_localStrings = "com.mapinfo.mapmarker.GeocodableAddressStrings";
    private ResourceBundle m_errorBundle;
    Address m_address;
    IGeocodeConstraints m_constraints;
    protected MapMarkerJavaAPI m_geocoder;
    private String m_originalCountry;
    List<CandidateAddress> m_candidates;
    List<CandidateAddress> defaultGeocoderCandidates;
    int defaultGeocoderTotalPossible = -1;
    int defaultGeocoderTotalPossibleClose = -1;
    protected RankOnlyCandidateComparator rankOnlyCandidateComparator = new RankOnlyCandidateComparator();
    protected MultiCountryGeocoderHelper helper;
    protected CandidateAddressComparator comparator;
    private static final int MAX_XWG_SUGGESTIONS = 30;
    private static final int MAX_CANDIDATE_COUNT_FROM_DEFAULT_GEOCODER = 3;

    public MultiCountryGeocoder(Address address, IGeocodeConstraints constraints, MultiCountryGeocoderHelper helper) {
        this.helper = helper;
        this.m_address = address;
        if (address != null) {
            this.m_originalCountry = address.getCountry();
        }
        this.m_constraints = constraints;
        this.m_geocoder = new MMJEngine();
        this.m_candidates = new ArrayList<CandidateAddress>();
        this.defaultGeocoderCandidates = new ArrayList<CandidateAddress>();
        helper.applyUserPreferences(constraints);
        this.comparator = new CandidateAddressComparator(helper.getAvailableCountries());
    }

    @Override
    public GeocodeResult geocode(IConstraints constraints) throws MMInternalFatalException, MapMarkerInternalException {
        return this.doGeocode(constraints, 0);
    }

    @Override
    public GeocodeResult geocodePostal(IConstraints constraints) throws MapMarkerInternalException, MMInternalFatalException {
        return this.doGeocode(constraints, 1);
    }

    @Override
    public GeocodeResult geocodeGeographic(IConstraints constraints) throws MapMarkerInternalException, MMInternalFatalException {
        return this.doGeocode(constraints, 4);
    }

    @Override
    public CandidateAddress getIndexedCandidate(int i, IConstraints preferences) throws MapMarkerInternalException {
        return this.m_candidates.get(i);
    }

    @Override
    public CandidateAddress getIndexedCoords(int candIndex, CandidateRange range, IConstraints preferences) throws MapMarkerInternalException {
        return null;
    }

    @Override
    public void prepareAndParse(int geocodeType, IConstraints constraints) throws MapMarkerInternalException {
    }

    @Override
    public GeocodeResult standardize(IConstraints constraints) throws MapMarkerInternalException {
        throw new MMGeneralGeocoderException(2307);
    }

    @Override
    public GeocodeResult browse(IConstraints constraints) throws MapMarkerInternalException, MMInternalFatalException {
        throw new MMGeneralGeocoderException(2307);
    }

    @Override
    public GeocodeResult geocodeCustom(int geocodeType, IConstraints constraints) throws MapMarkerInternalException {
        throw new MMGeneralGeocoderException(2307);
    }

    public ResourceBundle getErrorBundle() {
        return this.m_errorBundle;
    }

    public String getLocalStrings() {
        return m_localStrings;
    }

    public void setLocalStrings(String localStrings) {
        m_localStrings = localStrings;
    }

    @Override
    public void setErrorBundle(ResourceBundle bundle) {
        this.m_errorBundle = bundle;
    }

    @Override
    public IConstraints convertConstraints(IConstraints constraints) {
        return constraints;
    }

    @Override
    public ICountryGeographyInfo getCountryGeographyInfo() {
        return new CountryGeographyInfoImpl("UNKNOWN");
    }

    protected void reduceCountrySet(IConstraints constraints, String country) {
        Set<String> excludeSet;
        String temp = constraints.getCustomString("COUNTRY_FALLBACK_ENABLED");
        if ("false".equalsIgnoreCase(temp)) {
            this.helper.getCountryList().clear();
            return;
        }
        if (StringUtilities.isEmpty(country)) {
            if ("false".equalsIgnoreCase(constraints.getCustomString("COUNTRY_FALLBACK_ON_NULL_INPUT_COUNTRY"))) {
                this.helper.getCountryList().clear();
                return;
            }
        } else if ("false".equalsIgnoreCase(constraints.getCustomString("COUNTRY_FALLBACK_ON_UNRECOGNIZED_INPUT_COUNTRY"))) {
            this.helper.getCountryList().clear();
            return;
        }
        if ((excludeSet = this.helper.getExcludedCountriesSet()).size() > 0) {
            this.helper.getCountryList().removeAll(excludeSet);
        }
        if (this.helper.isSearchPreferredCountriesOnly()) {
            ArrayList<String> ordered = new ArrayList<String>();
            for (String prefCountry : this.helper.getPreferredCountriesList()) {
                if (!this.helper.getCountryList().contains(prefCountry)) continue;
                ordered.add(prefCountry);
            }
            this.helper.setCountryList(ordered);
        }
    }

    protected void geocodeCountriesByCharset(Set<String> attemptedCountries, int type, IConstraints constraints, CandidateCounts candidateCounts, CountryTuner tuner) {
        ArrayList<String> countries = new ArrayList<String>();
        countries.addAll(tuner.recommendCountriesByCharset(true, constraints.getCustomString("GG_AVAILABLE_CHARSETS")));
        if (!countries.isEmpty()) {
            List<String> attempted = this.geocodeAllCountriesInList(countries, type, constraints, candidateCounts);
            attemptedCountries.addAll(attempted);
        }
    }

    protected void geocodeCountriesByUnusualPostcodes(Set<String> attemptedCountries, int type, IConstraints constraints, CandidateCounts candidateCounts, CountryTuner tuner) {
        ArrayList<String> countries = new ArrayList<String>();
        countries.addAll(tuner.recommendCountriesWithAlnumPostcodes(countries));
        if (!countries.isEmpty()) {
            boolean old = constraints.isFallbackToGeographic();
            constraints.setFallbackToGeographic(false);
            List<String> attempted = this.geocodeAllCountriesInList(countries, type, constraints, candidateCounts);
            constraints.setFallbackToGeographic(old);
        }
    }

    protected void geocodeCountriesBySpecialRules(Set<String> attemptedCountries, int type, IConstraints constraints, CandidateCounts candidateCounts, CountryTuner tuner) {
        List<String> attempted;
        if (!this.helper.isDetermineCountryByKeyword() && !this.helper.isDetermineCountryByPattern()) {
            return;
        }
        ArrayList<String> countries = new ArrayList<String>();
        if (this.helper.isDetermineCountryByKeyword()) {
            countries.addAll(tuner.recommendCountriesByKeywords(this.helper.isReturnOnFirstCloseStreetCandidates()));
            countries.removeAll(attemptedCountries);
            if (!countries.isEmpty()) {
                attempted = this.geocodeAllCountriesInList(countries, type, constraints, candidateCounts);
                attemptedCountries.addAll(attempted);
                if (candidateCounts.possibleClose > 0 && this.haveCloseStreetCandidate() && this.helper.isReturnOnFirstCloseStreetCandidates()) {
                    return;
                }
            }
        }
        if (this.helper.isDetermineCountryByPattern()) {
            countries.clear();
            countries.addAll(tuner.recommendCountriesByPatterns(this.helper.isReturnOnFirstCloseStreetCandidates()));
            countries.removeAll(attemptedCountries);
            if (!countries.isEmpty()) {
                attempted = this.geocodeAllCountriesInList(countries, type, constraints, candidateCounts);
                attemptedCountries.addAll(attempted);
            }
        }
    }

    protected CandidateCounts buildCandidateCounts() {
        return new CandidateCounts();
    }

    private GeocodeResult doGeocode(IConstraints constraints, int type) throws MapMarkerInternalException, MMInternalFatalException {
        CandidateCounts counts = this.buildCandidateCounts();
        if (!this.helper.isInputCountryValid()) {
            HashSet<String> attemptedCountries = new HashSet<String>();
            if (!this.helper.getPrimaryGeocoderCountryCodes().isEmpty()) {
                List<String> attempted = this.geocodeAllCountriesInList(this.helper.getPrimaryGeocoderCountryCodes(), type, constraints, counts);
                attemptedCountries.addAll(attempted);
            }
            if (counts.possibleClose == 0) {
                GeocodeResult worldResult;
                CountryTuner tuner = new CountryTuner(this.m_address);
                this.geocodeCountriesByCharset(attemptedCountries, type, constraints, counts, tuner);
                if (counts.possibleClose == 0 || !this.haveCloseStreetCandidate() || !this.helper.isReturnOnFirstCloseStreetCandidates()) {
                    this.geocodeCountriesByUnusualPostcodes(attemptedCountries, type, constraints, counts, tuner);
                }
                if (counts.possibleClose == 0 || !this.haveCloseStreetCandidate() || !this.helper.isReturnOnFirstCloseStreetCandidates()) {
                    this.geocodeCountriesBySpecialRules(attemptedCountries, type, constraints, counts, tuner);
                }
                if (!(counts.possibleClose != 0 && this.haveCloseStreetCandidate() && this.helper.isReturnOnFirstCloseStreetCandidates() || (worldResult = this.geocodeWorldGeocoderSuggestions(attemptedCountries, type, constraints, counts)) == null)) {
                    return worldResult;
                }
                if (counts.possibleClose == 0 && !this.helper.isSearchWorldGeocoderRecommendationsOnly()) {
                    this.reduceCountrySet(constraints, this.m_address.getCountry());
                    this.helper.getCountryList().removeAll(attemptedCountries);
                    List<String> attempted = this.geocodeAllCountriesInList(this.helper.getCountryList(), type, constraints, counts);
                    attemptedCountries.addAll(attempted);
                }
            }
        }
        if (counts.possibleClose == 0) {
            if (StringUtilities.equalStrings(this.helper.getDefaultGeocoderCountryCode(), "XWG") && !constraints.isFallbackToGeographic()) {
                return new GeocodeResult();
            }
            this.m_address.setCountry(this.m_originalCountry);
            if (this.defaultGeocoderTotalPossible >= 0) {
                return this.buildDefaultResults();
            }
            try {
                IGeocoder defaultGeocoder = this.getDefaultGeocoder();
                if (defaultGeocoder != null) {
                    GeocodeResult gResult = this.internalGeocode(type, constraints, defaultGeocoder);
                    this.replaceResults(defaultGeocoder, gResult, counts, constraints);
                }
            }
            catch (MMInternalFatalException defaultGeocoder) {
                // empty catch block
            }
        }
        this.comparator.getAvailableCountrySet().addAll(this.helper.getAvailableCountries());
        if (StringUtilities.equalStrings(this.helper.getDefaultGeocoderCountryCode(), "XWG") && constraints.isFallbackToGeographic()) {
            this.addResultsFromDefaultGeocoder(counts, this.comparator, constraints.getMaxCandidates());
        }
        GeocodeResult compositeCGR = new GeocodeResult();
        compositeCGR.setNumberCandidates(counts.possibleCandidates);
        compositeCGR.setNumberCloseCandidates(counts.possibleClose);
        compositeCGR.setNumberCandidates(counts.actualCount);
        if (constraints.isReturnCloseCandidatesOnly() && (constraints.getMaxCandidates() < 0 || constraints.getMaxCandidates() > counts.actualCount)) {
            compositeCGR.setNumberCloseCandidates(counts.actualCount);
        }
        return compositeCGR;
    }

    protected void addResultsFromDefaultGeocoder(CandidateCounts counts, CandidateAddressComparator comparator, int size) {
        if (this.defaultGeocoderTotalPossibleClose > 0 && !counts.geocodersProvidingResults.contains(this.helper.getDefaultGeocoderCountryCode())) {
            int countToGrab = Math.min(3, this.defaultGeocoderCandidates.size());
            countToGrab = Math.min(countToGrab, this.defaultGeocoderTotalPossibleClose);
            this.mergeNewCandidates(new CandidateIterator(this.defaultGeocoderCandidates), comparator, this.m_candidates.size() + countToGrab);
            counts.actualCount += countToGrab;
            counts.possibleClose += this.defaultGeocoderTotalPossibleClose;
            counts.possibleCandidates += this.defaultGeocoderTotalPossible;
            counts.geocodersProvidingResults.add(this.helper.getDefaultGeocoderCountryCode());
        }
    }

    protected GeocodeResult replaceResults(IGeocoder geocoder, GeocodeResult result, CandidateCounts counts, IConstraints constraints) throws MapMarkerInternalException {
        if (result != null) {
            counts.possibleCandidates += result.getNumberCandidates();
            counts.possibleClose += result.getNumberCloseCandidates();
            int toBeReturned = result.getNumberCandidates();
            int constraintsMax = constraints.getMaxCandidates();
            if (constraintsMax > 0) {
                toBeReturned = Math.min(result.getNumberCandidates(), constraints.getMaxCandidates());
            }
            if (constraints.isReturnCloseCandidatesOnly()) {
                toBeReturned = Math.min(result.getNumberCloseCandidates(), toBeReturned);
            }
            counts.actualCount += toBeReturned;
            this.m_candidates.clear();
            for (int i = 0; i < toBeReturned; ++i) {
                CandidateAddress cand = geocoder.getIndexedCandidate(i, constraints);
                this.m_candidates.add(cand);
            }
        }
        return result;
    }

    protected GeocodeResult buildDefaultResults() throws MapMarkerInternalException {
        this.m_candidates.clear();
        GeocodeResult result = new GeocodeResult();
        if (this.defaultGeocoderTotalPossible >= 0) {
            String countries = this.m_constraints.getCustomString("GG_AVAILABLE_COUNTRIES");
            boolean bHaveUSA = countries != null && countries.indexOf("USA") >= 0;
            int usaCount = 0;
            if (!this.defaultGeocoderCandidates.isEmpty()) {
                if (!bHaveUSA) {
                    this.m_candidates.addAll(this.defaultGeocoderCandidates);
                } else {
                    for (CandidateAddress cand : this.defaultGeocoderCandidates) {
                        if ("USA".equalsIgnoreCase(cand.getCountry())) {
                            ++usaCount;
                            continue;
                        }
                        this.m_candidates.add(cand);
                    }
                }
            }
            result.setNumberCandidates(this.defaultGeocoderTotalPossible);
            result.setNumberCloseCandidates(this.defaultGeocoderTotalPossibleClose - usaCount);
        }
        return result;
    }

    protected IGeocoder getDefaultGeocoder() throws GeocodableAddressCreationException {
        if (this.helper.getDefaultGeocoderFactory() != null) {
            return this.helper.getDefaultGeocoderFactory().createSpecificGeocodableAddress(this.m_address, this.m_constraints);
        }
        return null;
    }

    protected IGeocoder getWorldGeocoder() throws GeocodableAddressCreationException {
        if (this.helper.getWorldGeocoderFactory() != null) {
            return this.helper.getWorldGeocoderFactory().createSpecificGeocodableAddress(this.m_address, this.m_constraints);
        }
        return null;
    }

    protected GeocodeResult internalGeocode(int type, IConstraints constraints, IGeocoder geocoder) throws MapMarkerInternalException, MMInternalFatalException {
        geocoder.prepareAndParse(type, constraints);
        switch (type) {
            case 0: {
                return geocoder.geocode(constraints);
            }
            case 4: {
                return geocoder.geocodeGeographic(constraints);
            }
            case 1: {
                return geocoder.geocodePostal(constraints);
            }
        }
        return geocoder.geocodeCustom(type, constraints);
    }

    protected GeocodeResult geocodeWorldCentroids(IConstraints constraints, int type, IGeocoder worldGeocoder) throws MapMarkerInternalException, MMInternalFatalException {
        if (worldGeocoder == null) {
            return new GeocodeResult();
        }
        if (constraints == null) {
            constraints = new Constraints();
        }
        ConstraintsBackupValues backupValues = this.updateConstraintsForWorldGeocode(constraints);
        GeocodeResult gResult = this.internalGeocode(type, constraints, worldGeocoder);
        int cc = constraints.getMaxCandidates();
        this.revertConstraintsFromWorldGeocode(constraints, backupValues);
        if (StringUtilities.equalStrings(this.helper.getDefaultGeocoderCountryCode(), "XWG") && !constraints.isFallbackToPostal() && constraints.isFallbackToGeographic() && constraints.isReturnCloseCandidatesOnly() && constraints.getMatchMode() == "DefaultMode" && gResult != null && (cc <= 30 || 30 > gResult.getNumberCloseCandidates())) {
            this.defaultGeocoderTotalPossible = gResult.getNumberCandidates();
            this.defaultGeocoderTotalPossibleClose = gResult.getNumberCloseCandidates();
            this.defaultGeocoderCandidates.clear();
            for (int i = 0; i < this.defaultGeocoderTotalPossibleClose; ++i) {
                CandidateAddress cand = worldGeocoder.getIndexedCandidate(i, constraints);
                this.defaultGeocoderCandidates.add(cand);
            }
        }
        return gResult;
    }

    protected ConstraintsBackupValues updateConstraintsForWorldGeocode(IConstraints constraints) {
        ConstraintsBackupValues values = new ConstraintsBackupValues();
        values.requestedMax = constraints.getMaxCandidates();
        values.requestedClose = constraints.isReturnCloseCandidatesOnly();
        values.geoFallback = constraints.isFallbackToGeographic();
        values.postalFallback = constraints.isFallbackToPostal();
        values.requestedMatchMode = constraints.getMatchMode();
        constraints.setMaxCandidates(30);
        constraints.setReturnCloseCandidatesOnly(false);
        constraints.setFallbackToGeographic(true);
        constraints.setFallbackToPostal(false);
        constraints.setMatchMode("DefaultMode");
        return values;
    }

    protected void revertConstraintsFromWorldGeocode(IConstraints constraints, ConstraintsBackupValues backupValues) {
        constraints.setMaxCandidates(backupValues.requestedMax);
        constraints.setReturnCloseCandidatesOnly(backupValues.requestedClose);
        constraints.setMatchMode(backupValues.requestedMatchMode);
        constraints.setFallbackToGeographic(backupValues.geoFallback);
        constraints.setFallbackToPostal(backupValues.postalFallback);
    }

    private GeocodeResult geocodeWorldGeocoderSuggestions(Set<String> attemptedCountries, int type, IConstraints constraints, CandidateCounts candidateCounts) throws MapMarkerInternalException, MMInternalFatalException {
        if (this.helper.isUseWorldGeocoderToDetermineCountry() && this.helper.getWorldGeocoderFactory() != null) {
            IGeocoder worldGeocoder = this.getWorldGeocoder();
            GeocodeResult worldResult = this.geocodeWorldCentroids(constraints, type, worldGeocoder);
            if (worldResult == null || worldResult.getNumberCloseCandidates() == 0) {
                return null;
            }
            if (this.doesCandidateMatchedInputExactly(worldGeocoder.getIndexedCandidate(0, constraints))) {
                if (constraints.isFallbackToGeographic()) {
                    return this.replaceResults(worldGeocoder, worldResult, candidateCounts, constraints);
                }
                return null;
            }
            List<String> countries = this.suggestCountryGeocodersFromWorldResults(worldResult, constraints, worldGeocoder);
            if (countries.size() == 0) {
                if (constraints.isFallbackToGeographic()) {
                    return null;
                }
                return this.replaceResults(worldGeocoder, worldResult, candidateCounts, constraints);
            }
            countries.removeAll(attemptedCountries);
            if (!countries.isEmpty()) {
                List<String> attempted = this.geocodeAllCountriesInList(countries, type, constraints, candidateCounts);
                attemptedCountries.addAll(attempted);
            }
        }
        return null;
    }

    protected boolean doesCandidateMatchedInputExactly(CandidateAddress address) {
        String main = this.m_address.getMainAddress();
        return !StringUtilities.isEmpty(main) && (StringUtilities.equalStringsIgnoreCase(main, address.getAreaName3()) || StringUtilities.equalStringsIgnoreCase(main, address.getAreaName4()));
    }

    protected List<String> suggestCountryGeocodersFromWorldResults(GeocodeResult result, IConstraints constraints, IGeocoder worldGeocoder) throws MapMarkerInternalException, MMInternalFatalException {
        ArrayList<String> suggestedCountries = new ArrayList<String>();
        for (int i = 0; i < result.getNumberCandidates(); ++i) {
            CandidateAddress candidateAddress = worldGeocoder.getIndexedCandidate(i, constraints);
            String country = candidateAddress.getCountry();
            if ("USA".equals(country) || suggestedCountries.contains(country)) continue;
            suggestedCountries.add(country);
        }
        return suggestedCountries;
    }

    protected List<String> geocodeAllCountriesInList(List<String> countryList, int type, IConstraints constraints, CandidateCounts counts) {
        String value;
        ArrayList<String> attemptedCountries = new ArrayList<String>();
        String defaultCode = this.helper.getDefaultGeocoderCountryCode();
        if (this.helper.getAvailableCountries().isEmpty() && (value = constraints.getCustomString("GG_AVAILABLE_COUNTRIES")) != null) {
            StringTokenizer st = new StringTokenizer(value);
            while (st.hasMoreTokens()) {
                this.helper.getAvailableCountries().add(st.nextToken());
            }
        }
        for (String country : countryList) {
            boolean countryIsDefault;
            if (!this.helper.getAvailableCountries().contains(country) || this.helper.isSearchPreferredCountriesOnly() && !this.helper.getPreferredCountriesList().contains(country) || (countryIsDefault = StringUtilities.equalStringsIgnoreCase(defaultCode, country)) && this.defaultGeocoderTotalPossible >= 0) continue;
            boolean returnEarly = false;
            this.m_address.setCountry(country);
            attemptedCountries.add(country);
            try {
                GeocodeConstraints localCons = new GeocodeConstraints(constraints);
                constraints.setFallbackToPostal(false);
                ClientGeocodeResponse countryCGR = this.m_geocoder.geocode(type, this.m_address, (IGeocodeConstraints)localCons);
                if (countryCGR.candidateCount() != 0) {
                    counts.geocodersProvidingResults.add(country);
                }
                counts.possibleCandidates += countryCGR.totalPossibleCandidates();
                counts.possibleClose += countryCGR.totalPossibleCloseMatchCandidates();
                if (countryIsDefault) {
                    this.defaultGeocoderTotalPossible = countryCGR.totalPossibleCandidates();
                    this.defaultGeocoderTotalPossibleClose = countryCGR.totalPossibleCloseMatchCandidates();
                }
                this.comparator.getAvailableCountrySet().addAll(this.helper.getAvailableCountries());
                this.mergeNewCandidates(new CandidateIterator(countryCGR), this.comparator, constraints.getMaxCandidates());
                counts.actualCount = this.m_candidates.size();
                if (countryIsDefault || this.haveCloseStreetCandidate() && this.helper.isReturnOnFirstCloseStreetCandidates()) {
                    for (int i = 0; i < countryCGR.candidateCount(); ++i) {
                        String pc;
                        CandidateAddress cand = countryCGR.candidateAt(i);
                        if (countryIsDefault) {
                            this.defaultGeocoderCandidates.add(cand);
                        }
                        if (returnEarly || !this.helper.isReturnOnFirstCloseStreetCandidates() || !cand.isCloseMatch() || (pc = cand.getPrecisionCode()) == null || pc.charAt(0) != 'S') continue;
                        returnEarly = true;
                    }
                }
                if (!returnEarly) continue;
                break;
            }
            catch (Exception ex) {
                MMJLog.getLog().error("country " + country + " threw exception", (Throwable)ex);
                this.helper.getAvailableCountries().remove(country);
            }
        }
        this.m_address.setCountry(this.m_originalCountry);
        return attemptedCountries;
    }

    protected void mergeNewCandidates(CandidateIterator newSortedCandidates, Comparator<CandidateAddress> comparator, int totalSize) {
        if (newSortedCandidates.size() == 0) {
            return;
        }
        if (this.m_candidates.isEmpty()) {
            newSortedCandidates.addAllToList(this.m_candidates, totalSize);
            return;
        }
        int newIndex = 0;
        CandidateAddress primary = this.m_candidates.get(0);
        CandidateAddress secondary = newSortedCandidates.get(newIndex);
        int primaryIndex = 0;
        ArrayList<CandidateAddress> mergedList = new ArrayList<CandidateAddress>();
        while (newIndex < newSortedCandidates.size() && (totalSize < 0 || mergedList.size() < totalSize)) {
            if (comparator.compare(primary, secondary) == 1) {
                mergedList.add(secondary);
                if (++newIndex == newSortedCandidates.size()) break;
                secondary = newSortedCandidates.get(newIndex);
                continue;
            }
            mergedList.add(primary);
            if (++primaryIndex == this.m_candidates.size()) break;
            primary = this.m_candidates.get(primaryIndex);
        }
        while (primaryIndex < this.m_candidates.size() && (totalSize < 0 || mergedList.size() < totalSize)) {
            mergedList.add(this.m_candidates.get(primaryIndex));
            ++primaryIndex;
        }
        while (newIndex < newSortedCandidates.size() && (totalSize < 0 || mergedList.size() < totalSize)) {
            mergedList.add(newSortedCandidates.get(newIndex));
            ++newIndex;
        }
        this.m_candidates.clear();
        this.m_candidates.addAll(mergedList);
    }

    protected boolean haveCloseStreetCandidate() {
        return true;
    }

    protected class CandidateIterator {
        ClientGeocodeResponse response = null;
        List<CandidateAddress> list = null;

        public CandidateIterator(ClientGeocodeResponse newResponse) {
            this.response = newResponse;
        }

        public CandidateIterator(List<CandidateAddress> newList) {
            this.list = newList;
        }

        public int size() {
            if (this.list != null) {
                return this.list.size();
            }
            return this.response.candidateCount();
        }

        public CandidateAddress get(int idx) {
            if (this.list != null) {
                return this.list.get(idx);
            }
            return this.response.candidateAt(idx);
        }

        public void addAllToList(List<CandidateAddress> existingCandidates, int totalSize) {
            if (this.list != null) {
                existingCandidates.addAll(this.list);
            } else {
                for (int i = 0; i < this.response.candidateCount() && (totalSize < 0 || i < totalSize); ++i) {
                    MultiCountryGeocoder.this.m_candidates.add(this.response.candidateAt(i));
                }
            }
        }
    }

    class RankOnlyCandidateComparator
    implements Comparator<CandidateAddress> {
        RankOnlyCandidateComparator() {
        }

        @Override
        public int compare(CandidateAddress first, CandidateAddress second) {
            String str1 = first.getAdditionalFieldForKey("CITYRANK");
            String str2 = second.getAdditionalFieldForKey("CITYRANK");
            int rank1 = 11;
            int rank2 = 11;
            if (str1 != null) {
                rank1 = Integer.valueOf(str1);
            }
            if (str2 != null) {
                rank2 = Integer.valueOf(str2);
            }
            if (rank1 > rank2) {
                return 1;
            }
            if (rank2 > rank1) {
                return -1;
            }
            return 0;
        }
    }

    class ConstraintsBackupValues {
        int requestedMax;
        boolean requestedClose;
        boolean geoFallback;
        boolean postalFallback;
        String requestedMatchMode;

        ConstraintsBackupValues() {
        }
    }

    protected class CandidateCounts {
        int possibleCandidates;
        int possibleClose;
        int actualCount;
        Set<String> geocodersProvidingResults = new HashSet<String>();

        protected CandidateCounts() {
        }
    }
}

