/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.core.postal;

import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.InternalPostalCandidate;
import com.mapinfo.mapmarker.common.filters.ICloseMatchFilterRule;
import com.mapinfo.mapmarker.core.postal.ICorePostalCentroidFilter;
import com.mapinfo.mapmarker.core.postal.IPostalCentroidFilter;
import java.util.Collections;
import java.util.List;

public class CoreComprehensivePostalCentroidFilterer
implements IPostalCentroidFilter {
    @Override
    public List filterPostalCloseMatches(IHandler handler) {
        Address[] inputAddresses = handler.getParsedAddressArray();
        List postalCandidates = handler.getMatchResults();
        ICloseMatchFilterRule[] closeMatchRules = ((ICorePostalCentroidFilter)((Object)handler)).getPostalFilterRules();
        if (closeMatchRules == null) {
            return postalCandidates;
        }
        boolean bResort = false;
        for (InternalPostalCandidate best : postalCandidates) {
            if (!best.isCloseMatch()) continue;
            boolean bSkip = true;
            block1: for (InternalPostalCandidate other : postalCandidates) {
                if (bSkip && best != other) continue;
                if (best == other) {
                    bSkip = false;
                    continue;
                }
                for (ICloseMatchFilterRule rule : closeMatchRules) {
                    if (!rule.demoteOther(inputAddresses, best, other)) continue;
                    other.setCloseMatchOff();
                    bResort = true;
                    continue block1;
                }
            }
        }
        if (bResort) {
            Collections.reverse(postalCandidates);
            Collections.sort(postalCandidates);
            Collections.reverse(postalCandidates);
        }
        return postalCandidates;
    }
}

