/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.core.postal;

import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.InternalPostalCandidate;
import com.mapinfo.mapmarker.common.filters.ICloseMatchFilterRule;
import com.mapinfo.mapmarker.core.postal.ICorePostalCentroidFilter;
import com.mapinfo.mapmarker.core.postal.IPostalCentroidFilter;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class CorePostalCentroidFilter
implements IPostalCentroidFilter {
    @Override
    public List filterPostalCloseMatches(IHandler handler) {
        InternalPostalCandidate otherCandidate;
        Address[] inputAddresses = handler.getParsedAddressArray();
        List postalCandidates = handler.getMatchResults();
        ICloseMatchFilterRule[] closeMatchRules = ((ICorePostalCentroidFilter)((Object)handler)).getPostalFilterRules();
        if (closeMatchRules == null) {
            return postalCandidates;
        }
        boolean resort = false;
        Iterator candidateIterator = postalCandidates.iterator();
        InternalPostalCandidate bestCandidate = (InternalPostalCandidate)candidateIterator.next();
        block0: while (candidateIterator.hasNext() && (otherCandidate = (InternalPostalCandidate)candidateIterator.next()).isCloseMatch()) {
            for (int i = 0; i < closeMatchRules.length; ++i) {
                if (!closeMatchRules[i].demoteOther(inputAddresses, bestCandidate, otherCandidate)) continue;
                resort = true;
                otherCandidate.setCloseMatchOff();
                continue block0;
            }
        }
        if (resort) {
            Collections.reverse(postalCandidates);
            Collections.sort(postalCandidates);
            Collections.reverse(postalCandidates);
        }
        return postalCandidates;
    }
}

