/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.core.reverseGeocode;

import com.mapinfo.mapmarker.MMInternalFatalException;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.IReverseGeocodeCandidate;
import com.mapinfo.mapmarker.common.dp.IReverseGeocodeDataManager;
import com.mapinfo.mapmarker.core.IRetrievedCandidates;
import com.mapinfo.mapmarker.core.reverseGeocode.IReverseGeocodeInternalConstraints;
import com.mapinfo.mapmarker.core.reverseGeocode.IReverseGeocodeSubHandler;
import com.mapinfo.mapmarker.user.ReverseGeocodeCandidateAddress;
import com.mapinfo.mapmarker.user.ReverseGeocodeLocation;
import com.mapinfo.mapmarker.user.ReverseGeocodeResponse;
import com.mapinfo.midev.unit.LinearUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class CoreStandardReverseGeocodeSubHandler2
implements IReverseGeocodeSubHandler {
    private static Comparator<? super RGCandidateHolder> CAND_COMPARATOR = new RGCandComparator();
    private static Comparator<? super RGCandidateHolder> CAND_LOCALE_COMPARATOR = new RGCandLocaleComparator();

    @Override
    public ReverseGeocodeResponse reverseGeocode(ReverseGeocodeLocation location, IReverseGeocodeInternalConstraints constraints) throws MapMarkerInternalException, MMInternalFatalException {
        IReverseGeocodeDataManager data = constraints.getHandler().getDataManager();
        IRetrievedCandidates retrievedCands = data.retrieveReverseGeocodeCandidates(location, constraints.getHandler().getConstraints());
        if (retrievedCands.getCandidates().size() == 0 && !retrievedCands.getDataLicensed()) {
            ReverseGeocodeResponse response = new ReverseGeocodeResponse(null);
            response.setDataLicensed(false);
            return response;
        }
        List<RGCandidateHolder> returnCandidates = this.filterCandidates(location, constraints, retrievedCands.getCandidates());
        this.sortCandidates(returnCandidates, constraints.getSortCandidatesUsingLocale());
        return this.createResponse(returnCandidates);
    }

    @Deprecated
    protected void sortCandidates(List<RGCandidateHolder> candidatesToSort) {
        this.sortCandidates(candidatesToSort, false);
    }

    protected void sortCandidates(List<RGCandidateHolder> candidatesToSort, boolean bSortBasedOnLocale) {
        if (candidatesToSort != null) {
            if (bSortBasedOnLocale) {
                Collections.sort(candidatesToSort, CAND_LOCALE_COMPARATOR);
            } else {
                Collections.sort(candidatesToSort, CAND_COMPARATOR);
            }
        }
    }

    protected List<RGCandidateHolder> filterCandidates(ReverseGeocodeLocation originalLocation, IReverseGeocodeInternalConstraints constraints, List<IReverseGeocodeCandidate> allCandidates) throws MapMarkerInternalException {
        double maxDist = originalLocation.getDistanceAsLength().getValue(LinearUnit.METER);
        ArrayList<RGCandidateHolder> returnCandidates = new ArrayList<RGCandidateHolder>(1);
        List<IReverseGeocodeCandidate> filteredCandidates = new ArrayList<IReverseGeocodeCandidate>();
        IReverseGeocodeCandidate lastCandidate = null;
        for (IReverseGeocodeCandidate candidate : allCandidates) {
            if (candidate.getDistance() > maxDist) break;
            if (lastCandidate == null) {
                lastCandidate = candidate;
            } else if (candidate.getDistance() > lastCandidate.getDistance()) break;
            candidate.matchAddressNumber(originalLocation, constraints);
            filteredCandidates.add(candidate);
        }
        filteredCandidates = this.filterBasedOnStreetSide(filteredCandidates, originalLocation, constraints);
        for (IReverseGeocodeCandidate candidate : filteredCandidates) {
            returnCandidates.add(new RGCandidateHolder(candidate.toCandidateAddress(originalLocation, constraints), candidate.getUserDictionaryPriority(), candidate.matchesLocale(constraints.getClientLocale()), candidate.isDefaultLocale()));
        }
        return returnCandidates;
    }

    protected List<IReverseGeocodeCandidate> filterBasedOnStreetSide(List<IReverseGeocodeCandidate> candidates, ReverseGeocodeLocation originalLocation, IReverseGeocodeInternalConstraints constraints) {
        if (candidates.size() <= 1) {
            return candidates;
        }
        ArrayList<IReverseGeocodeCandidate> filteredCandidates = new ArrayList<IReverseGeocodeCandidate>(candidates.size());
        for (IReverseGeocodeCandidate candidate : candidates) {
            if (!candidate.isFromCorrectStreetSide(originalLocation, constraints)) continue;
            filteredCandidates.add(candidate);
        }
        if (filteredCandidates.isEmpty()) {
            return candidates;
        }
        return filteredCandidates;
    }

    protected ReverseGeocodeResponse createResponse(List<RGCandidateHolder> sortedCandidates) {
        ArrayList<ReverseGeocodeCandidateAddress> candidates = new ArrayList<ReverseGeocodeCandidateAddress>(sortedCandidates.size());
        for (RGCandidateHolder holder : sortedCandidates) {
            candidates.add(holder.getCandidate());
        }
        return new ReverseGeocodeResponse(candidates);
    }

    protected static class RGCandidateHolder {
        private final ReverseGeocodeCandidateAddress m_candidate;
        private final int m_userPriority;
        private final boolean m_bLocaleMatches;
        private final boolean m_bIsDefaultLocale;

        public RGCandidateHolder(ReverseGeocodeCandidateAddress candidate, int userPriority, boolean bMatchesLocale, boolean bIsDefaultLocale) {
            this.m_candidate = candidate;
            this.m_userPriority = userPriority;
            this.m_bLocaleMatches = bMatchesLocale;
            this.m_bIsDefaultLocale = bIsDefaultLocale;
        }

        @Deprecated
        public RGCandidateHolder(ReverseGeocodeCandidateAddress candidate, int userPriority) {
            this(candidate, userPriority, false, false);
        }

        public int getUserPriority() {
            return this.m_userPriority;
        }

        public boolean getMatchesLocale() {
            return this.m_bLocaleMatches;
        }

        public boolean getIsDefaultLocale() {
            return this.m_bIsDefaultLocale;
        }

        public ReverseGeocodeCandidateAddress getCandidate() {
            return this.m_candidate;
        }
    }

    private static class RGCandComparator
    implements Comparator<RGCandidateHolder> {
        private RGCandComparator() {
        }

        @Override
        public int compare(RGCandidateHolder o1, RGCandidateHolder o2) {
            int compare = o1.getUserPriority() - o2.getUserPriority();
            if (compare != 0) {
                return compare;
            }
            ReverseGeocodeCandidateAddress candidate1 = o1.getCandidate();
            ReverseGeocodeCandidateAddress candidate2 = o2.getCandidate();
            compare = this.compareWithNullHandling((Comparable)((Object)candidate1.getMainAddress()), (Object)candidate2.getMainAddress());
            if (compare != 0) {
                return compare;
            }
            compare = this.compareWithReverseNullHandling(candidate1.getParsedAddressNumber(), candidate2.getParsedAddressNumber());
            if (compare != 0) {
                return compare;
            }
            compare = this.compareWithNullHandling((Comparable)((Object)candidate1.getUnitType()), (Object)candidate2.getUnitType());
            if (compare != 0) {
                return compare;
            }
            compare = this.compareWithNullHandling((Comparable)((Object)candidate1.getUnitValue()), (Object)candidate2.getUnitValue());
            if (compare != 0) {
                return compare;
            }
            return 0;
        }

        private <T> int compareWithNullHandling(Comparable<T> s1, T s2) {
            if (s1 == null && s2 == null) {
                return 0;
            }
            if (s1 == null) {
                return -1;
            }
            if (s2 == null) {
                return 1;
            }
            return s1.compareTo(s2);
        }

        private <T> int compareWithReverseNullHandling(Comparable<T> s1, T s2) {
            if (s1 == null && s2 == null) {
                return 0;
            }
            if (s1 == null) {
                return 1;
            }
            if (s2 == null) {
                return -1;
            }
            return s1.compareTo(s2);
        }
    }

    private static class RGCandLocaleComparator
    extends RGCandComparator {
        private RGCandLocaleComparator() {
        }

        @Override
        public int compare(RGCandidateHolder o1, RGCandidateHolder o2) {
            if (o1.getMatchesLocale() != o2.getMatchesLocale()) {
                if (o1.getMatchesLocale()) {
                    return -1;
                }
                return 1;
            }
            if (o1.getIsDefaultLocale() != o2.getIsDefaultLocale()) {
                if (o1.getIsDefaultLocale()) {
                    return -1;
                }
                return 1;
            }
            return super.compare(o1, o2);
        }
    }
}

