/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.core.reverseGeocode;

import com.mapinfo.midev.coordsys.CoordSysConstants;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.Envelope;
import com.mapinfo.midev.geometry.IDirectPositionList;
import com.mapinfo.midev.geometry.IGeometry;
import com.mapinfo.midev.geometry.SpatialInfo;
import com.mapinfo.midev.geometry.impl.GeometryFactory;
import com.mapinfo.midev.geometry.impl.LineString;
import com.mapinfo.midev.geometry.impl.Rectangle;
import com.mapinfo.midev.geometry.impl.XYDirectPositionArray;
import com.mapinfo.midev.geometry.operations.GeometryOperations;
import com.mapinfo.midev.unit.ComputationType;
import com.mapinfo.midev.unit.Length;
import com.mapinfo.midev.unit.LinearUnit;
import com.mapinfo.util.DoublePoint;
import java.util.ArrayList;
import java.util.List;

public class ReverseGeocodeUtils {
    private static final SpatialInfo SI = new SpatialInfo(CoordSysConstants.longLatWGS84);
    private static final LinearUnit UNIT_ROUNDING = LinearUnit.MILLIMETER;

    public static double getDistance(DoublePoint position, DoublePoint point) {
        return ReverseGeocodeUtils.getDistance(new DirectPosition(position.x, position.y), new DirectPosition(point.x, point.y));
    }

    public static double getDistance(DirectPosition position, DirectPosition point) {
        GeometryFactory factory = new GeometryFactory(SI);
        Length length = GeometryOperations.distance((IGeometry)factory.newPoint(position), (IGeometry)factory.newPoint(point), (ComputationType)ComputationType.SPHERICAL);
        return ReverseGeocodeUtils.roundedDistance(length);
    }

    public static double getDistance(DirectPosition position, List<DirectPosition> points) {
        GeometryFactory factory = new GeometryFactory(SI);
        LineString segmentGeometry = factory.newLineString(ReverseGeocodeUtils.makePositionList_new(points));
        Length length = GeometryOperations.distance((IGeometry)factory.newPoint(position), (IGeometry)segmentGeometry, (ComputationType)ComputationType.SPHERICAL);
        return ReverseGeocodeUtils.roundedDistance(length);
    }

    public static double getDistance(DirectPosition position, Envelope e) {
        GeometryFactory factory = new GeometryFactory(SI);
        Rectangle envelopeGeometry = factory.newRectangle(e.getLowerLeft(), e.getUpperRight());
        return ReverseGeocodeUtils.roundedDistance(GeometryOperations.distance((IGeometry)factory.newPoint(position), (IGeometry)envelopeGeometry, (ComputationType)ComputationType.SPHERICAL));
    }

    private static double roundedDistance(Length length) {
        return (double)Math.round(length.getValue(UNIT_ROUNDING)) * UNIT_ROUNDING.getMetersPerUnit();
    }

    private static IDirectPositionList makePositionList_new(List<DirectPosition> points) {
        XYDirectPositionArray list = new XYDirectPositionArray(points.size());
        for (DirectPosition point : points) {
            list.add(new DirectPosition(point));
        }
        return list;
    }

    public static boolean pointsOnSameSideOfSegment(DirectPosition p1, DirectPosition p2, List<DirectPosition> segment) {
        return (1 & ReverseGeocodeUtils.countIntersections(p1, p2, segment)) == 0;
    }

    private static int countIntersections(DirectPosition p1, DirectPosition p2, List<DirectPosition> segment) {
        GeometryFactory factory = new GeometryFactory(SI);
        XYDirectPositionArray list = new XYDirectPositionArray(2);
        list.add(new DirectPosition(p1));
        list.add(new DirectPosition(p2));
        LineString testGeometry = factory.newLineString((IDirectPositionList)list);
        ArrayList<IDirectPositionList> positionsListList = new ArrayList<IDirectPositionList>();
        for (int i = 1; i < segment.size(); ++i) {
            positionsListList.add(ReverseGeocodeUtils.makePositionList_new(segment.subList(i - 1, i + 1)));
        }
        ArrayList<LineString> segmentGeometries = new ArrayList<LineString>();
        for (IDirectPositionList subList : positionsListList) {
            segmentGeometries.add(factory.newLineString(subList));
        }
        int count = 0;
        for (IGeometry iGeometry : segmentGeometries) {
            if (!GeometryOperations.intersects((IGeometry)testGeometry, (IGeometry)iGeometry)) continue;
            ++count;
        }
        return count;
    }
}

