/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.core.singleline;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.CandidateRange;
import com.mapinfo.mapmarker.Constraints;
import com.mapinfo.mapmarker.GeocodableAddressCreationException;
import com.mapinfo.mapmarker.GeocodeResult;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.IGeocodeConstraints;
import com.mapinfo.mapmarker.MMGeneralGeocoderException;
import com.mapinfo.mapmarker.MMInternalFatalException;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.common.ICountryGeographyInfo;
import com.mapinfo.mapmarker.common.dp.DataAccessException;
import com.mapinfo.mapmarker.common.dp.DataAccessRuntimeException;
import com.mapinfo.mapmarker.core.IGeocoder;
import com.mapinfo.mapmarker.core.parser.ParserException;
import com.mapinfo.mapmarker.core.singleline.IAddressParsing;
import com.mapinfo.mapmarker.core.singleline.IGeocoderFactory;
import com.mapinfo.mapmarker.core.singleline.ISingleLineParser;
import com.mapinfo.mapmarker.core.singleline.ISingleLineResultEval;
import com.mapinfo.mapmarker.core.singleline.SingleLineResult;
import com.mapinfo.mapmarker.core.singleline.eval.CoreSingleLineEval;
import com.mapinfo.mapmarker.utils.DebugLevel;
import com.mapinfo.mapmarker.utils.MMJLog;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;

public final class SingleLineGeocoder
implements IGeocoder {
    public static final String ORIGINAL_SINGLE_LINE = "ORIGINAL_SINGLE_LINE";
    private final IGeocoderFactory m_geocoderFactory;
    private final IGeocodeConstraints m_originalConstraints;
    private final ISingleLineResultEval m_singleLineEvaluator;
    private final Address m_originalAddress;
    private final ISingleLineParser m_parser;
    private List<IAddressParsing> m_parsedAddresses;
    private ResourceBundle m_bundle;
    private IGeocoder m_currentGeocoder;
    private IConstraints m_currentConstraints;
    private boolean m_debug;

    public SingleLineGeocoder(IGeocoderFactory geocoderFactory, ISingleLineParser parser, Address address, IGeocodeConstraints constraints, ISingleLineResultEval eval) throws GeocodableAddressCreationException {
        this.m_geocoderFactory = geocoderFactory;
        this.m_originalConstraints = constraints;
        this.m_singleLineEvaluator = eval;
        this.m_originalAddress = address;
        this.m_parser = parser;
        this.m_originalConstraints.setCustomString(ORIGINAL_SINGLE_LINE, this.m_originalAddress.getMainAddress());
        this.m_currentGeocoder = this.m_geocoderFactory.createGeocoder(new AddressImpl(), constraints);
        this.m_debug = DebugLevel.getDebugLevel(6) == 3;
    }

    public static IGeocoder getGeocoder(IGeocoderFactory geocoderFactory, ISingleLineParser parser, Address address, IGeocodeConstraints constraints) throws GeocodableAddressCreationException {
        return SingleLineGeocoder.getGeocoder(geocoderFactory, parser, address, constraints, new CoreSingleLineEval());
    }

    public static IGeocoder getGeocoder(IGeocoderFactory geocoderFactory, ISingleLineParser parser, Address address, IGeocodeConstraints constraints, ISingleLineResultEval eval) throws GeocodableAddressCreationException {
        if (!SingleLineGeocoder.isSingleLine(address)) {
            return geocoderFactory.createGeocoder(address, constraints);
        }
        return new SingleLineGeocoder(geocoderFactory, parser, address, constraints, eval);
    }

    @Override
    public void setErrorBundle(ResourceBundle bundle) {
        this.m_bundle = bundle;
    }

    @Override
    public IConstraints convertConstraints(IConstraints constraints) {
        return constraints;
    }

    @Override
    public void prepareAndParse(int geocodeType, IConstraints constraints) throws ParserException, MapMarkerInternalException {
        IConstraints convConstraints = this.m_currentGeocoder.convertConstraints(new Constraints(constraints));
        this.m_currentGeocoder.prepareAndParse(geocodeType, convConstraints);
        this.m_parsedAddresses = Collections.unmodifiableList(this.m_parser.parse(this.m_originalAddress, convConstraints));
        if (this.m_debug) {
            for (IAddressParsing parsing : this.m_parsedAddresses) {
                String reverseTag = parsing.getSplit().isFromReverseSplit() ? "Reverse " : "";
                String delimitedTag = parsing.getSplit().isFromDelimited() ? "Delimited " : "";
                MMJLog.getLog().debug("Possible split: {" + parsing.getSplit().getAddress().getMainAddress() + "}{" + parsing.getSplit().getAddress().getPostAddress() + "}" + reverseTag + delimitedTag);
            }
        }
    }

    private GeocodeResult multiParseGeocode(int geocodeType, IConstraints constraints) throws MMInternalFatalException, MapMarkerInternalException {
        for (int i = 0; i < this.m_parsedAddresses.size(); ++i) {
            GeocodeResult result;
            this.setCurrentVariation(i, geocodeType);
            switch (geocodeType) {
                case 0: {
                    result = this.m_currentGeocoder.geocode(this.m_currentConstraints);
                    break;
                }
                case 1: {
                    result = this.m_currentGeocoder.geocodePostal(this.m_currentConstraints);
                    break;
                }
                case 4: {
                    result = this.m_currentGeocoder.geocodeGeographic(this.m_currentConstraints);
                    break;
                }
                default: {
                    throw new MMGeneralGeocoderException(2303, new String[]{String.valueOf(geocodeType)});
                }
            }
            SingleLineResult currentResult = new SingleLineResult(this.m_currentGeocoder, this.m_currentConstraints, result, geocodeType);
            this.m_singleLineEvaluator.evaluate(currentResult);
            if (this.m_singleLineEvaluator.shouldStop()) break;
        }
        this.setResult(this.m_singleLineEvaluator.getBest());
        return this.m_singleLineEvaluator.getBest().getGeoResult();
    }

    @Override
    public GeocodeResult geocode(IConstraints preferences) throws MMInternalFatalException, MapMarkerInternalException {
        return this.multiParseGeocode(0, preferences);
    }

    @Override
    public GeocodeResult geocodePostal(IConstraints constraints) throws MapMarkerInternalException, MMInternalFatalException {
        return this.multiParseGeocode(1, constraints);
    }

    @Override
    public GeocodeResult geocodeGeographic(IConstraints constraints) throws MapMarkerInternalException, MMInternalFatalException {
        return this.multiParseGeocode(4, constraints);
    }

    @Override
    public GeocodeResult geocodeCustom(int geocodeType, IConstraints constraints) throws MapMarkerInternalException {
        this.setCurrentVariation(0, geocodeType);
        return this.m_currentGeocoder.geocodeCustom(geocodeType, this.m_currentConstraints);
    }

    @Override
    public GeocodeResult standardize(IConstraints preferences) throws MapMarkerInternalException {
        this.setCurrentVariation(0, 5);
        return this.m_currentGeocoder.standardize(this.m_currentConstraints);
    }

    @Override
    public GeocodeResult browse(IConstraints constraints) throws MapMarkerInternalException, MMInternalFatalException {
        this.setCurrentVariation(0, 6);
        return this.m_currentGeocoder.browse(this.m_currentConstraints);
    }

    @Override
    public CandidateAddress getIndexedCandidate(int i, IConstraints preferences) throws MapMarkerInternalException {
        return this.m_currentGeocoder.getIndexedCandidate(i, this.m_currentConstraints);
    }

    @Override
    public CandidateAddress getIndexedCoords(int candIndex, CandidateRange range, IConstraints preferences) throws MapMarkerInternalException {
        return this.m_currentGeocoder.getIndexedCoords(candIndex, range, this.m_currentConstraints);
    }

    @Override
    public ICountryGeographyInfo getCountryGeographyInfo() {
        return this.m_currentGeocoder.getCountryGeographyInfo();
    }

    private static boolean isSingleLine(Address inputAddress) {
        return !StringUtilities.isEmpty(inputAddress.getMainAddress()) && StringUtilities.isEmpty(inputAddress.getAreaName1()) && StringUtilities.isEmpty(inputAddress.getAreaName2()) && StringUtilities.isEmpty(inputAddress.getAreaName3()) && StringUtilities.isEmpty(inputAddress.getAreaName4()) && StringUtilities.isEmpty(inputAddress.getPostCode1()) && StringUtilities.isEmpty(inputAddress.getPostCode2()) && StringUtilities.isEmpty(inputAddress.getPlaceName()) && StringUtilities.isEmpty(inputAddress.getPostAddress());
    }

    private void setResult(SingleLineResult result) {
        this.m_currentGeocoder = result.getGeocoder();
        this.m_currentConstraints = result.getConstraints();
    }

    private void setCurrentVariation(int idx, int geocodeType) throws MapMarkerInternalException {
        try {
            Address usedAddress = this.m_parsedAddresses.get(idx).getSplit().getAddress();
            this.m_currentConstraints = new Constraints(this.m_originalConstraints);
            this.m_currentGeocoder = this.m_geocoderFactory.createGeocoder(usedAddress, this.m_currentConstraints);
            this.m_currentConstraints = this.m_currentGeocoder.convertConstraints(this.m_currentConstraints);
            this.m_currentGeocoder.prepareAndParse(geocodeType, this.m_currentConstraints);
            if (this.m_bundle != null) {
                this.m_currentGeocoder.setErrorBundle(this.m_bundle);
            }
        }
        catch (GeocodableAddressCreationException e) {
            throw new DataAccessRuntimeException(new DataAccessException(2306));
        }
    }
}

