/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.core.singleline.eval;

import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.core.singleline.ISingleLineResultEval;
import com.mapinfo.mapmarker.core.singleline.SingleLineResult;
import com.mapinfo.mapmarker.core.singleline.eval.GeographicPreferenceRule;
import com.mapinfo.mapmarker.core.singleline.eval.MixedPostalGeographicRule;
import com.mapinfo.mapmarker.core.singleline.eval.PreferCandidatesRule;
import com.mapinfo.mapmarker.core.singleline.eval.PreferCloseRule;
import com.mapinfo.mapmarker.core.singleline.eval.StreetOverOtherPreferenceRule;
import com.mapinfo.mapmarker.core.singleline.eval.StreetPreferenceRule;
import com.mapinfo.mapmarker.utils.AggregateComparator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class CoreSingleLineEval
implements ISingleLineResultEval {
    private final AggregateComparator<SingleLineResult> m_aggregateComparator;
    private SingleLineResult m_best;

    public CoreSingleLineEval() {
        this(CoreSingleLineEval.buildCompareRules());
    }

    public CoreSingleLineEval(List<Comparator<SingleLineResult>> compareRules) {
        this.m_aggregateComparator = new AggregateComparator(compareRules);
    }

    @Override
    public void evaluate(SingleLineResult current) {
        if (this.m_best == null || this.m_aggregateComparator.compare(this.m_best, current) > 0) {
            this.m_best = current;
        }
    }

    @Override
    public boolean shouldStop() {
        switch (this.m_best.getGeocodeType()) {
            case 0: {
                return this.shouldStopGeocode();
            }
            case 4: {
                return this.shouldStopGeocodeGeographic();
            }
            case 1: {
                return this.shouldStopGeocodePostal();
            }
        }
        throw new IllegalStateException("Geocode type not handled in evaluator: " + this.m_best.getGeocodeType());
    }

    @Override
    public SingleLineResult getBest() {
        return this.m_best;
    }

    private boolean shouldStopGeocodePostal() {
        return this.m_best.getGeoResult().getNumberCloseCandidates() > 0;
    }

    private boolean shouldStopGeocodeGeographic() {
        try {
            if (this.m_best.getGeoResult().getNumberCloseCandidates() == 0) {
                return false;
            }
            int prec = this.m_best.getGeocoder().getIndexedCandidate(0, this.m_best.getConstraints()).getLocationPrecision();
            return prec == 10 || prec == 11;
        }
        catch (MapMarkerInternalException e) {
            return false;
        }
    }

    private boolean shouldStopGeocode() {
        try {
            if (this.m_best.getGeoResult().getNumberCloseCandidates() == 0) {
                return false;
            }
            if (this.m_best.getGeoResult().getNumberCandidates() == 0) {
                return true;
            }
            int precision = this.m_best.getGeocoder().getIndexedCandidate(0, this.m_best.getConstraints()).getLocationPrecision();
            switch (precision) {
                case 1: 
                case 2: 
                case 6: 
                case 16: 
                case 17: {
                    return true;
                }
            }
            return false;
        }
        catch (MapMarkerInternalException e) {
            return false;
        }
    }

    private static List<Comparator<SingleLineResult>> buildCompareRules() {
        ArrayList<Comparator<SingleLineResult>> compareRules = new ArrayList<Comparator<SingleLineResult>>();
        compareRules.add(new PreferCloseRule());
        compareRules.add(new PreferCandidatesRule());
        compareRules.add(new StreetPreferenceRule());
        compareRules.add(new GeographicPreferenceRule());
        compareRules.add(new MixedPostalGeographicRule());
        compareRules.add(new StreetOverOtherPreferenceRule());
        return compareRules;
    }
}

