/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.core.singleline.eval;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.core.singleline.SingleLineResult;
import com.mapinfo.mapmarker.core.singleline.eval.SingleLineEvalUtils;
import java.util.Comparator;

public class StreetOverOtherPreferenceRule
implements Comparator<SingleLineResult> {
    @Override
    public int compare(SingleLineResult o1, SingleLineResult o2) {
        try {
            CandidateAddress cand1 = SingleLineEvalUtils.getTopCandOrNull(o1);
            CandidateAddress cand2 = SingleLineEvalUtils.getTopCandOrNull(o2);
            if (cand1 == null || cand2 == null) {
                return 0;
            }
            int prec1 = cand1.getLocationPrecision();
            int prec2 = cand2.getLocationPrecision();
            if (this.isStreet(prec1) && !this.isStreet(prec2)) {
                return -1;
            }
            if (!this.isStreet(prec1) && this.isStreet(prec2)) {
                return 1;
            }
            return 0;
        }
        catch (MapMarkerInternalException MMIEx) {
            return 0;
        }
    }

    private boolean isStreet(int precision) {
        switch (precision) {
            case 1: 
            case 2: 
            case 6: 
            case 16: 
            case 17: {
                return true;
            }
        }
        return false;
    }
}

