/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.core.singleline.parser;

import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.core.ICoreParseHandler;
import com.mapinfo.mapmarker.core.parser.ParserException;
import com.mapinfo.mapmarker.core.singleline.AddressParsing;
import com.mapinfo.mapmarker.core.singleline.AddressSplit;
import com.mapinfo.mapmarker.core.singleline.IAddressParsing;
import com.mapinfo.mapmarker.core.singleline.IAddressSplit;
import com.mapinfo.mapmarker.core.singleline.ISingleLineParser;
import com.mapinfo.mapmarker.core.singleline.parser.IAddressSplitFilter;
import com.mapinfo.mapmarker.utils.AggregateComparator;
import com.mapinfo.mapmarker.utils.DebugLevel;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CoreSingleLineParser
implements ISingleLineParser {
    public static final int DEFAULT_MAX_PARSINGS_RETURNED = 3;
    private static final String DELIMITER_REGEX = "[,;:]";
    private static final Pattern DELIMITER_PATTERN = Pattern.compile("[,;:]");
    private final int m_maxParsingsReturned;
    private final AggregateComparator<IAddressParsing> m_sortComparator;
    private final List<IAddressSplitFilter> m_splitFilterRules;

    public CoreSingleLineParser(List<Comparator<IAddressParsing>> sortingRules) {
        this(sortingRules, 3);
    }

    public CoreSingleLineParser(List<Comparator<IAddressParsing>> sortingRules, int maxParsingsReturned) {
        this(sortingRules, null, maxParsingsReturned);
    }

    public CoreSingleLineParser(List<Comparator<IAddressParsing>> sortingRules, List<IAddressSplitFilter> filterRules, int maxParsingsReturned) {
        this.m_maxParsingsReturned = maxParsingsReturned;
        int debugLevel = DebugLevel.getDebugLevel(6);
        this.m_sortComparator = new AggregateComparator(sortingRules, debugLevel == 3);
        this.m_splitFilterRules = filterRules;
    }

    protected IAddressParsing makeAddressParsing(IAddressSplit split, Address[] parse) {
        return new AddressParsing(split, parse);
    }

    protected IAddressSplit makeAddressSplit(Address split, boolean fromDelimited, boolean fromReverseSplit) {
        return new AddressSplit(split, fromDelimited, fromReverseSplit);
    }

    @Override
    public List<IAddressParsing> parse(Address input, IConstraints constraints) throws ParserException {
        List<IAddressSplit> splits = this.createSplits(input, constraints);
        List<IAddressSplit> filteredSplits = this.filterSplits(splits, constraints);
        List<IAddressParsing> parsings = this.parseSplits(filteredSplits, constraints);
        List<IAddressParsing> result = this.createFinalList(parsings);
        return result;
    }

    protected List<IAddressSplit> createSplits(Address input, IConstraints constraints) {
        ArrayList<IAddressSplit> allSplits = new ArrayList<IAddressSplit>();
        List<IAddressSplit> delimitedSplits = this.createDelimitedSplits(input);
        this.addNonDuplicateSplits(allSplits, delimitedSplits);
        List<IAddressSplit> nonDelimitedSplits = this.createNonDelimitedSplits(input);
        this.addNonDuplicateSplits(allSplits, nonDelimitedSplits);
        return allSplits;
    }

    protected List<IAddressSplit> filterSplits(List<IAddressSplit> allSplits, IConstraints constraints) {
        if (this.m_splitFilterRules != null && this.m_splitFilterRules.size() > 0) {
            ArrayList<IAddressSplit> filteredSplits = new ArrayList<IAddressSplit>();
            for (IAddressSplit split : allSplits) {
                boolean passes = true;
                for (IAddressSplitFilter filter : this.m_splitFilterRules) {
                    if (filter.accept(split, constraints)) continue;
                    passes = false;
                    break;
                }
                if (!passes) continue;
                filteredSplits.add(split);
            }
            if (filteredSplits.size() > 0) {
                return filteredSplits;
            }
        }
        return allSplits;
    }

    protected List<IAddressParsing> createFinalList(List<IAddressParsing> parsings) {
        ArrayList<IAddressParsing> result = new ArrayList<IAddressParsing>(this.m_maxParsingsReturned);
        Collections.sort(parsings, this.m_sortComparator);
        for (int i = 0; i < this.m_maxParsingsReturned && i < parsings.size(); ++i) {
            result.add(parsings.get(i));
        }
        return result;
    }

    protected Comparator<IAddressParsing> getSortComparator() {
        return this.m_sortComparator;
    }

    private List<IAddressParsing> parseSplits(List<IAddressSplit> splits, IConstraints constraints) throws ParserException {
        ArrayList<IAddressParsing> parsings = new ArrayList<IAddressParsing>(splits.size());
        for (IAddressSplit split : splits) {
            Address[] parsed = ((ICoreParseHandler)((Object)constraints.getHandler())).getParser().parse(split.getAddress(), constraints);
            parsings.add(this.makeAddressParsing(split, parsed));
        }
        return parsings;
    }

    private List<IAddressSplit> createDelimitedSplits(Address input) {
        ArrayList<IAddressSplit> result = new ArrayList<IAddressSplit>();
        Matcher matcher = DELIMITER_PATTERN.matcher(input.getMainAddress());
        for (int i = 0; i < 3; ++i) {
            if (!matcher.find()) continue;
            int end = matcher.end();
            AddressImpl addr = new AddressImpl();
            addr.setMainAddress(input.getMainAddress().substring(0, end - 1).trim().replaceAll(DELIMITER_REGEX, " "));
            addr.setPostAddress(input.getMainAddress().substring(end).trim().replaceAll(DELIMITER_REGEX, " "));
            addr.setCountry(input.getCountry());
            if (input.getAdditionalFields() != null && input.getAdditionalFields().get(AddressImpl.KEY_POBOX) != null) {
                addr.getAdditionalFields().put(AddressImpl.KEY_POBOX, input.getAdditionalFields().get(AddressImpl.KEY_POBOX));
            }
            result.add(this.makeAddressSplit(addr, true, false));
            addr = new AddressImpl();
            addr.setPostAddress(input.getMainAddress().substring(0, end - 1).trim().replaceAll(DELIMITER_REGEX, " "));
            addr.setMainAddress(input.getMainAddress().substring(end).trim().replaceAll(DELIMITER_REGEX, " "));
            addr.setCountry(input.getCountry());
            if (input.getAdditionalFields() != null && input.getAdditionalFields().get(AddressImpl.KEY_POBOX) != null) {
                addr.getAdditionalFields().put(AddressImpl.KEY_POBOX, input.getAdditionalFields().get(AddressImpl.KEY_POBOX));
            }
            result.add(this.makeAddressSplit(addr, true, true));
        }
        return result;
    }

    private List<IAddressSplit> createNonDelimitedSplits(Address input) {
        String main = input.getMainAddress().replaceAll(DELIMITER_REGEX, " ").replaceAll("  ", " ");
        String country = input.getCountry();
        List<Address> splits = this.split(main, country);
        ArrayList<IAddressSplit> result = new ArrayList<IAddressSplit>();
        for (Address split : splits) {
            if (input.getAdditionalFields() != null && input.getAdditionalFields().get(AddressImpl.KEY_POBOX) != null) {
                split.getAdditionalFields().put(AddressImpl.KEY_POBOX, input.getAdditionalFields().get(AddressImpl.KEY_POBOX));
            }
            result.add(this.makeAddressSplit(split, false, false));
            AddressImpl revSplit = new AddressImpl(split);
            revSplit.setMainAddress(split.getPostAddress());
            revSplit.setPostAddress(split.getMainAddress());
            if (input.getAdditionalFields() != null && input.getAdditionalFields().get(AddressImpl.KEY_POBOX) != null) {
                revSplit.getAdditionalFields().put(AddressImpl.KEY_POBOX, input.getAdditionalFields().get(AddressImpl.KEY_POBOX));
            }
            result.add(this.makeAddressSplit(revSplit, false, true));
        }
        return result;
    }

    private void addNonDuplicateSplits(List<IAddressSplit> addTo, List<IAddressSplit> addFrom) {
        for (IAddressSplit fromSplit : addFrom) {
            boolean duplicate = false;
            IAddressSplit dupSplit = null;
            for (IAddressSplit toSplit : addTo) {
                if (!StringUtilities.equalStrings(fromSplit.getAddress().getPostAddress(), toSplit.getAddress().getPostAddress()) || !StringUtilities.equalStrings(fromSplit.getAddress().getMainAddress(), toSplit.getAddress().getMainAddress())) continue;
                duplicate = true;
                dupSplit = toSplit;
                break;
            }
            if (!duplicate) {
                addTo.add(fromSplit);
                continue;
            }
            if (!dupSplit.isFromReverseSplit() || fromSplit.isFromReverseSplit()) continue;
            addTo.remove(dupSplit);
            addTo.add(fromSplit);
        }
    }

    private List<Address> split(String singleLineMain, String country) {
        ArrayList<Address> result = new ArrayList<Address>();
        String[] splits = singleLineMain.split(" ");
        for (int i = 0; i < splits.length + 1; ++i) {
            StringBuilder main = new StringBuilder();
            StringBuilder post = new StringBuilder();
            for (int j = 0; j < splits.length; ++j) {
                if (j < i) {
                    main.append(splits[j]);
                    main.append(' ');
                    continue;
                }
                post.append(splits[j]);
                post.append(' ');
            }
            AddressImpl splitAddr = new AddressImpl();
            splitAddr.setMainAddress(main.toString().trim());
            splitAddr.setPostAddress(post.toString().trim());
            splitAddr.setCountry(country);
            result.add(splitAddr);
        }
        return result;
    }
}

