/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.generic.soundex;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ExtendedCharacters {
    private Map m_ExtendedCharsMap = new HashMap();

    public ExtendedCharacters(String propertyFile) {
        this.loadExtendedChars(propertyFile);
    }

    private void fillExtendedCharsMap(String normalCharacter, String value) {
        String[] extendedCharactersArray = value.split(",");
        for (int i = 0; i < extendedCharactersArray.length; ++i) {
            this.m_ExtendedCharsMap.put(extendedCharactersArray[i], normalCharacter);
        }
    }

    private void loadExtendedChars(String propertyFile) {
        try {
            Properties propertiesFile = new Properties();
            ClassLoader loader = this.getClass().getClassLoader();
            propertiesFile.load(loader.getResourceAsStream(propertyFile));
            if (propertiesFile != null) {
                for (String string : propertiesFile.keySet()) {
                    String extendedCharacters = propertiesFile.getProperty(string);
                    this.fillExtendedCharsMap(string, extendedCharacters);
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to load the property file " + propertyFile);
        }
    }

    public String getNormalReplacementCharacter(char c) {
        String normChar = (String)this.m_ExtendedCharsMap.get(String.valueOf(c));
        if (normChar == null) {
            return String.valueOf(c);
        }
        return normChar;
    }

    public String cleanExtendedCharsInString(String str) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        StringBuffer cleanedStr = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            String normChar = (String)this.m_ExtendedCharsMap.get(String.valueOf(c));
            if (normChar == null) {
                cleanedStr.append(c);
                continue;
            }
            cleanedStr.append(normChar);
        }
        return cleanedStr.toString();
    }
}

