/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.generic.soundex;

import com.mapinfo.mapmarker.common.ISoundexKey;
import com.mapinfo.mapmarker.common.MiSoundexKey;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.generic.soundex.ExtendedCharacters;
import com.mapinfo.mapmarker.generic.soundex.SoundexHelper;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GenericSoundex
extends Soundex {
    private final String DIGITS = "0123456789";
    private SoundexHelper m_SoundexHelper = new SoundexHelper();
    private String m_PropertyFileName;
    private final String DEFAULT_PROPERTY_FILE = "com/mapinfo/mapmarker/generic/soundex/GenericSoundex.properties";

    public GenericSoundex(String propertyFileName) {
        this.m_PropertyFileName = propertyFileName;
        if (this.m_SoundexHelper.getSoundexProperties() == null) {
            if (propertyFileName == null || !propertyFileName.endsWith(".properties")) {
                propertyFileName = "com/mapinfo/mapmarker/generic/soundex/GenericSoundex.properties";
            }
            this.m_SoundexHelper.loadPropertyFile(propertyFileName);
            this.m_SoundexHelper.loadSoundsMap();
        }
    }

    public GenericSoundex(String propertyFileName, ExtendedCharacters extendedChars) {
        this(propertyFileName);
        this.m_SoundexHelper.setExtendedCharacters(extendedChars);
    }

    @Override
    public ISoundexKey getSoundex(String soundexString) {
        ISoundexKey key = null;
        if (soundexString != null && soundexString.length() != 0) {
            if (this.isSpecialCase(soundexString = soundexString.toUpperCase()) != 0) {
                key = this.handleSpecialCases(soundexString);
            } else {
                soundexString = this.removeUnwantedCharsAndWords(soundexString);
                soundexString = this.replaceSimilarSoundingWords(soundexString);
                char[] inputCharArray = (soundexString = this.replaceExtenededChars(soundexString)).toCharArray();
                if (inputCharArray.length != 0) {
                    key = new MiSoundexKey();
                    char firstCharacter = inputCharArray[0];
                    String normalCharacter = this.m_SoundexHelper.getNormalCharacter(firstCharacter);
                    if (normalCharacter != null) {
                        firstCharacter = normalCharacter.charAt(0);
                    }
                    ((MiSoundexKey)key).setFirstChar(firstCharacter);
                    int returnCode = this.generateSoundex(inputCharArray);
                    ((MiSoundexKey)key).setNumericValue(returnCode);
                }
            }
        }
        return key;
    }

    @Override
    public List calculateAlternateSoundexKeys(String originalString, ISoundexKey originalKey, int possibleErrors, List keys) {
        int type;
        if (possibleErrors != 0 && originalString != null && originalString.length() != 0 && originalKey != null && (type = this.isSpecialCase(originalString = originalString.toUpperCase())) != this.m_SoundexHelper.getSpecialCaseInitialDigit()) {
            originalString = this.removeUnwantedCharsAndWords(originalString);
            String originalUpperString = originalString.toUpperCase();
            char firstChar = ((MiSoundexKey)originalKey).getFirstChar();
            int origNumericVal = ((MiSoundexKey)originalKey).getNumericValue();
            this.getCountrySpecificErrorsSoundex(possibleErrors, keys, firstChar, origNumericVal, originalUpperString);
            this.getFirstCharSoundAlike(possibleErrors, keys, firstChar, origNumericVal);
            this.getSingleCharInsertedSoundex(possibleErrors, keys, originalUpperString);
            this.getSingleCharWrongSoundex(possibleErrors, keys, firstChar, origNumericVal);
            this.getSingleCharDroppedSoundex(possibleErrors, keys, firstChar, origNumericVal);
            this.getAdjacentCharTransposedSoundex(possibleErrors, keys, firstChar, origNumericVal);
        }
        return keys;
    }

    public ISoundexKey getStringKey(String keyString) {
        MiSoundexKey mikey = null;
        if (keyString != null && keyString.trim().length() != 0) {
            int key = 1;
            keyString = keyString.toUpperCase();
            keyString = this.replaceExtenededChars(keyString);
            char character = keyString.charAt(0);
            for (int i = 1; i < keyString.length(); ++i) {
                key |= i << keyString.charAt(i);
            }
            mikey = new MiSoundexKey();
            mikey.setFirstChar(character);
            mikey.setNumericValue(key);
        }
        return mikey;
    }

    protected String replaceSimilarSoundingWords(String inputString) {
        Map soundsMap = this.m_SoundexHelper.getSimilarSoundsWordsMap();
        Set set = soundsMap.keySet();
        String regexString2 = null;
        String replcementValue = null;
        for (String regexString2 : set) {
            replcementValue = (String)soundsMap.get(regexString2);
            if (inputString.indexOf(regexString2) == -1) continue;
            inputString = inputString.replaceAll(regexString2, replcementValue);
        }
        return inputString.toUpperCase();
    }

    protected int generateSoundex(char[] inputStringArray) {
        int inputStringLength = inputStringArray.length;
        int returnCode = 0;
        int base = 1;
        int lastcode = 0;
        int sdx = 0;
        int i = 1;
        int soundexKeysAdded = 0;
        while (i < inputStringLength && soundexKeysAdded < this.m_SoundexHelper.getMaxSoundexKeyLength()) {
            char c = inputStringArray[i];
            boolean bIncrement = true;
            Map soundHash = this.m_SoundexHelper.getSoundHash();
            Integer intKey = (Integer)soundHash.get(new Character(c));
            if (intKey != null) {
                sdx = intKey;
            }
            boolean bVowel = false;
            if (sdx == 0) {
                bVowel = true;
                while (i < inputStringLength) {
                    if (Character.isDigit(c = inputStringArray[i++])) continue;
                    intKey = (Integer)soundHash.get(new Character(c));
                    if (intKey != null) {
                        sdx = intKey;
                    }
                    if (sdx == 0) continue;
                    bIncrement = false;
                    break;
                }
            }
            if (sdx != lastcode || bVowel) {
                returnCode += base * sdx;
                base *= 10;
                lastcode = sdx;
                ++soundexKeysAdded;
            }
            if (!bIncrement) continue;
            ++i;
        }
        return returnCode;
    }

    protected int isSpecialCase(String str) {
        char firstChar = str.charAt(0);
        if (Character.isDigit(firstChar)) {
            return this.m_SoundexHelper.getSpecialCaseInitialDigit();
        }
        return 0;
    }

    protected RemoveWordResult removeWord(String str, String word) {
        RemoveWordResult ret = new RemoveWordResult();
        ret.retStr = str;
        ret.found = 0;
        if (str.indexOf(" ") == -1) {
            ret.found = -1;
            return ret;
        }
        if (str.indexOf(word) == -1) {
            return ret;
        }
        int wordLength = word.length();
        while (str.startsWith(word + ' ')) {
            ret.retStr = str = str.substring(wordLength + 1);
            ret.found = 1;
        }
        while (str.endsWith(' ' + word)) {
            ret.retStr = str = str.substring(0, str.length() - wordLength - 1);
            ret.found = 1;
        }
        int pos = str.indexOf(' ' + word + ' ');
        while (pos > -1) {
            str = str.substring(0, pos) + str.substring(pos + wordLength + 1);
            pos = str.indexOf(' ' + word + ' ');
            ret.retStr = str;
            ret.found = 1;
        }
        if (str.indexOf(" ") == -1) {
            ret.found = -1;
            return ret;
        }
        return ret;
    }

    public String removeUnwantedCharsAndWords(String str) {
        int i;
        String[] ignoredWordArray;
        str.trim();
        if (str.indexOf(" ") != -1 && (ignoredWordArray = this.m_SoundexHelper.getIgnored_Word_Array()) != null) {
            int len = ignoredWordArray.length;
            for (i = 0; i < len; ++i) {
                RemoveWordResult ret = this.removeWord(str, ignoredWordArray[i]);
                str = ret.retStr;
                if (ret.found < 0) break;
            }
        }
        char[] tempArray = str.toCharArray();
        StringBuffer returnBuffer = new StringBuffer(str.length());
        for (i = 0; i < tempArray.length; ++i) {
            char c = tempArray[i];
            if (!Character.isLetterOrDigit(c)) continue;
            returnBuffer.append(c);
        }
        return returnBuffer.toString();
    }

    protected ISoundexKey handleSpecialCases(String str) {
        MiSoundexKey key = null;
        char firstChar = str.charAt(0);
        if (Character.isDigit(firstChar)) {
            int code;
            try {
                Integer tmp = new Integer(StringUtilities.trimToChars(str, "0123456789"));
                code = tmp;
            }
            catch (NumberFormatException e) {
                code = 0;
            }
            key = new MiSoundexKey();
            key.setFirstChar('0');
            key.setNumericValue(code);
        }
        return key;
    }

    protected void getCountrySpecificErrorsSoundex(int possibleErrors, List keys, char firstChar, int originalNumericValue, String originalUpperString) {
    }

    protected void getAdjacentCharTransposedSoundex(int possibleErrors, List keys, char firstChar, int originalNumericValue) {
        if ((possibleErrors & 0x10) > 0) {
            String code = String.valueOf(originalNumericValue);
            int len = code.length() - 1;
            StringBuffer sb = new StringBuffer(len + 1);
            sb.append(code);
            for (int i = 0; i < len; ++i) {
                char c1 = sb.charAt(i);
                char c2 = sb.charAt(i + 1);
                sb.setCharAt(i, c2);
                sb.setCharAt(i + 1, c1);
                MiSoundexKey key = new MiSoundexKey();
                int val = Integer.parseInt(sb.toString());
                key.setNumericValue(val);
                key.setFirstChar(firstChar);
                if (!keys.contains(key)) {
                    keys.add(key);
                }
                sb.setCharAt(i, c1);
                sb.setCharAt(i + 1, c2);
            }
        }
    }

    protected void getSingleCharDroppedSoundex(int possibleErrors, List keys, char firstChar, int originalNumericValue) {
        if ((possibleErrors & 8) > 0) {
            String code = String.valueOf(originalNumericValue);
            int len = code.length();
            if (len == this.m_SoundexHelper.getMaxSoundexKeyLength()) {
                code = code.substring(1);
                --len;
            }
            String validCodes = this.m_SoundexHelper.getValidCodes();
            int end = validCodes.length();
            StringBuffer sb = new StringBuffer(len + 1);
            for (int i = 0; i < len + 1; ++i) {
                for (int j = 0; j < end; ++j) {
                    sb.delete(0, len + 1);
                    sb.append(code);
                    sb.insert(i, validCodes.charAt(j));
                    MiSoundexKey key = new MiSoundexKey();
                    int val = Integer.parseInt(sb.toString());
                    key.setNumericValue(val);
                    key.setFirstChar(firstChar);
                    if (keys.contains(key)) continue;
                    keys.add(key);
                }
            }
        }
    }

    protected void getSingleCharWrongSoundex(int possibleErrors, List keys, char firstChar, int originalNumericValue) {
        if ((possibleErrors & 4) > 0) {
            String code = String.valueOf(originalNumericValue);
            int len = code.length();
            String validCodes = this.m_SoundexHelper.getValidCodes();
            int end = validCodes.length();
            StringBuffer sb = new StringBuffer(len);
            for (int i = 0; i < len; ++i) {
                for (int j = 0; j < end; ++j) {
                    if (code.charAt(i) == validCodes.charAt(j)) continue;
                    sb.delete(0, len);
                    sb.append(code);
                    sb.replace(i, i + 1, new String("" + validCodes.charAt(j)));
                    MiSoundexKey key = new MiSoundexKey();
                    key.setFirstChar(firstChar);
                    int val = Integer.parseInt(sb.toString());
                    key.setNumericValue(val);
                    if (keys.contains(key)) continue;
                    keys.add(key);
                }
            }
        }
    }

    protected void getSingleCharInsertedSoundex(int possibleErrors, List keys, String originalUpper) {
        if ((possibleErrors & 2) > 0) {
            int len = originalUpper.length();
            StringBuffer nameBuf = new StringBuffer(originalUpper);
            for (int i = 1; i < len; ++i) {
                char sound;
                char c = nameBuf.charAt(i);
                String charString = this.m_SoundexHelper.getCharString();
                int idx = charString.indexOf(c);
                if (idx < 0 || (sound = this.m_SoundexHelper.getSoundString().charAt(charString.indexOf(c))) == '0') continue;
                nameBuf.setCharAt(i, 'A');
                MiSoundexKey key = (MiSoundexKey)this.getSoundex(nameBuf.toString());
                if (key != null && !keys.contains(key)) {
                    keys.add(key);
                }
                nameBuf.setCharAt(i, c);
            }
        }
    }

    protected void getFirstCharSoundAlike(int possibleErrors, List keys, char firstChar, int originalNumericValue) {
        if ((possibleErrors & 1) > 0) {
            String charString = this.m_SoundexHelper.getCharString();
            String soundString = this.m_SoundexHelper.getSoundString();
            int idx = charString.indexOf(firstChar);
            if (idx >= 0) {
                char sound = soundString.charAt(idx);
                int end = soundString.lastIndexOf(sound) + 1;
                for (int i = soundString.indexOf(sound); i < end; ++i) {
                    char c = charString.charAt(i);
                    if (c == firstChar) continue;
                    MiSoundexKey key = new MiSoundexKey();
                    key.setNumericValue(originalNumericValue);
                    key.setFirstChar(c);
                    if (keys.contains(key)) continue;
                    keys.add(key);
                }
            }
        }
    }

    protected String replaceExtenededChars(String string) {
        char[] charArray = string.toCharArray();
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < charArray.length; ++i) {
            buffer.append(this.m_SoundexHelper.getNormalCharacter(charArray[i]));
        }
        return buffer.toString();
    }

    protected class RemoveWordResult {
        String retStr;
        int found;

        protected RemoveWordResult() {
        }
    }
}

