/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.licensing;

import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.core.CoreRetrievedCandidates;
import com.mapinfo.mapmarker.core.IRetrievedCandidates;
import com.mapinfo.mapmarker.licensing.MMLicensing;
import com.mapinfo.mapmarker.utils.MMJLog;
import com.mapinfo.scp.spi.License;
import com.mapinfo.scp.spi.LicenseRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public abstract class LicenseFilter {
    public static final int RETRIEVE_MODE_STANDARD = 0;
    public static final int RETRIEVE_MODE_BROWSE = 1;
    public static final int RETRIEVE_MODE_POSTAL = 2;
    public static final int RETRIEVE_MODE_GEOGRAPHIC = 3;

    public IRetrievedCandidates filterCandidates(IRetrievedCandidates candidates, int mode) {
        IRetrievedCandidates result;
        if (candidates.getCandidates().size() > 0) {
            List origCands = candidates.getCandidates();
            ArrayList<ICandidate> filteredCands = new ArrayList<ICandidate>();
            ListIterator itr = origCands.listIterator();
            while (itr.hasNext()) {
                ICandidate candidate = (ICandidate)itr.next();
                ICandidate filteredCand = this.filterCandidate(candidate, mode);
                if (filteredCand == null) continue;
                filteredCands.add(filteredCand);
            }
            result = new CoreRetrievedCandidates();
            result.setCandidates(filteredCands);
        } else {
            result = candidates;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ICandidate filterCandidate(ICandidate candidate, int mode) throws IllegalArgumentException {
        boolean licensed;
        if (mode > 3 || mode < 0) {
            throw new IllegalArgumentException();
        }
        LicenseRequest request = null;
        try {
            request = this.buildRequest(candidate, mode);
        }
        catch (MapMarkerInternalException e) {
            MMJLog.getLog().warn("Unable to filter candidate.", (Throwable)e);
            return null;
        }
        MMLicensing licenser = this.getLicenser();
        if (licenser == null) {
            MMJLog.getLog().error("Null licensing object, unable to check license.");
            return null;
        }
        License license = null;
        try {
            license = licenser.checkout(request);
            licensed = license != null;
        }
        finally {
            if (license != null) {
                licenser.checkin(license);
            }
        }
        if (licensed) {
            return candidate;
        }
        return null;
    }

    protected abstract LicenseRequest buildRequest(ICandidate var1, int var2) throws MapMarkerInternalException;

    protected abstract MMLicensing getLicenser();
}

