/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.licensing;

import com.mapinfo.mapmarker.licensing.MMLicenseException;
import com.mapinfo.mapmarker.utils.MMJLog;
import com.mapinfo.scp.spi.License;
import com.mapinfo.scp.spi.LicenseDefinition;
import com.mapinfo.scp.spi.LicenseException;
import com.mapinfo.scp.spi.LicenseFeature;
import com.mapinfo.scp.spi.LicenseProvider;
import com.mapinfo.scp.spi.LicenseProviderFactory;
import com.mapinfo.scp.spi.LicenseRequest;
import com.mapinfo.scp.spi.LicenseUser;
import java.util.HashMap;
import java.util.Map;

public class MMLicensing {
    private LicenseProvider m_provider;
    private Map m_licenseCache = new HashMap();

    public MMLicensing() throws MMLicenseException {
        try {
            this.m_provider = LicenseProviderFactory.newInstance().getLicenseProvider();
        }
        catch (LicenseException e) {
            throw new MMLicenseException(2200);
        }
    }

    public MMLicensing(String factoryConfigURI, String providerConfigURI) throws MMLicenseException {
        try {
            this.m_provider = LicenseProviderFactory.newInstance((String)factoryConfigURI).getLicenseProvider(providerConfigURI);
        }
        catch (LicenseException e) {
            throw new MMLicenseException(2200);
        }
    }

    public LicenseRequest createLicenseRequest(String featureName, String version) {
        LicenseFeature feature = this.m_provider.createLicenseFeature(featureName, version);
        LicenseUser user = this.m_provider.createLicenseUser(null);
        return this.m_provider.createLicenseRequest(feature, user);
    }

    public License checkout(LicenseRequest request) {
        License result = (License)this.m_licenseCache.get(request);
        if (result == null || !result.isValid()) {
            try {
                result = this.m_provider.checkout(request);
                this.m_licenseCache.put(request, result);
            }
            catch (LicenseException licenseException) {
                // empty catch block
            }
        }
        return result;
    }

    public void checkin(License license) {
    }

    public LicenseDefinition[] getAvailableLicenseDefinitions() {
        try {
            return this.m_provider.getAvailableLicenseDefinitions();
        }
        catch (LicenseException e) {
            MMJLog.getLog().warn("Unable to generate license definition list.", (Throwable)e);
            return new LicenseDefinition[0];
        }
    }
}

