/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.test.dp.binary;

import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.common.IReverseGeocodeCandidate;
import com.mapinfo.mapmarker.common.dp.DataAccessRuntimeException;
import com.mapinfo.mapmarker.common.dp.IReverseGeocodeDataManager;
import com.mapinfo.mapmarker.core.CoreRetrievedCandidates;
import com.mapinfo.mapmarker.core.IRetrievedCandidates;
import com.mapinfo.mapmarker.user.IReverseGeocodeConstraints;
import com.mapinfo.mapmarker.user.ReverseGeocodeCandidateAddress;
import com.mapinfo.mapmarker.user.ReverseGeocodeLocation;
import com.mapinfo.midev.unit.Length;
import com.mapinfo.midev.unit.LinearUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class SimpleTestRGDataManager
implements IReverseGeocodeDataManager {
    private final List<IReverseGeocodeCandidate> m_candidates = new ArrayList<IReverseGeocodeCandidate>();

    public SimpleTestRGDataManager(AddressImpl ... addresses) {
        for (AddressImpl address : addresses) {
            TestCandidate cand = new TestCandidate(address);
            this.m_candidates.add(cand);
        }
    }

    @Override
    public IRetrievedCandidates retrieveReverseGeocodeCandidates(ReverseGeocodeLocation location, IConstraints constraints) throws DataAccessRuntimeException {
        return new CoreRetrievedCandidates(this.m_candidates);
    }

    private static class TestCandidate
    implements IReverseGeocodeCandidate {
        private final Address m_address;

        public TestCandidate(Address address) {
            this.m_address = address;
        }

        @Override
        public ReverseGeocodeCandidateAddress toCandidateAddress(ReverseGeocodeLocation location, IReverseGeocodeConstraints constraints) throws MapMarkerInternalException {
            return new ReverseGeocodeCandidateAddress(this.m_address, 1, new Length(1.0, LinearUnit.METER));
        }

        @Override
        public double getDistance() {
            return 1.0;
        }

        @Override
        public void matchAddressNumber(ReverseGeocodeLocation location, IReverseGeocodeConstraints constraints) {
        }

        @Override
        public boolean isFromCorrectStreetSide(ReverseGeocodeLocation location, IReverseGeocodeConstraints constraints) {
            return true;
        }

        @Override
        public int getUserDictionaryPriority() {
            return 1;
        }

        @Override
        public boolean matchesLocale(Locale loc) {
            return false;
        }

        @Override
        public boolean isDefaultLocale() {
            return false;
        }
    }
}

