/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.test.dp.binary;

import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.common.IReverseGeocodeCandidate;
import com.mapinfo.mapmarker.common.dp.DataAccessException;
import com.mapinfo.mapmarker.common.dp.DataAccessRuntimeException;
import com.mapinfo.mapmarker.common.dp.FatalDataAccessException;
import com.mapinfo.mapmarker.common.dp.FatalDataAccessRuntimeException;
import com.mapinfo.mapmarker.common.dp.IReverseGeocodeDataManager;
import com.mapinfo.mapmarker.core.CoreRetrievedCandidates;
import com.mapinfo.mapmarker.core.IRetrievedCandidates;
import com.mapinfo.mapmarker.test.TestException;
import com.mapinfo.mapmarker.user.IReverseGeocodeConstraints;
import com.mapinfo.mapmarker.user.ReverseGeocodeCandidateAddress;
import com.mapinfo.mapmarker.user.ReverseGeocodeLocation;
import com.mapinfo.midev.unit.Length;
import com.mapinfo.midev.unit.LinearUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;

public class TestRGDataManager
implements IReverseGeocodeDataManager {
    private final BEHAVIOURS m_behaviour;
    private final int m_numCandidatesToReturn;

    public TestRGDataManager(int numCandidatesToReturn) {
        this(numCandidatesToReturn, BEHAVIOURS.STANDARD);
    }

    public TestRGDataManager(int numCandidatesToReturn, BEHAVIOURS behaviour) {
        if (behaviour == null) {
            throw new TestException();
        }
        this.m_behaviour = behaviour;
        this.m_numCandidatesToReturn = numCandidatesToReturn;
    }

    @Override
    public IRetrievedCandidates retrieveReverseGeocodeCandidates(ReverseGeocodeLocation location, IConstraints constraints) throws DataAccessRuntimeException {
        switch (this.m_behaviour) {
            case STANDARD: 
            case TIED_DISTANCE: {
                if (this.m_numCandidatesToReturn == 0) {
                    return new CoreRetrievedCandidates(Collections.emptyList());
                }
                ArrayList<TestCandidate> candidates = new ArrayList<TestCandidate>(this.m_numCandidatesToReturn);
                for (int i = 0; i < this.m_numCandidatesToReturn; ++i) {
                    int distance = 0;
                    if (this.m_behaviour != BEHAVIOURS.TIED_DISTANCE) {
                        distance = i;
                    }
                    candidates.add(new TestCandidate(distance));
                }
                return new CoreRetrievedCandidates(candidates);
            }
            case HIGH_DISTANCE: {
                if (this.m_numCandidatesToReturn == 0) {
                    return new CoreRetrievedCandidates(Collections.emptyList());
                }
                ArrayList<TestCandidate> candidates = new ArrayList<TestCandidate>(this.m_numCandidatesToReturn);
                for (int i = 0; i < this.m_numCandidatesToReturn; ++i) {
                    int distance = 5000;
                    candidates.add(new TestCandidate(distance));
                }
                return new CoreRetrievedCandidates(candidates);
            }
            case EMPTY: {
                return new CoreRetrievedCandidates(Collections.emptyList());
            }
            case FDAEx: {
                throw new FatalDataAccessRuntimeException(new FatalDataAccessException(2308));
            }
            case DAEx: {
                throw new DataAccessRuntimeException(new DataAccessException(2308));
            }
            case NOT_LICENSED: {
                CoreRetrievedCandidates candidates = new CoreRetrievedCandidates(null);
                candidates.setDataLicensed(false);
                return candidates;
            }
        }
        return null;
    }

    private static class TestCandidate
    implements IReverseGeocodeCandidate {
        private int m_distance;

        private TestCandidate(int distance) {
            this.m_distance = distance;
        }

        public boolean isCloseMatch() {
            return false;
        }

        @Override
        public ReverseGeocodeCandidateAddress toCandidateAddress(ReverseGeocodeLocation location, IReverseGeocodeConstraints constraints) {
            return new ReverseGeocodeCandidateAddress((Address)new AddressImpl(), 1, new Length((double)this.m_distance, LinearUnit.METER));
        }

        @Override
        public double getDistance() {
            return this.m_distance;
        }

        @Override
        public void matchAddressNumber(ReverseGeocodeLocation location, IReverseGeocodeConstraints constraints) {
        }

        @Override
        public boolean isFromCorrectStreetSide(ReverseGeocodeLocation location, IReverseGeocodeConstraints constraints) {
            return true;
        }

        @Override
        public int getUserDictionaryPriority() {
            return 1;
        }

        @Override
        public boolean matchesLocale(Locale loc) {
            return false;
        }

        @Override
        public boolean isDefaultLocale() {
            return false;
        }
    }

    public static enum BEHAVIOURS {
        STANDARD,
        EMPTY,
        FDAEx,
        DAEx,
        NOT_LICENSED,
        TIED_DISTANCE,
        HIGH_DISTANCE;

    }
}

