/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.user;

import com.mapinfo.mapmarker.IGeocodeConstraints;
import com.mapinfo.mapmarker.common.IDictionarySearchOrder;
import com.mapinfo.mapmarker.user.IReverseGeocodeConstraints;
import com.mapinfo.mapmarker.utils.MidevConversionUtils;
import com.mapinfo.midev.unit.Length;
import com.mapinfo.midev.unit.LinearUnit;
import com.mapinfo.unit.Distance;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public abstract class AbstractReverseGeocodeConstraints
implements IReverseGeocodeConstraints {
    private Locale m_locale;
    private IDictionarySearchOrder m_order;
    private int m_maxRangeUnits;
    private Distance m_cornerOffsetAsDistance;
    private Distance m_streetOffsetAsDistance;
    private Length m_cornerOffsetAsLength;
    private Length m_streetOffsetAsLength;
    private boolean fallbackToPostal;
    private boolean fallbackToGeographic;
    private boolean m_bSortUsingLocale;
    private HashMap<String, String> m_customValues = new HashMap();

    public AbstractReverseGeocodeConstraints() {
        IGeocodeConstraints defGC = this.getLocalConstraints();
        this.m_locale = defGC.getClientLocale();
        this.m_order = defGC.getDictionarySearchOrder();
        LinearUnit coUnit = MidevConversionUtils.getLinearUnit(defGC.getCornerOffsetUnits());
        this.m_cornerOffsetAsLength = new Length(defGC.getCornerOffset(), coUnit);
        LinearUnit soUnit = MidevConversionUtils.getLinearUnit(defGC.getStreetOffsetUnits());
        this.m_streetOffsetAsLength = new Length(defGC.getStreetOffset(), soUnit);
        this.m_bSortUsingLocale = false;
    }

    public AbstractReverseGeocodeConstraints(IReverseGeocodeConstraints source) {
        this.setClientLocale(source.getClientLocale());
        this.setDictionarySearchOrder(source.getDictionarySearchOrder());
        this.setMaxRangeUnits(source.getMaxRangeUnits());
        this.setCornerOffset(source.getCornerOffsetAsLength());
        this.setStreetOffset(source.getStreetOffsetAsLength());
        this.setSortCandidatesUsingLocale(source.getSortCandidatesUsingLocale());
        this.setFallbackToGeographic(source.isFallbackToGeographic());
        this.setFallbackToPostal(source.isFallbackToPostal());
        for (Map.Entry<String, String> e : source.getCustomValues().entrySet()) {
            this.setCustomString(e.getKey(), e.getValue());
        }
    }

    protected abstract IGeocodeConstraints getLocalConstraints();

    @Override
    public void setClientLocale(Locale locale) {
        this.m_locale = locale;
    }

    @Override
    public Locale getClientLocale() {
        return this.m_locale;
    }

    @Override
    public void setDictionarySearchOrder(IDictionarySearchOrder order) {
        this.m_order = order;
    }

    @Override
    public IDictionarySearchOrder getDictionarySearchOrder() {
        return this.m_order;
    }

    @Override
    public void setMaxRangeUnits(int maxRangeUnits) {
        if (maxRangeUnits < -1) {
            throw new IllegalArgumentException();
        }
        this.m_maxRangeUnits = maxRangeUnits;
    }

    @Override
    public int getMaxRangeUnits() {
        return this.m_maxRangeUnits;
    }

    @Override
    public void setCornerOffset(Distance offset) {
        this.m_cornerOffsetAsDistance = offset;
        this.m_cornerOffsetAsLength = MidevConversionUtils.convertToLength(offset);
    }

    @Override
    public void setCornerOffset(Length offset) {
        this.m_cornerOffsetAsLength = offset;
    }

    @Override
    public Distance getCornerOffset() {
        if (this.m_cornerOffsetAsDistance == null) {
            this.m_cornerOffsetAsDistance = MidevConversionUtils.convertToDistance(this.m_cornerOffsetAsLength);
        }
        return this.m_cornerOffsetAsDistance;
    }

    @Override
    public Length getCornerOffsetAsLength() {
        return this.m_cornerOffsetAsLength;
    }

    @Override
    public void setStreetOffset(Length offset) {
        this.m_streetOffsetAsLength = offset;
    }

    @Override
    public void setStreetOffset(Distance offset) {
        this.m_streetOffsetAsDistance = offset;
        this.m_streetOffsetAsLength = MidevConversionUtils.convertToLength(offset);
    }

    @Override
    public Distance getStreetOffset() {
        if (this.m_streetOffsetAsDistance == null) {
            this.m_streetOffsetAsDistance = MidevConversionUtils.convertToDistance(this.m_streetOffsetAsLength);
        }
        return this.m_streetOffsetAsDistance;
    }

    @Override
    public Length getStreetOffsetAsLength() {
        return this.m_streetOffsetAsLength;
    }

    @Override
    public void setSortCandidatesUsingLocale(boolean flag) {
        this.m_bSortUsingLocale = flag;
    }

    @Override
    public boolean getSortCandidatesUsingLocale() {
        return this.m_bSortUsingLocale;
    }

    @Override
    public void setCustomString(String key, String value) {
        this.m_customValues.put(key, value);
    }

    @Override
    public String getCustomString(String key) {
        return this.m_customValues.get(key);
    }

    @Override
    public Map<String, String> getCustomValues() {
        return new HashMap<String, String>(this.m_customValues);
    }

    @Override
    public boolean isFallbackToPostal() {
        return this.fallbackToPostal;
    }

    @Override
    public void setFallbackToPostal(boolean fallbackToPostal) {
        this.fallbackToPostal = fallbackToPostal;
    }

    @Override
    public boolean isFallbackToGeographic() {
        return this.fallbackToGeographic;
    }

    @Override
    public void setFallbackToGeographic(boolean fallbackToGeographic) {
        this.fallbackToGeographic = fallbackToGeographic;
    }
}

