/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.user;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.common.ParsedInputAddress;
import java.util.ArrayList;
import java.util.List;

public abstract class ClientGeocodeResponse {
    private int m_totalCount = 0;
    private int m_totalCloseCount = 0;
    private boolean m_bUniqueMatchFound = false;
    private List m_candidates = null;
    protected String m_requestAddressID = null;
    private boolean m_bDataLicensed;
    private ParsedInputAddress m_ParsedInputAddress;

    protected ClientGeocodeResponse() {
    }

    protected ClientGeocodeResponse(String requestAddressID, int totalCount, int totalClose, boolean bUniqueMatchFound, boolean bDataLicensed, List candidates, ParsedInputAddress parsedInputAddress) {
        this.m_requestAddressID = requestAddressID;
        this.m_totalCount = totalCount;
        this.m_totalCloseCount = totalClose;
        this.setUniqueMatchFound(bUniqueMatchFound);
        this.m_bDataLicensed = bDataLicensed;
        this.m_ParsedInputAddress = parsedInputAddress == null ? null : new ParsedInputAddress(parsedInputAddress);
        if (candidates != null) {
            this.m_candidates = new ArrayList(candidates.size());
            this.m_candidates.addAll(candidates);
        }
    }

    public int candidateCount() {
        if (this.m_candidates != null) {
            return this.m_candidates.size();
        }
        return 0;
    }

    public CandidateAddress candidateAt(int index) {
        if (this.m_candidates != null && index < this.m_candidates.size()) {
            return (CandidateAddress)this.m_candidates.get(index);
        }
        return null;
    }

    public int totalPossibleCandidates() {
        return this.m_totalCount;
    }

    public int totalPossibleCloseMatchCandidates() {
        return this.m_totalCloseCount;
    }

    public boolean isUniqueMatchFound() {
        return this.m_bUniqueMatchFound;
    }

    protected void setUniqueMatchFound(boolean bUniqueMatchFound) {
        this.m_bUniqueMatchFound = bUniqueMatchFound;
    }

    public boolean getDataLicensed() {
        return this.m_bDataLicensed;
    }

    public ParsedInputAddress getParsedInputAddress() {
        return this.m_ParsedInputAddress;
    }
}

