/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.user;

import com.mapinfo.mapmarker.IGeocodeConstraints;
import com.mapinfo.mapmarker.common.MMJCommonXMLWriter;
import com.mapinfo.mapmarker.user.ClientRequestContainer;
import com.mapinfo.mapmarker.user.IReverseGeocodeConstraints;
import com.mapinfo.mapmarker.user.ReverseGeocodeLocation;
import com.mapinfo.midev.coordsys.CoordSys;
import java.io.IOException;
import java.io.OutputStream;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

class MMJRequestXMLWriter
extends MMJCommonXMLWriter {
    XMLOutputter out;
    OutputStream outputStream;

    protected MMJRequestXMLWriter(XMLOutputter out, OutputStream outputStream) {
        this.out = out;
        this.outputStream = outputStream;
    }

    protected void write(ClientRequestContainer requestContainer) throws IOException {
        ClientRequestContainer.ClientRequest[] requests;
        Element envelope = new Element("RequestEnvelope");
        Element requestEl = new Element("GeocodeRequest");
        this.setAttribute(requestEl, "requestID", requestContainer.getID());
        for (ClientRequestContainer.ClientRequest request : requests = requestContainer.getRequests()) {
            Element addressEl = new Element("InputAddress");
            this.setAttribute(addressEl, "addressID", request.getAddress().getAddressID());
            this.writeUniversalAddressXML(addressEl, request.getAddress());
            if (request.getConstraints() != null) {
                this.writeGeocodeConstraintsXML(addressEl, request.getConstraints(), requestContainer.getDefaultConstraints(), false);
            }
            requestEl.addContent(addressEl);
        }
        if (requestContainer.getDefaultConstraints() != null) {
            this.writeGeocodeConstraintsXML(requestEl, requestContainer.getDefaultConstraints(), null, false);
        }
        envelope.addContent(requestEl);
        this.out.output(envelope, this.outputStream);
        this.outputStream.close();
    }

    protected void writeDictionarySearchOrderRequest(String countryCode, IGeocodeConstraints constraints) throws IOException {
        Element envelope = new Element("RequestEnvelope");
        Element requestEl = new Element("DictionarySearchOrderRequest");
        if (countryCode != null) {
            this.addChild(requestEl, "Country", countryCode);
        }
        if (constraints != null) {
            this.writeGeocodeConstraintsXML(requestEl, constraints, null, false);
        }
        envelope.addContent(requestEl);
        this.out.output(envelope, this.outputStream);
        this.outputStream.close();
    }

    protected void writeReverseGeocodeRequest(int requestType, String country, ReverseGeocodeLocation location, IReverseGeocodeConstraints constraints) throws IOException {
        Element envelope = new Element("RequestEnvelope");
        Element requestEl = new Element("ReverseGeocode");
        Element inputEl = new Element("ReverseGeocodeInput");
        if (country != null) {
            this.setAttribute(inputEl, "country", country);
        }
        if (requestType != 0) {
            this.setAttribute(inputEl, "type", String.valueOf(requestType));
        }
        Element locEl = new Element("location");
        this.writeCoord(locEl, location.getPositionPoint());
        CoordSys csys = location.getCoordSysObject();
        if (csys != null) {
            this.writeCoordSys(locEl, csys);
        }
        this.write(locEl, "distance", location.getDistanceAsLength());
        inputEl.addContent(locEl);
        requestEl.addContent(inputEl);
        this.write(requestEl, constraints);
        envelope.addContent(requestEl);
        this.out.output(envelope, this.outputStream);
        this.outputStream.close();
    }
}

