/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.user;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.CandidateRange;
import com.mapinfo.mapmarker.CandidateRangeUnit;
import com.mapinfo.mapmarker.IGeocodeConstraints;
import com.mapinfo.mapmarker.MMGeneralGeocoderException;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.IDictionarySearchOrder;
import com.mapinfo.mapmarker.common.MMJCommonXMLReader;
import com.mapinfo.mapmarker.common.ParsedInputAddress;
import com.mapinfo.mapmarker.user.ClientGeocodeResponse;
import com.mapinfo.mapmarker.user.ClientResponseContainer;
import com.mapinfo.mapmarker.user.MapMarkerClientException;
import com.mapinfo.mapmarker.user.MapMarkerException;
import com.mapinfo.mapmarker.user.MapMarkerFatalException;
import com.mapinfo.mapmarker.user.ReverseGeocodeCandidateAddress;
import com.mapinfo.mapmarker.user.ReverseGeocodeResponse;
import com.mapinfo.mapmarker.utils.ISO3166;
import com.mapinfo.mapmarker.utils.VersionDescriptor;
import com.mapinfo.midev.unit.Length;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;

class MMJResponseXMLReader
extends MMJCommonXMLReader {
    MMJResponseXMLReader() {
    }

    protected IGeocodeConstraints readConstraintsResponse(Document doc) {
        Element elRoot = doc.getRootElement();
        Element request = elRoot.getChild("ConstraintsRequest");
        return this.readGeocodeConstraintsXML(request.getChild("GeocodeConstraints"), null);
    }

    protected VersionDescriptor readVersionsResponse(Document doc) {
        Element elRoot = doc.getRootElement();
        Element request = elRoot.getChild("VersionsResponse");
        String coreVersion = request.getChild("CoreVersion").getText();
        HashMap<ISO3166, String> pluginVersionMap = new HashMap<ISO3166, String>();
        Element elPluginVersionList = request.getChild("PluginVersionList");
        if (elPluginVersionList != null) {
            for (Element elPluginVersion : elPluginVersionList.getChildren("PluginVersion")) {
                pluginVersionMap.put(ISO3166.findCountryByISO3(elPluginVersion.getChild("Country").getText()), elPluginVersion.getChild("Version").getText());
            }
        }
        return new VersionDescriptor(pluginVersionMap, coreVersion){};
    }

    protected ClientResponseContainer readGeocodeResponse(Document doc, String transactionID) throws MapMarkerFatalException, MapMarkerException {
        ClientResponseContainer response = new ClientResponseContainer(transactionID);
        Element root = doc.getRootElement();
        Element geocodeResponseElement = root.getChild("GeocodeResponse");
        if (geocodeResponseElement == null) {
            Element errorResponseElement = root.getChild("ErrorResponse");
            if (errorResponseElement != null) {
                this.handleErrorResponse(errorResponseElement);
            } else {
                throw new MapMarkerClientException(2406);
            }
        }
        int responseCode = 0;
        Element responseCodeElement = geocodeResponseElement.getChild("ResponseCode");
        if (responseCodeElement != null && responseCodeElement.getText().length() != 0) {
            responseCode = Integer.parseInt(responseCodeElement.getText());
        }
        String responseMessage = null;
        Element responseMessageElement = geocodeResponseElement.getChild("Message");
        if (responseMessageElement != null && responseMessageElement.getText().length() != 0) {
            responseMessage = responseMessageElement.getText();
        }
        String errorModule = null;
        Element errorModuleElement = geocodeResponseElement.getChild("ErrorModule");
        if (errorModuleElement != null && errorModuleElement.getText().length() != 0) {
            errorModule = errorModuleElement.getText();
        }
        String errorType = null;
        Element errorTypeElement = geocodeResponseElement.getChild("ErrorType");
        if (errorTypeElement != null && errorTypeElement.getText().length() != 0) {
            errorType = errorTypeElement.getText();
        }
        if ("Fatal".equals(errorType)) {
            throw new MapMarkerFatalException(responseMessage, responseCode, errorModule);
        }
        if ("Normal".equals(errorType)) {
            throw new MapMarkerException(responseMessage, responseCode, errorModule);
        }
        for (Element requestResultElement : geocodeResponseElement.getChildren("RequestResult")) {
            responseCode = 0;
            responseCodeElement = requestResultElement.getChild("ResponseCode");
            if (responseCodeElement != null && responseCodeElement.getText().length() != 0) {
                responseCode = Integer.parseInt(responseCodeElement.getText());
            }
            responseMessage = null;
            responseMessageElement = requestResultElement.getChild("Message");
            if (responseMessageElement != null && responseMessageElement.getText().length() != 0) {
                responseMessage = responseMessageElement.getText();
            }
            errorModule = null;
            errorModuleElement = requestResultElement.getChild("ErrorModule");
            if (errorModuleElement != null && errorModuleElement.getText().length() != 0) {
                errorModule = errorModuleElement.getText();
            }
            errorType = null;
            errorTypeElement = requestResultElement.getChild("ErrorType");
            if (errorTypeElement != null && errorTypeElement.getText().length() != 0) {
                errorType = errorTypeElement.getText();
            }
            if ("Fatal".equals(errorType)) {
                throw new MapMarkerFatalException(responseMessage, responseCode, errorModule);
            }
            if ("Normal".equals(errorType)) {
                throw new MapMarkerException(responseMessage, responseCode, errorModule);
            }
            String addressID = requestResultElement.getAttributeValue("addressID");
            int intTotalFound = 0;
            int intTotalClose = 0;
            boolean bUniqueFound = false;
            boolean bDataLicensed = true;
            Element geocodeSummaryElement = requestResultElement.getChild("GeocodeSummary");
            if (geocodeSummaryElement != null) {
                Element summaryFieldElement = geocodeSummaryElement.getChild("TotalLocationsFound");
                if (summaryFieldElement != null && summaryFieldElement.getText().length() != 0) {
                    intTotalFound = Integer.parseInt(summaryFieldElement.getText());
                }
                if ((summaryFieldElement = geocodeSummaryElement.getChild("TotalCloseMatchesFound")) != null && summaryFieldElement.getText().length() != 0) {
                    intTotalClose = Integer.parseInt(summaryFieldElement.getText());
                }
                if ((summaryFieldElement = geocodeSummaryElement.getChild("UniqueCloseMatchFound")) != null && summaryFieldElement.getText().length() != 0) {
                    bUniqueFound = summaryFieldElement.getText().equalsIgnoreCase("TRUE");
                }
                if ((summaryFieldElement = geocodeSummaryElement.getChild("dataLicensed")) != null && summaryFieldElement.getText().length() != 0) {
                    bDataLicensed = summaryFieldElement.getText().equalsIgnoreCase("TRUE");
                }
            }
            List<CandidateAddress> candidatesList = this.readCandidates(requestResultElement);
            Element ParsedInputElement = requestResultElement.getChild("ParsedInput");
            ParsedInputAddress parsed = null;
            if (ParsedInputElement != null) {
                parsed = this.readParsed(ParsedInputElement);
            }
            response.addResponse(new ClientGeocodeResponse(addressID, intTotalFound, intTotalClose, bUniqueFound, bDataLicensed, candidatesList, parsed){});
        }
        return response;
    }

    private ParsedInputAddress readParsed(Element element) {
        ParsedInputAddress parsedInput = null;
        Element addrElement = element.getChild("Address");
        if (addrElement == null) {
            return null;
        }
        Address addr = this.readUniversalAddressXML(addrElement);
        parsedInput = new ParsedInputAddress(addr);
        return parsedInput;
    }

    private List<CandidateAddress> readCandidates(Element element) throws MapMarkerException {
        ArrayList<CandidateAddress> candidatesList = null;
        List candidateElementsList = element.getChildren("Candidate");
        if (candidateElementsList != null && !candidateElementsList.isEmpty()) {
            candidatesList = new ArrayList<CandidateAddress>(candidateElementsList.size());
            for (Object o : candidateElementsList) {
                CandidateAddress candidate = null;
                Element candidateElement = (Element)o;
                if (candidateElement != null) {
                    String tmpString;
                    String tmpAttribute;
                    Element addrElement = candidateElement.getChild("Address");
                    Address addr = this.readUniversalAddressXML(addrElement);
                    candidate = new CandidateAddress(addr);
                    Element pointElement = candidateElement.getChild("Point");
                    if (pointElement != null) {
                        try {
                            MMJCommonXMLReader.PointWithSRS pointWithSRS = this.parsePoint(pointElement);
                            candidate.setLocation(pointWithSRS.getPoint());
                            candidate.setCoordSysString(pointWithSRS.getSRS());
                        }
                        catch (MMGeneralGeocoderException MMGGEx) {
                            throw new MapMarkerException(MMGGEx.getMessage(), MMGGEx.getErrorCode(), MMGGEx.getMessageModule());
                        }
                    }
                    if ("true".equals(candidateElement.getAttributeValue("closeMatch"))) {
                        candidate.setCloseMatch();
                    }
                    if ("true".equals(candidateElement.getAttributeValue("intersection"))) {
                        candidate.setLocationPrecision(6);
                    }
                    if ("true".equals(candidateElement.getAttributeValue("addressNumberMatched"))) {
                        candidate.setAddressNumberMatched();
                    }
                    if ("true".equals(candidateElement.getAttributeValue("areaName1Matched"))) {
                        candidate.setAreaName1Matched();
                    }
                    if ("true".equals(candidateElement.getAttributeValue("areaName2Matched"))) {
                        candidate.setAreaName2Matched();
                    }
                    if ("true".equals(candidateElement.getAttributeValue("areaName3Matched"))) {
                        candidate.setAreaName3Matched();
                    }
                    if ("true".equals(candidateElement.getAttributeValue("areaName4Matched"))) {
                        candidate.setAreaName4Matched();
                    }
                    if ("true".equals(candidateElement.getAttributeValue("countryMatched"))) {
                        candidate.setCountryMatched();
                    }
                    if ("true".equals(candidateElement.getAttributeValue("genericField1Matched"))) {
                        candidate.setGenericField1Matched();
                    }
                    if ("true".equals(candidateElement.getAttributeValue("genericField2Matched"))) {
                        candidate.setGenericField2Matched();
                    }
                    if ("true".equals(candidateElement.getAttributeValue("genericField3Matched"))) {
                        candidate.setGenericField3Matched();
                    }
                    if ("true".equals(candidateElement.getAttributeValue("genericField4Matched"))) {
                        candidate.setGenericField4Matched();
                    }
                    if ("true".equals(candidateElement.getAttributeValue("postCode1Matched"))) {
                        candidate.setPostalCode1Matched();
                    }
                    if ("true".equals(candidateElement.getAttributeValue("postCode2Matched"))) {
                        candidate.setPostalCode2Matched();
                    }
                    if ("true".equals(candidateElement.getAttributeValue("streetNameFieldsMatched"))) {
                        candidate.setStreetNameMatched();
                        candidate.setStreetPrefixAndSuffixMatched();
                        candidate.setPreDirectionalMatched();
                        candidate.setPostDirectionalMatched();
                        candidate.setThoroughfareTypeMatched();
                    } else {
                        if ("true".equals(candidateElement.getAttributeValue("streetNameMatched"))) {
                            candidate.setStreetNameMatched();
                        }
                        if ("true".equals(candidateElement.getAttributeValue("streetPrefixSuffixMatched"))) {
                            candidate.setStreetPrefixAndSuffixMatched();
                        }
                        if ("true".equals(candidateElement.getAttributeValue("preDirectionalMatched"))) {
                            candidate.setPreDirectionalMatched();
                        }
                        if ("true".equals(candidateElement.getAttributeValue("postDirectionalMatched"))) {
                            candidate.setPostDirectionalMatched();
                        }
                        if ("true".equals(candidateElement.getAttributeValue("thoroughfareTypeMatched"))) {
                            candidate.setThoroughfareTypeMatched();
                        }
                    }
                    if ("true".equals(candidateElement.getAttributeValue("placeNameMatched"))) {
                        candidate.setPlaceNameMatched();
                    }
                    if ((tmpAttribute = candidateElement.getAttributeValue("fmtdAddr")) != null) {
                        candidate.setFormattedStreetAddress(tmpAttribute);
                    }
                    if ((tmpAttribute = candidateElement.getAttributeValue("fmtdLoc")) != null) {
                        candidate.setFormattedLocationAddress(tmpAttribute);
                    }
                    if ((tmpAttribute = candidateElement.getAttributeValue("srcStID")) != null) {
                        candidate.setSourceStreetID(Long.parseLong(tmpAttribute));
                    }
                    if ((tmpAttribute = candidateElement.getAttributeValue("matchPrecision")) != null) {
                        candidate.setLocationPrecision(Integer.parseInt(tmpAttribute));
                    }
                    if ("true".equals(candidateElement.getAttributeValue("fromUserDictionary"))) {
                        candidate.setFromUserDictionary();
                    }
                    if ((tmpAttribute = candidateElement.getAttributeValue("CfgOrder")) != null) {
                        candidate.setConfiguredDictionaryNumber(Integer.parseInt(tmpAttribute));
                    }
                    if ((tmpString = candidateElement.getChildText("TotalRangesFound")) != null && tmpString.length() != 0) {
                        candidate.setNumberOfReturnableRanges(Integer.parseInt(tmpString));
                    }
                    List<CandidateRange> ranges = this.readRanges(candidateElement);
                    for (CandidateRange range : ranges) {
                        candidate.addCandidateRange(range);
                    }
                }
                if (candidate == null) {
                    candidate = new CandidateAddress();
                }
                candidatesList.add(candidate);
            }
        }
        return candidatesList;
    }

    private List<CandidateRange> readRanges(Element element) {
        List rangeElements = element.getChildren("Range");
        ArrayList<CandidateRange> ranges = new ArrayList<CandidateRange>(rangeElements.size());
        for (Object o : rangeElements) {
            Element tmpRangeElement;
            Element rangeElement = (Element)o;
            CandidateRange range = new CandidateRange();
            String tmpString = rangeElement.getChildText("lowAddressNumber");
            if (tmpString != null) {
                range.setLowAddress(tmpString);
            }
            if ((tmpString = rangeElement.getChildText("highAddressNumber")) != null) {
                range.setHighAddress(tmpString);
            }
            if ((tmpString = rangeElement.getChildText("streetSide")) != null) {
                range.setLeftRightIndicator(Integer.parseInt(tmpString));
            }
            if ((tmpString = rangeElement.getChildText("rangeType")) != null) {
                range.setOddEvenIndicator(Integer.parseInt(tmpString));
            }
            if ((tmpRangeElement = rangeElement.getChild("Address")) != null) {
                Address rangeAddr = this.readUniversalAddressXML(tmpRangeElement);
                range.setRangeAddress(rangeAddr);
            }
            if ((tmpRangeElement = rangeElement.getChild("AdditionalFields")) != null) {
                HashMap addFlds = new HashMap();
                this.readAdditionalFieldsXML(tmpRangeElement, addFlds);
                range.setAdditionalFields(addFlds);
            }
            if ((tmpString = rangeElement.getChildText("TotalRangeUnitsFound")) != null && tmpString.length() != 0) {
                range.setNumberOfReturnableRangeUnits(Integer.parseInt(tmpString));
            }
            List<CandidateRangeUnit> units = this.readUnits(rangeElement);
            for (CandidateRangeUnit unit : units) {
                range.addRangeUnit(unit);
            }
            ranges.add(range);
        }
        return ranges;
    }

    private List<CandidateRangeUnit> readUnits(Element element) {
        List unitElements = element.getChildren("RangeUnit");
        ArrayList<CandidateRangeUnit> units = new ArrayList<CandidateRangeUnit>(unitElements.size());
        for (Object o : unitElements) {
            Element addFieldsElement;
            Element addressElement;
            Element unitElement = (Element)o;
            CandidateRangeUnit rangeUnit = new CandidateRangeUnit();
            String tmpString = unitElement.getChildText("lowUnit");
            if (tmpString != null) {
                rangeUnit.setLowUnitNumber(tmpString);
            }
            if ((tmpString = unitElement.getChildText("highUnit")) != null) {
                rangeUnit.setHighUnitNumber(tmpString);
            }
            if ((addressElement = unitElement.getChild("Address")) != null) {
                Address rangeUnitAddr = this.readUniversalAddressXML(addressElement);
                rangeUnit.setRangeUnitAddress(rangeUnitAddr);
            }
            if ((addFieldsElement = unitElement.getChild("AdditionalFields")) != null) {
                HashMap addFlds = new HashMap();
                this.readAdditionalFieldsXML(addFieldsElement, addFlds);
                rangeUnit.setAdditionalFields(addFlds);
            }
            units.add(rangeUnit);
        }
        return units;
    }

    protected IDictionarySearchOrder readDictionarySearchOrderResponse(Document doc) throws MapMarkerFatalException, MapMarkerException {
        Element root = doc.getRootElement();
        Element dictResponseElement = root.getChild("DictionarySearchOrderResponse");
        if (dictResponseElement == null) {
            Element errorResponseElement = root.getChild("ErrorResponse");
            if (errorResponseElement != null) {
                this.handleErrorResponse(errorResponseElement);
            } else {
                throw new MapMarkerClientException(2406);
            }
        }
        int responseCode = 0;
        Element responseCodeElement = dictResponseElement.getChild("ResponseCode");
        if (responseCodeElement != null && responseCodeElement.getText().length() != 0) {
            responseCode = Integer.parseInt(responseCodeElement.getText());
        }
        String responseMessage = null;
        Element responseMessageElement = dictResponseElement.getChild("Message");
        if (responseMessageElement != null && responseMessageElement.getText().length() != 0) {
            responseMessage = responseMessageElement.getText();
        }
        String errorModule = null;
        Element errorModuleElement = dictResponseElement.getChild("ErrorModule");
        if (errorModuleElement != null && errorModuleElement.getText().length() != 0) {
            errorModule = errorModuleElement.getText();
        }
        String errorType = null;
        Element errorTypeElement = dictResponseElement.getChild("ErrorType");
        if (errorTypeElement != null && errorTypeElement.getText().length() != 0) {
            errorType = errorTypeElement.getText();
        }
        if ("Fatal".equals(errorType)) {
            throw new MapMarkerFatalException(responseMessage, responseCode, errorModule);
        }
        if ("Normal".equals(errorType)) {
            throw new MapMarkerException(responseMessage, responseCode, errorModule);
        }
        return this.readDictionarySearchOrderResponse(dictResponseElement);
    }

    private static String parseSRS(Element point) {
        return point.getAttributeValue("srsName");
    }

    public String[] readLicenseInformationResponse(Document doc) {
        ArrayList<String> defs = new ArrayList<String>();
        Element root = doc.getRootElement();
        Element elLicenseResponse = root.getChild("LicenseInformationResponse");
        if (elLicenseResponse != null) {
            Element elLicenseInformationList = elLicenseResponse.getChild("LicenseInformationList");
            List infElements = elLicenseInformationList.getChildren("LicenseInformation");
            for (int i = 0; i < infElements.size(); ++i) {
                Element elDef = (Element)infElements.get(i);
                defs.add(elDef.getTextTrim());
            }
        } else {
            Element errorResponseElement = root.getChild("ErrorResponse");
            if (errorResponseElement != null) {
                try {
                    this.handleErrorResponse(errorResponseElement);
                }
                catch (MapMarkerException MMEx) {
                    String[] ret = new String[]{MMEx.getMessage()};
                    return ret;
                }
                catch (MapMarkerFatalException MMFEx) {
                    String[] ret = new String[]{MMFEx.getMessage()};
                    return ret;
                }
            } else {
                String[] ret = new String[]{"Null response from server on license information request."};
                return ret;
            }
        }
        return defs.toArray(new String[0]);
    }

    public void handleErrorResponse(Element errorElement) throws MapMarkerException, MapMarkerFatalException {
        int responseCode = 0;
        Element responseCodeElement = errorElement.getChild("ResponseCode");
        if (responseCodeElement != null && responseCodeElement.getText().length() != 0) {
            responseCode = Integer.parseInt(responseCodeElement.getText());
        }
        String responseMessage = null;
        Element responseMessageElement = errorElement.getChild("Message");
        if (responseMessageElement != null && responseMessageElement.getText().length() != 0) {
            responseMessage = responseMessageElement.getText();
        }
        String errorModule = null;
        Element errorModuleElement = errorElement.getChild("ErrorModule");
        if (errorModuleElement != null && errorModuleElement.getText().length() != 0) {
            errorModule = errorModuleElement.getText();
        }
        String errorType = null;
        Element errorTypeElement = errorElement.getChild("ErrorType");
        if (errorTypeElement != null && errorTypeElement.getText().length() != 0) {
            errorType = errorTypeElement.getText();
        }
        if ("Fatal".equals(errorType)) {
            throw new MapMarkerFatalException(responseMessage, responseCode, errorModule);
        }
        if ("Normal".equals(errorType)) {
            throw new MapMarkerException(responseMessage, responseCode, errorModule);
        }
    }

    protected final ReverseGeocodeResponse readReverseGeocodeResponse(Document doc) throws MapMarkerFatalException, MapMarkerException {
        Element root = doc.getRootElement();
        Element rgResponse = root.getChild("ReverseGeocodeResponse");
        if (rgResponse == null) {
            Element errorResponseElement = root.getChild("ErrorResponse");
            if (errorResponseElement != null) {
                this.handleErrorResponse(errorResponseElement);
                return null;
            }
            throw new MapMarkerClientException(2406);
        }
        Element rgResultElement = rgResponse.getChild("ReverseGeocodeResult");
        if (rgResultElement == null) {
            throw new MapMarkerClientException(2406);
        }
        Element errorElement = rgResultElement.getChild("ErrorResponse");
        if (errorElement != null) {
            this.handleErrorResponse(errorElement);
            return null;
        }
        String licensedAttr = rgResultElement.getAttributeValue("dataLicensed");
        ReverseGeocodeResponse response = new ReverseGeocodeResponse(this.readReverseGeocodeCandidates(rgResultElement));
        if (licensedAttr != null) {
            response.setDataLicensed("true".equals(licensedAttr));
        }
        return response;
    }

    private List<ReverseGeocodeCandidateAddress> readReverseGeocodeCandidates(Element element) throws MapMarkerException {
        ArrayList<ReverseGeocodeCandidateAddress> candidatesList = null;
        List candidateElementsList = element.getChildren("Candidate");
        if (candidateElementsList != null && !candidateElementsList.isEmpty()) {
            candidatesList = new ArrayList<ReverseGeocodeCandidateAddress>(candidateElementsList.size());
            for (Object o : candidateElementsList) {
                Length distance;
                Element candidateElement = (Element)o;
                Element addrElement = candidateElement.getChild("Address");
                Element distanceElement = candidateElement.getChild("distance");
                try {
                    distance = this.readDistance(distanceElement);
                }
                catch (MMGeneralGeocoderException MMGGEx) {
                    throw new MapMarkerException(MMGGEx.getMessage(), MMGGEx.getErrorCode(), MMGGEx.getMessageModule());
                }
                ReverseGeocodeCandidateAddress candidate = new ReverseGeocodeCandidateAddress(this.readUniversalAddressXML(addrElement), Integer.parseInt(candidateElement.getAttributeValue("CfgOrder")), distance);
                String tmpAttribute = candidateElement.getAttributeValue("fmtdAddr");
                if (tmpAttribute != null) {
                    candidate.setFormattedStreetAddress(tmpAttribute);
                }
                if ((tmpAttribute = candidateElement.getAttributeValue("fmtdLoc")) != null) {
                    candidate.setFormattedLocationAddress(tmpAttribute);
                }
                if ("true".equals(candidateElement.getAttributeValue("fromUserDictionary"))) {
                    candidate.setFromUserDictionary();
                }
                try {
                    Element pointElement = candidateElement.getChild("Point");
                    if (pointElement == null) {
                        throw new MMGeneralGeocoderException(2310);
                    }
                    MMJCommonXMLReader.PointWithSRS point = this.parsePoint(pointElement);
                    candidate.setLocation(point.getPoint());
                    candidate.setCoordSysString(point.getSRS());
                }
                catch (MMGeneralGeocoderException MMGGEx) {
                    throw new MapMarkerException(MMGGEx.getMessage(), MMGGEx.getErrorCode(), MMGGEx.getMessageModule());
                }
                candidate.setLocationPrecision(Integer.parseInt(candidateElement.getAttributeValue("pointPrecision")));
                String tmpString = candidateElement.getChildText("TotalRangesFound");
                if (tmpString != null && tmpString.length() != 0) {
                    candidate.setNumberOfReturnableRanges(Integer.parseInt(tmpString));
                }
                List<CandidateRange> ranges = this.readRanges(candidateElement);
                for (CandidateRange range : ranges) {
                    candidate.addCandidateRange(range);
                }
                candidatesList.add(candidate);
            }
        }
        return candidatesList;
    }
}

