/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.user;

import com.mapinfo.mapmarker.CandidateRange;
import com.mapinfo.mapmarker.ICandidateRangeIterator;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.user.IResponseCandidate;
import com.mapinfo.mapmarker.utils.MidevConversionUtils;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.unit.Length;
import com.mapinfo.unit.Distance;
import com.mapinfo.util.DoublePoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class ReverseGeocodeCandidateAddress
extends AddressImpl
implements IResponseCandidate {
    private String m_formattedStreetAddress;
    private String m_formattedLocationAddress;
    private List<CandidateRange> m_candidateRangeList;
    private boolean m_bCandidateRangesSorted;
    private int m_numberOfReturnableRanges;
    private boolean m_bFromUserDictionary;
    private int m_dictionaryNumber;
    private DirectPosition m_location;
    private int m_locationPrecision;
    private String m_coordSysString;
    private Length m_distance;
    private Distance m_distanceOldFormat = null;

    public ReverseGeocodeCandidateAddress(Address source, int configuredDictionaryNumber, Distance distance) {
        this(source, configuredDictionaryNumber, MidevConversionUtils.convertToLength(distance));
        this.m_distanceOldFormat = new Distance(distance);
    }

    public ReverseGeocodeCandidateAddress(Address source, int configuredDictionaryNumber, Length distance) {
        super(source);
        if (configuredDictionaryNumber < 1 || source == null || distance == null) {
            throw new IllegalArgumentException();
        }
        this.m_dictionaryNumber = configuredDictionaryNumber;
        this.m_distance = new Length(distance.getValue(), distance.getUnit());
        this.m_candidateRangeList = new ArrayList<CandidateRange>(2);
        this.m_location = new DirectPosition();
        this.m_locationPrecision = 0;
        this.m_coordSysString = "epsg:4326";
    }

    @Override
    public String getFormattedStreetAddress() {
        return this.m_formattedStreetAddress;
    }

    public void setFormattedStreetAddress(String formattedStreetAddress) {
        this.m_formattedStreetAddress = formattedStreetAddress;
    }

    @Override
    public String getFormattedLocationAddress() {
        return this.m_formattedLocationAddress;
    }

    public void setFormattedLocationAddress(String formattedLocationAddress) {
        this.m_formattedLocationAddress = formattedLocationAddress;
    }

    public void addCandidateRange(CandidateRange range) {
        this.m_bCandidateRangesSorted = false;
        this.m_candidateRangeList.add(range);
    }

    public void setNumberOfReturnableRanges(int size) {
        this.m_numberOfReturnableRanges = size;
    }

    @Override
    public int getNumberOfCandidateRangesFound() {
        return this.m_candidateRangeList.size();
    }

    @Override
    public int getNumberOfCandidateRanges() {
        int candidateRangeListSize = this.m_candidateRangeList.size();
        if (this.m_numberOfReturnableRanges < 0 || this.m_numberOfReturnableRanges > candidateRangeListSize) {
            return candidateRangeListSize;
        }
        return this.m_numberOfReturnableRanges;
    }

    private void sortCandidateRanges() {
        if (this.m_candidateRangeList.isEmpty()) {
            this.m_bCandidateRangesSorted = true;
            return;
        }
        Collections.sort(this.m_candidateRangeList);
        this.m_bCandidateRangesSorted = true;
    }

    @Override
    public ICandidateRangeIterator rangeIterator() {
        if (!this.m_bCandidateRangesSorted) {
            this.sortCandidateRanges();
        }
        return new CandidateRangeIterator(this.m_numberOfReturnableRanges, this.m_candidateRangeList.iterator());
    }

    public void setFromUserDictionary() {
        this.m_bFromUserDictionary = true;
    }

    @Override
    public boolean fromUserDictionary() {
        return this.m_bFromUserDictionary;
    }

    public void setConfiguredDictionaryNumber(int number) {
        if (number < 1) {
            throw new IllegalArgumentException();
        }
        this.m_dictionaryNumber = number;
    }

    @Override
    public int getConfiguredDictionaryNumber() {
        return this.m_dictionaryNumber;
    }

    public void setLocation(DoublePoint p) {
        if (p == null) {
            throw new IllegalArgumentException("Cannot set location to null");
        }
        this.m_location = new DirectPosition(p.x, p.y);
    }

    public void setLocation(DirectPosition p) {
        if (p == null) {
            throw new IllegalArgumentException("Cannot set location to null");
        }
        this.m_location = new DirectPosition(p);
    }

    @Override
    public DoublePoint getLocation() {
        return new DoublePoint(this.m_location.getX(), this.m_location.getY());
    }

    @Override
    public DirectPosition getLocationPoint() {
        return this.m_location;
    }

    public void setLocationPrecision(int locationPrecision) {
        this.m_locationPrecision = locationPrecision < 0 || locationPrecision > 18 ? 0 : locationPrecision;
    }

    @Override
    public int getLocationPrecision() {
        return this.m_locationPrecision;
    }

    public void setCoordSysString(String coordSysString) {
        if (coordSysString == null) {
            throw new IllegalArgumentException("Cannot set coordSysString to null");
        }
        this.m_coordSysString = coordSysString;
    }

    @Override
    public String getCoordSysString() {
        return this.m_coordSysString;
    }

    public Distance getDistance() {
        if (this.m_distanceOldFormat == null) {
            this.m_distanceOldFormat = MidevConversionUtils.convertToDistance(this.m_distance);
        }
        return this.m_distanceOldFormat;
    }

    public Length getLength() {
        return this.m_distance;
    }

    public String getPrecisionCode() {
        return (String)this.getAdditionalFields().get("RESULT_CODE");
    }

    public void setPrecisionCode(String code) {
        this.getAdditionalFields().put("RESULT_CODE", code);
    }

    @Override
    public String toString() {
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer returnString = new StringBuffer(super.toString());
        returnString.append(lineSeparator);
        returnString.append("distance: ");
        returnString.append(this.getDistance().toString());
        returnString.append(lineSeparator);
        returnString.append("formattedStreetAddress: ");
        returnString.append(this.getFormattedStreetAddress());
        returnString.append(lineSeparator);
        returnString.append("formattedLocationAddress: ");
        returnString.append(this.getFormattedLocationAddress());
        returnString.append(lineSeparator);
        returnString.append("fromUserDictionary: ");
        returnString.append(this.fromUserDictionary());
        returnString.append(lineSeparator);
        returnString.append("configuredDictionaryNumber: ");
        returnString.append(this.getConfiguredDictionaryNumber());
        returnString.append(lineSeparator);
        returnString.append("location: ");
        returnString.append(this.m_location);
        returnString.append(lineSeparator);
        returnString.append("locationPrecision: ");
        returnString.append(this.getLocationPrecision());
        returnString.append(lineSeparator);
        returnString.append("coordSysString: ");
        returnString.append(this.getCoordSysString());
        returnString.append(lineSeparator);
        returnString.append(lineSeparator);
        returnString.append("This candidate has ");
        returnString.append(this.getNumberOfCandidateRanges());
        returnString.append(" CandidateRange(s).");
        returnString.append(lineSeparator);
        return returnString.toString();
    }

    private static class CandidateRangeIterator
    implements ICandidateRangeIterator {
        private final int m_max;
        private int m_current;
        private final Iterator<CandidateRange> m_i;

        private CandidateRangeIterator(int max, Iterator<CandidateRange> i) {
            this.m_max = max;
            this.m_i = i;
        }

        @Override
        public boolean hasNext() {
            if (this.m_max == -1 || this.m_current < this.m_max) {
                return this.m_i.hasNext();
            }
            return false;
        }

        @Override
        public CandidateRange next() {
            if (this.m_max == -1 || this.m_current < this.m_max) {
                ++this.m_current;
                return this.m_i.next();
            }
            throw new NoSuchElementException();
        }
    }
}

