/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.utils;

import com.mapinfo.mapmarker.utils.IMappedByteBufferProvider;
import com.mapinfo.mapmarker.utils.MMJLog;
import com.mapinfo.mapmarker.utils.SlicedMappedByteBuffer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

abstract class AbstractMappedByteBufferProvider
implements IMappedByteBufferProvider {
    private final Map m_buffers = new HashMap();
    private final Set m_unMappableFiles = new HashSet();

    protected AbstractMappedByteBufferProvider() {
    }

    @Override
    public void releaseAllBuffers() {
        this.m_buffers.clear();
    }

    protected SlicedMappedByteBuffer getBuffer(File file) {
        return (SlicedMappedByteBuffer)this.m_buffers.get(file);
    }

    protected void putBuffer(File file, SlicedMappedByteBuffer buffer) {
        if (buffer != null) {
            this.m_buffers.put(file, buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SlicedMappedByteBuffer makeBuffer(File file) throws IOException {
        if (this.m_unMappableFiles.contains(file)) {
            return null;
        }
        try (FileInputStream stream = null;){
            stream = new FileInputStream(file);
            try {
                SlicedMappedByteBuffer slicedMappedByteBuffer = new SlicedMappedByteBuffer(stream.getChannel());
                return slicedMappedByteBuffer;
            }
            catch (IOException IOEx) {
                SlicedMappedByteBuffer slicedMappedByteBuffer;
                block8: {
                    MMJLog.getLog().warn("Unable to map file: " + file.getName());
                    this.m_unMappableFiles.add(file);
                    slicedMappedByteBuffer = null;
                    if (stream == null) break block8;
                    stream.close();
                }
                return slicedMappedByteBuffer;
            }
        }
    }
}

