/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.utils;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.utils.MidevConversionUtils;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;

public class AddressUtils {
    public static Address toUpperCaseAddress(Address ura, Locale locale) {
        AddressImpl ura2 = new AddressImpl();
        ura2.setAddressNumber(AddressUtils.toUpperCase(ura.getAddressNumber(), locale));
        ura2.setMainAddress(AddressUtils.toUpperCase(ura.getMainAddress(), locale));
        ura2.setPlaceName(AddressUtils.toUpperCase(ura.getPlaceName(), locale));
        ura2.setPostCode1(AddressUtils.toUpperCase(ura.getPostCode1(), locale));
        ura2.setPostCode2(AddressUtils.toUpperCase(ura.getPostCode2(), locale));
        ura2.setAreaName1(AddressUtils.toUpperCase(ura.getAreaName1(), locale));
        ura2.setAreaName2(AddressUtils.toUpperCase(ura.getAreaName2(), locale));
        ura2.setAreaName3(AddressUtils.toUpperCase(ura.getAreaName3(), locale));
        ura2.setAreaName4(AddressUtils.toUpperCase(ura.getAreaName4(), locale));
        ura2.setCountry(AddressUtils.toUpperCase(ura.getCountry(), locale));
        ura2.setGenericField1(AddressUtils.toUpperCase(ura.getGenericField1(), locale));
        ura2.setGenericField2(AddressUtils.toUpperCase(ura.getGenericField2(), locale));
        ura2.setGenericField3(AddressUtils.toUpperCase(ura.getGenericField3(), locale));
        ura2.setGenericField4(AddressUtils.toUpperCase(ura.getGenericField4(), locale));
        ura2.setPostAddress(AddressUtils.toUpperCase(ura.getPostAddress(), locale));
        ura2.setPostDirectional(AddressUtils.toUpperCase(ura.getPostDirectional(), locale));
        ura2.setPostThoroughfareType(AddressUtils.toUpperCase(ura.getPostThoroughfareType(), locale));
        ura2.setPreAddress(AddressUtils.toUpperCase(ura.getPreAddress(), locale));
        ura2.setPreDirectional(AddressUtils.toUpperCase(ura.getPreDirectional(), locale));
        ura2.setPreThoroughfareType(AddressUtils.toUpperCase(ura.getPreThoroughfareType(), locale));
        ura2.setUnitType(AddressUtils.toUpperCase(ura.getUnitType(), locale));
        ura2.setUnitValue(AddressUtils.toUpperCase(ura.getUnitValue(), locale));
        if (ura.hasAdditionalFields()) {
            for (Object key : ura.getAdditionalFields().keySet()) {
                if (ura2.getAdditionalFields().containsKey(key)) {
                    ura2.getAdditionalFields().remove(key);
                }
                ura2.getAdditionalFields().put(key, AddressUtils.toUpperCase((String)ura.getAdditionalFields().get(key), locale));
            }
        }
        return ura2;
    }

    private static String toUpperCase(String src, Locale locale) {
        if (src == null) {
            return null;
        }
        if (locale != null) {
            return src.toUpperCase(locale);
        }
        return src.toUpperCase();
    }

    public static void copyAddress(Address src, Address dst) {
        dst.setAddressNumber(src.getAddressNumber());
        dst.setMainAddress(src.getMainAddress());
        dst.setPlaceName(src.getPlaceName());
        dst.setPostCode1(src.getPostCode1());
        dst.setPostCode2(src.getPostCode2());
        dst.setAreaName1(src.getAreaName1());
        dst.setAreaName2(src.getAreaName2());
        dst.setAreaName3(src.getAreaName3());
        dst.setAreaName4(src.getAreaName4());
        dst.setCountry(src.getCountry());
        dst.setGenericField1(src.getGenericField1());
        dst.setGenericField2(src.getGenericField2());
        dst.setGenericField3(src.getGenericField3());
        dst.setGenericField4(src.getGenericField4());
        dst.setPostAddress(src.getPostAddress());
        dst.setPostDirectional(src.getPostDirectional());
        dst.setPostThoroughfareType(src.getPostThoroughfareType());
        dst.setPreAddress(src.getPreAddress());
        dst.setPreDirectional(src.getPreDirectional());
        dst.setPreThoroughfareType(src.getPreThoroughfareType());
        dst.setUnitType(src.getUnitType());
        dst.setUnitValue(src.getUnitValue());
        dst.getAdditionalFields().clear();
        if (src.hasAdditionalFields()) {
            dst.getAdditionalFields().putAll(src.getAdditionalFields());
        }
    }

    public static boolean areSameAddress(Address addr1, Address addr2) {
        if (!StringUtilities.equalStrings(addr1.getAddressNumber(), addr2.getAddressNumber())) {
            return false;
        }
        if (!StringUtilities.equalStrings(addr1.getAreaName1(), addr2.getAreaName1())) {
            return false;
        }
        if (!StringUtilities.equalStrings(addr1.getAreaName2(), addr2.getAreaName2())) {
            return false;
        }
        if (!StringUtilities.equalStrings(addr1.getAreaName3(), addr2.getAreaName3())) {
            return false;
        }
        if (!StringUtilities.equalStrings(addr1.getAreaName4(), addr2.getAreaName4())) {
            return false;
        }
        if (!StringUtilities.equalStrings(addr1.getGenericField1(), addr2.getGenericField1())) {
            return false;
        }
        if (!StringUtilities.equalStrings(addr1.getGenericField2(), addr2.getGenericField2())) {
            return false;
        }
        if (!StringUtilities.equalStrings(addr1.getGenericField3(), addr2.getGenericField3())) {
            return false;
        }
        if (!StringUtilities.equalStrings(addr1.getGenericField4(), addr2.getGenericField4())) {
            return false;
        }
        if (!StringUtilities.equalStrings(addr1.getMainAddress(), addr2.getMainAddress())) {
            return false;
        }
        if (!StringUtilities.equalStrings(addr1.getPlaceName(), addr2.getPlaceName())) {
            return false;
        }
        if (!StringUtilities.equalStrings(addr1.getPostAddress(), addr2.getPostAddress())) {
            return false;
        }
        if (!StringUtilities.equalStrings(addr1.getPostCode1(), addr2.getPostCode1())) {
            return false;
        }
        if (!StringUtilities.equalStrings(addr1.getPostCode2(), addr2.getPostCode2())) {
            return false;
        }
        if (!StringUtilities.equalStrings(addr1.getPostDirectional(), addr2.getPostDirectional())) {
            return false;
        }
        if (!StringUtilities.equalStrings(addr1.getPostThoroughfareType(), addr2.getPostThoroughfareType())) {
            return false;
        }
        if (!StringUtilities.equalStrings(addr1.getPreAddress(), addr2.getPreAddress())) {
            return false;
        }
        if (!StringUtilities.equalStrings(addr1.getPreDirectional(), addr2.getPreDirectional())) {
            return false;
        }
        if (!StringUtilities.equalStrings(addr1.getPreThoroughfareType(), addr2.getPreThoroughfareType())) {
            return false;
        }
        if (!StringUtilities.equalStrings(addr1.getUnitType(), addr2.getUnitType())) {
            return false;
        }
        if (!StringUtilities.equalStrings(addr1.getUnitValue(), addr2.getUnitValue())) {
            return false;
        }
        return AddressUtils.areSameAdditionalFields(addr1.getAdditionalFields(), addr2.getAdditionalFields());
    }

    public static boolean areSameAdditionalFields(HashMap fields1, HashMap fields2) {
        if (fields1 == fields2) {
            return true;
        }
        if (fields1 == null ^ fields2 == null) {
            return false;
        }
        if (fields1.isEmpty() && !fields2.isEmpty()) {
            return false;
        }
        if (!fields1.isEmpty() && fields2.isEmpty()) {
            return false;
        }
        if (fields1.isEmpty()) {
            return true;
        }
        if (fields1.size() != fields2.size()) {
            return false;
        }
        Set fields1Keys = fields1.keySet();
        for (String key1 : fields1Keys) {
            String value2;
            if (!fields2.containsKey(key1)) {
                return false;
            }
            String value1 = (String)fields1.get(key1);
            if (StringUtilities.equalStrings(value1, value2 = (String)fields2.get(key1))) continue;
            return false;
        }
        return true;
    }

    public static void fixCoordSysString(CandidateAddress candidate, IConstraints constraints) {
        if (candidate != null && StringUtilities.isEmpty(candidate.getCoordSysString())) {
            if (constraints != null && constraints.getClientCoordinateSystemObject() != null && !StringUtilities.isEmpty(MidevConversionUtils.getSRSname(constraints.getClientCoordinateSystemObject()))) {
                candidate.setCoordSysString(MidevConversionUtils.getSRSname(constraints.getClientCoordinateSystemObject()));
            } else {
                candidate.setCoordSysString("epsg:4326");
            }
        }
    }
}

