/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.utils;

import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.CoordSysConstants;
import com.mapinfo.midev.coordsys.factory.CoordSysFactory;
import com.mapinfo.midev.coordsys.transform.CoordTransform;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.util.DoublePoint;
import java.util.ArrayList;
import java.util.List;

public class CoordConvertor {
    public static DoublePoint transformPointFromWGS84(com.mapinfo.coordsys.CoordSys targetCoordSys, DoublePoint pnt) {
        if (targetCoordSys == null || pnt == null) {
            return pnt;
        }
        CoordSys target = CoordSysFactory.getDefaultCoordSysFactory().getCoordSys(targetCoordSys.getSrsName());
        DirectPosition pos = CoordConvertor.transformPoint(CoordSysConstants.longLatWGS84, target, new DirectPosition(pnt.x, pnt.y));
        return new DoublePoint(pos.getX(), pos.getY());
    }

    public static DoublePoint transformPointFromWGS84(com.mapinfo.coordsys.CoordSys targetCoordSys, DirectPosition pnt) {
        if (pnt == null) {
            return null;
        }
        if (targetCoordSys == null) {
            return new DoublePoint(pnt.getX(), pnt.getY());
        }
        CoordSys target = CoordSysFactory.getDefaultCoordSysFactory().getCoordSys(targetCoordSys.getSrsName());
        DirectPosition pos = CoordConvertor.transformPoint(CoordSysConstants.longLatWGS84, target, pnt);
        return new DoublePoint(pos.getX(), pos.getY());
    }

    public static DirectPosition transformPointFromWGS84(CoordSys targetCoordSys, DirectPosition pnt) {
        return CoordConvertor.transformPoint(CoordSysConstants.longLatWGS84, targetCoordSys, pnt);
    }

    public static DirectPosition transformPointToWGS84(CoordSys startingCoordSys, DirectPosition pnt) {
        return CoordConvertor.transformPoint(startingCoordSys, CoordSysConstants.longLatWGS84, pnt);
    }

    public static List<DirectPosition> transformPointsToWGS84(CoordSys startingCoordSys, List<DirectPosition> pnts) {
        ArrayList<DirectPosition> result = new ArrayList<DirectPosition>(pnts.size());
        for (DirectPosition pnt : pnts) {
            result.add(CoordConvertor.transformPointToWGS84(startingCoordSys, pnt));
        }
        return result;
    }

    private static DirectPosition transformPoint(CoordSys startingCoordSys, CoordSys targetCoordSys, DirectPosition pnt) {
        if (targetCoordSys == null || startingCoordSys == null || pnt == null) {
            return null;
        }
        CoordTransform transformer = new CoordTransform(startingCoordSys, targetCoordSys);
        DirectPosition transformedPoint = new DirectPosition();
        transformer.transform(pnt, transformedPoint);
        return transformedPoint;
    }
}

