/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.utils;

import com.mapinfo.mapmarker.common.dp.DataAccessException;
import com.mapinfo.mapmarker.common.dp.DataAccessRuntimeException;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class DataInputStreamIterator<E>
implements Iterator<E>,
Closeable {
    private DataInputStream m_stream;
    private boolean m_bOpen = false;
    private E m_nextValue;

    public void open(String fileName) throws IOException, DataAccessRuntimeException {
        this.open(new FileInputStream(new File(fileName)));
    }

    protected void open(InputStream stream) throws IOException, DataAccessRuntimeException {
        if (this.m_bOpen) {
            throw new DataAccessRuntimeException(new DataAccessException(2102, new String[]{"Iterator is already open."}));
        }
        this.m_stream = new DataInputStream(new BufferedInputStream(stream));
        this.m_bOpen = true;
    }

    protected abstract E read(DataInputStream var1) throws IOException;

    @Override
    public boolean hasNext() throws DataAccessRuntimeException {
        if (!this.m_bOpen) {
            throw new DataAccessRuntimeException(new DataAccessException(2102, new String[]{"Iterator is not open."}));
        }
        if (this.m_nextValue == null) {
            try {
                this.m_nextValue = this.read(this.m_stream);
            }
            catch (EOFException EOFEx) {
                return false;
            }
            catch (IOException IOEx) {
                throw new DataAccessRuntimeException(new DataAccessException(2102, (Throwable)IOEx));
            }
        }
        return true;
    }

    @Override
    public E next() throws DataAccessRuntimeException {
        if (!this.m_bOpen) {
            throw new DataAccessRuntimeException(new DataAccessException(2102, new String[]{"Iterator is not open."}));
        }
        if (this.m_nextValue != null || this.hasNext()) {
            E temp = this.m_nextValue;
            this.m_nextValue = null;
            return temp;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        if (!this.m_bOpen) {
            throw new DataAccessRuntimeException(new DataAccessException(2102, new String[]{"Iterator is not open."}));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        if (this.m_stream != null) {
            this.m_bOpen = false;
            this.m_stream.close();
            this.m_stream = null;
        }
    }
}

