/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.utils;

import com.mapinfo.mapmarker.utils.EnglishNumericAbbreviations;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.mapmarker.utils.StringWithTokens;

public class EnglishVerbalNumber {
    private EnglishVerbalNumber() {
    }

    public static String convertInteger(int val) {
        return EnglishVerbalNumber.getVerbalThousands(val).trim();
    }

    public static String convertNumericStreetToVerbal(String numericStreet) {
        if (StringUtilities.isEmpty(numericStreet) || !Character.isDigit(numericStreet.charAt(0))) {
            return numericStreet;
        }
        int endIndex = numericStreet.length();
        if (numericStreet.endsWith("ST") || numericStreet.endsWith("ND") || numericStreet.endsWith("RD") || numericStreet.endsWith("TH")) {
            endIndex -= 2;
        }
        if (StringUtilities.isNumeric(numericStreet, 0, endIndex)) {
            String verbalPart = EnglishVerbalNumber.convertInteger(Integer.parseInt(numericStreet.substring(0, endIndex)));
            if (verbalPart == null) {
                return numericStreet;
            }
            if (endIndex == numericStreet.length()) {
                return verbalPart;
            }
            StringWithTokens tokens = new StringWithTokens(verbalPart, " ");
            String lastTokenAbbr = EnglishNumericAbbreviations.getAbbrFromValue(tokens.getLastToken());
            String newLastToken = null;
            if (lastTokenAbbr != null) {
                String suffix = numericStreet.substring(endIndex, numericStreet.length());
                newLastToken = EnglishNumericAbbreviations.getExpandedName(lastTokenAbbr + suffix);
            } else if (numericStreet.endsWith("TH") && ("THOUSAND".equals(tokens.getLastToken()) || "HUNDRED".equals(tokens.getLastToken()))) {
                newLastToken = tokens.getLastToken() + "TH";
            }
            if (newLastToken == null) {
                return numericStreet;
            }
            tokens.removeLast();
            tokens.insert(tokens.size(), newLastToken);
            return tokens.toStringWithSep(' ');
        }
        return numericStreet;
    }

    public static String convertVerbalToNumericStreetString(String val) {
        String value;
        StringWithTokens tokens = new StringWithTokens(val.toUpperCase(), " ");
        if (tokens.size() == 1 && (value = EnglishNumericAbbreviations.getAbbrFromValue(tokens.getFirstToken())) != null && value.length() >= 1 && Character.isDigit(value.charAt(0))) {
            return value;
        }
        int retVal = EnglishVerbalNumber.convertString(tokens, true);
        if (retVal != -1) {
            String lastTokenAbbr = EnglishNumericAbbreviations.getAbbrFromValue(tokens.getLastToken());
            String numberStr = String.valueOf(retVal);
            if (!StringUtilities.isEmpty(lastTokenAbbr) && Character.isLetter(lastTokenAbbr.charAt(lastTokenAbbr.length() - 1))) {
                String suffix = null;
                if (numberStr.length() >= 2 && '1' == numberStr.charAt(numberStr.length() - 2)) {
                    suffix = "TH";
                }
                if (suffix == null) {
                    char lastNumericChar = numberStr.charAt(numberStr.length() - 1);
                    suffix = lastNumericChar == '1' ? "ST" : (lastNumericChar == '2' ? "ND" : (lastNumericChar == '3' ? "RD" : "TH"));
                }
                return numberStr + suffix;
            }
            if ("THOUSANDTH".equals(tokens.getLastToken()) || "HUNDREDTH".equals(tokens.getLastToken())) {
                return numberStr + "TH";
            }
            return numberStr;
        }
        return val;
    }

    public static int convertString(String val) {
        if (val == null || val.length() == 0) {
            return -1;
        }
        return EnglishVerbalNumber.convertString(new StringWithTokens(val.toUpperCase(), " "), false);
    }

    public static int convertString(StringWithTokens tokens, boolean bOnlyAcceptVerbal) {
        if (tokens == null || tokens.isEmpty()) {
            return -1;
        }
        int total = 0;
        StringWithTokens.TokenIterator iter = tokens.iterator();
        while (iter.hasNext()) {
            String token = iter.next();
            int currentValue = EnglishVerbalNumber.getIntVal(token, bOnlyAcceptVerbal);
            if (currentValue == -1) {
                if (token.equals("THOUSAND") || token.equals("THOUSANDTH")) {
                    if (total == 0) {
                        total = 1000;
                        continue;
                    }
                    total *= 1000;
                    continue;
                }
                if (token.equals("HUNDRED") || token.equals("HUNDREDTH")) {
                    if (total == 0) {
                        total = 100;
                        continue;
                    }
                    total *= 100;
                    continue;
                }
                if (!bOnlyAcceptVerbal || "AND".equals(token) && total >= 100) continue;
                return -1;
            }
            if (currentValue > total) {
                total *= 100;
            }
            total += currentValue;
        }
        return total;
    }

    private static String getVerbalThousands(int intVal) {
        StringBuffer sTmp = new StringBuffer();
        int tmp = intVal;
        if (intVal >= 1000) {
            tmp = intVal / 1000;
            String key = String.valueOf(tmp);
            sTmp.append(EnglishNumericAbbreviations.getExpandedName(key));
            tmp = intVal - tmp * 1000;
            sTmp.append(" THOUSAND");
        }
        sTmp.append(EnglishVerbalNumber.getVerbalHundreds(tmp));
        return sTmp.toString();
    }

    private static String getVerbalHundreds(int intVal) {
        StringBuffer sTmp = new StringBuffer();
        int tmp = intVal;
        if (intVal >= 100) {
            tmp = intVal / 100;
            String key = String.valueOf(tmp);
            sTmp.append(" ");
            sTmp.append(EnglishNumericAbbreviations.getExpandedName(key));
            tmp = intVal - tmp * 100;
            sTmp.append(" HUNDRED");
        }
        sTmp.append(EnglishVerbalNumber.getVerbalTens(tmp));
        return sTmp.toString();
    }

    private static String getVerbalTens(int intVal) {
        StringBuffer sTmp = new StringBuffer();
        int tmp = intVal;
        if (intVal > 20 & intVal % 10 != 0) {
            tmp = intVal / 10;
            String key = String.valueOf(tmp * 10);
            sTmp.append(" ");
            sTmp.append(EnglishNumericAbbreviations.getExpandedName(key));
            tmp = intVal - tmp * 10;
        } else if (tmp > 0) {
            sTmp.append(" ");
            sTmp.append(EnglishNumericAbbreviations.getExpandedName(String.valueOf(intVal)));
            tmp = 0;
        }
        if (tmp > 0) {
            sTmp.append(" ");
            sTmp.append(EnglishNumericAbbreviations.getExpandedName(String.valueOf(tmp)));
        }
        return sTmp.toString();
    }

    private static int getIntVal(String token, boolean bOnlyAcceptVerbal) {
        String strVal;
        if (Character.isDigit(token.charAt(0))) {
            if (bOnlyAcceptVerbal) {
                return -1;
            }
            boolean bParseToken = false;
            if (StringUtilities.isNumeric(token)) {
                bParseToken = true;
            } else {
                int digitCount;
                int tokenLength = token.length();
                for (digitCount = 0; Character.isDigit(token.charAt(digitCount)) && digitCount < tokenLength; ++digitCount) {
                }
                if (digitCount + 2 == tokenLength && (token.endsWith("TH") || token.endsWith("ST") || token.endsWith("RD") || token.endsWith("ND"))) {
                    token = token.substring(0, digitCount);
                    bParseToken = true;
                }
            }
            if (bParseToken) {
                try {
                    return Integer.parseInt(token);
                }
                catch (NumberFormatException NFEx) {
                    return -1;
                }
            }
        }
        if ((strVal = EnglishNumericAbbreviations.getAbbrFromValue(token)) == null) {
            return -1;
        }
        if (Character.isLetter(strVal.charAt(0))) {
            if (bOnlyAcceptVerbal) {
                return -1;
            }
            return Integer.parseInt(token);
        }
        if ((strVal = EnglishVerbalNumber.removeCharsFromBack(strVal)) == null) {
            return -1;
        }
        return Integer.parseInt(strVal);
    }

    private static String removeCharsFromBack(String strVal) {
        int index;
        if (strVal == null || strVal.length() == 0) {
            return strVal;
        }
        for (index = strVal.length() - 1; index >= 0 && Character.isLetter(strVal.charAt(index)); --index) {
        }
        if (index < 0) {
            return null;
        }
        if (++index == strVal.length()) {
            return strVal;
        }
        return strVal.substring(0, index);
    }
}

