/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.utils;

import com.mapinfo.mapmarker.licensing.MMLicenseException;
import com.mapinfo.mapmarker.utils.MMCustomConfiguration;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Properties;

public class FileUtilities {
    private FileUtilities() {
    }

    private static Object loadResource(String resourceName, String ext) {
        String resName = resourceName.replace('.', '/') + (ext != null ? (ext.startsWith(".") ? ext : "." + ext) : "");
        InputStream stream = null;
        stream = MMCustomConfiguration.getUseCustomProperties() ? FileUtilities.loadCustomResourceFilter(resName) : FileUtilities.class.getClassLoader().getResourceAsStream(resName);
        if (stream != null) {
            return new BufferedInputStream(stream);
        }
        String modifiedResourceName = resourceName.startsWith("/") || resourceName.startsWith(".") ? resourceName.substring(1) : "/".concat(resourceName);
        stream = FileUtilities.class.getClassLoader().getResourceAsStream(modifiedResourceName);
        if (stream != null) {
            return new BufferedInputStream(stream);
        }
        return null;
    }

    private static InputStream loadCustomResourceFilter(String resName) {
        InputStream stream;
        try {
            stream = resName.endsWith("DataManagerSettings.properties") ? FileUtilities.getUrlFromString(MMCustomConfiguration.getConfigLocation() + resName).openStream() : FileUtilities.class.getClassLoader().getResourceAsStream(resName);
        }
        catch (Exception e) {
            stream = FileUtilities.class.getClassLoader().getResourceAsStream(resName);
        }
        return stream;
    }

    public static InputStream getResourceAsStream(String resourceNameWithExt) {
        int pos = resourceNameWithExt.lastIndexOf(46);
        if (pos < 0 || pos == resourceNameWithExt.length() - 1) {
            return (InputStream)FileUtilities.loadResource(resourceNameWithExt, null);
        }
        String ext = resourceNameWithExt.substring(pos + 1);
        String name = resourceNameWithExt.substring(0, pos);
        return (InputStream)FileUtilities.loadResource(name, ext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(String fileName) throws FileNotFoundException, IOException {
        Properties result = new Properties();
        InputStream in = null;
        try {
            in = FileUtilities.getResourceAsStream(fileName);
            if (in == null) {
                throw new FileNotFoundException(fileName);
            }
            result.load(in);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    public static Properties loadProperties(File file) throws IOException {
        Properties properties = new Properties();
        try (FileInputStream input = new FileInputStream(file);
             InputStreamReader reader = new InputStreamReader((InputStream)input, Charset.forName("UTF-8"));){
            properties.load(reader);
        }
        return properties;
    }

    public static String getExtension(String filename) {
        return FileUtilities.getExtension(new File(filename));
    }

    public static String getExtension(File file) {
        String s = file.getName();
        int i = s.lastIndexOf(46);
        if (i > -1 && i < s.length() - 1) {
            return s.substring(i + 1);
        }
        return "";
    }

    public static String normalizePath(String path) {
        return new File(path).getAbsolutePath().replace('\\', '/');
    }

    public static URL getUrlFromString(String path) throws MMLicenseException {
        try {
            return new File(path).toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new MMLicenseException(5200);
        }
    }
}

