/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.utils;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class ISO3166 {
    public static final ISO3166 AFGHANISTAN = new ISO3166("004", "AF", "AFG", "AFGHANISTAN");
    public static final ISO3166 ALAND_ISLANDS = new ISO3166("248", "AX", "ALA", "ALAND ISLANDS");
    public static final ISO3166 ALBANIA = new ISO3166("008", "AL", "ALB", "ALBANIA");
    public static final ISO3166 ALGERIA = new ISO3166("012", "DZ", "DZA", "ALGERIA");
    public static final ISO3166 AMERICAN_SAMOA = new ISO3166("016", "AS", "ASM", "AMERICAN SAMOA");
    public static final ISO3166 ANDORRA = new ISO3166("020", "AD", "AND", "ANDORRA");
    public static final ISO3166 ANGOLA = new ISO3166("024", "AO", "AGO", "ANGOLA");
    public static final ISO3166 ANGUILLA = new ISO3166("660", "AI", "AIA", "ANGUILLA");
    public static final ISO3166 ANTARCTICA = new ISO3166("010", "AQ", "ATA", "ANTARCTICA");
    public static final ISO3166 ANTIGUA_AND_BARBUDA = new ISO3166("028", "AG", "ATG", "ANTIGUA AND BARBUDA");
    public static final ISO3166 ARGENTINA = new ISO3166("032", "AR", "ARG", "ARGENTINA");
    public static final ISO3166 ARMENIA = new ISO3166("051", "AM", "ARM", "ARMENIA");
    public static final ISO3166 ARUBA = new ISO3166("533", "AW", "ABW", "ARUBA");
    public static final ISO3166 AUSTRALIA = new ISO3166("036", "AU", "AUS", "AUSTRALIA");
    public static final ISO3166 AUSTRIA = new ISO3166("040", "AT", "AUT", "AUSTRIA");
    public static final ISO3166 AZERBAIJAN = new ISO3166("031", "AZ", "AZE", "AZERBAIJAN");
    public static final ISO3166 BAHAMAS = new ISO3166("044", "BS", "BHS", "BAHAMAS");
    public static final ISO3166 BAHRAIN = new ISO3166("048", "BH", "BHR", "BAHRAIN");
    public static final ISO3166 BANGLADESH = new ISO3166("050", "BD", "BGD", "BANGLADESH");
    public static final ISO3166 BARBADOS = new ISO3166("052", "BB", "BRB", "BARBADOS");
    public static final ISO3166 BELARUS = new ISO3166("112", "BY", "BLR", "BELARUS");
    public static final ISO3166 BELGIUM = new ISO3166("056", "BE", "BEL", "BELGIUM");
    public static final ISO3166 BELIZE = new ISO3166("084", "BZ", "BLZ", "BELIZE");
    public static final ISO3166 BENIN = new ISO3166("204", "BJ", "BEN", "BENIN");
    public static final ISO3166 BERMUDA = new ISO3166("060", "BM", "BMU", "BERMUDA");
    public static final ISO3166 BHUTAN = new ISO3166("064", "BT", "BTN", "BHUTAN");
    public static final ISO3166 BOLIVIA = new ISO3166("068", "BO", "BOL", "BOLIVIA");
    public static final ISO3166 BONAIR = new ISO3166("535", "BQ", "BES", "BONAIRE, SINT EUSTATIUS AND SABA");
    public static final ISO3166 BOSNIA_AND_HERZEGOWINA = new ISO3166("070", "BA", "BIH", "BOSNIA AND HERZEGOWINA");
    public static final ISO3166 BOTSWANA = new ISO3166("072", "BW", "BWA", "BOTSWANA");
    public static final ISO3166 BOUVET_ISLAND = new ISO3166("074", "BV", "BVT", "BOUVET ISLAND");
    public static final ISO3166 BRAZIL = new ISO3166("076", "BR", "BRA", "BRAZIL");
    public static final ISO3166 BRITISH_INDIAN_OCEAN_TERRITORY = new ISO3166("086", "IO", "IOT", "BRITISH INDIAN OCEAN TERRITORY");
    public static final ISO3166 BRUNEI_DARUSSALAM = new ISO3166("096", "BN", "BRN", "BRUNEI DARUSSALAM");
    public static final ISO3166 BULGARIA = new ISO3166("100", "BG", "BGR", "BULGARIA");
    public static final ISO3166 BURKINA_FASO = new ISO3166("854", "BF", "BFA", "BURKINA FASO");
    public static final ISO3166 BURUNDI = new ISO3166("108", "BI", "BDI", "BURUNDI");
    public static final ISO3166 CAMBODIA = new ISO3166("116", "KH", "KHM", "CAMBODIA");
    public static final ISO3166 CAMEROON = new ISO3166("120", "CM", "CMR", "CAMEROON");
    public static final ISO3166 CANADA = new ISO3166("124", "CA", "CAN", "CANADA");
    public static final ISO3166 CAPE_VERDE = new ISO3166("132", "CV", "CPV", "CAPE VERDE");
    public static final ISO3166 CAYMAN_ISLANDS = new ISO3166("136", "KY", "CYM", "CAYMAN ISLANDS");
    public static final ISO3166 CENTRAL_AFRICAN_REPUBLIC = new ISO3166("140", "CF", "CAF", "CENTRAL AFRICAN REPUBLIC");
    public static final ISO3166 CHAD = new ISO3166("148", "TD", "TCD", "CHAD");
    public static final ISO3166 CHILE = new ISO3166("152", "CL", "CHL", "CHILE");
    public static final ISO3166 CHINA = new ISO3166("156", "CN", "CHN", "CHINA");
    public static final ISO3166 CHRISTMAS_ISLAND = new ISO3166("162", "CX", "CXR", "CHRISTMAS ISLAND");
    public static final ISO3166 COCOS_ISLANDS = new ISO3166("166", "CC", "CCK", "COCOS (KEELING) ISLANDS");
    public static final ISO3166 COLOMBIA = new ISO3166("170", "CO", "COL", "COLOMBIA");
    public static final ISO3166 COMOROS = new ISO3166("174", "KM", "COM", "COMOROS");
    public static final ISO3166 CONGO = new ISO3166("178", "CG", "COG", "CONGO");
    public static final ISO3166 CONGO_DEMOCRATIC_REPUBLIC = new ISO3166("180", "CD", "COD", "CONGO, DEMOCRATIC REPUBLIC OF THE");
    public static final ISO3166 COOK_ISLANDS = new ISO3166("184", "CK", "COK", "COOK ISLANDS");
    public static final ISO3166 COSTA_RICA = new ISO3166("188", "CR", "CRI", "COSTA RICA");
    public static final ISO3166 COTE_DIVOIRE = new ISO3166("384", "CI", "CIV", "COTE D'IVOIRE");
    public static final ISO3166 CURACAO = new ISO3166("531", "CW", "CUW", "CURA\u00c7AO");
    public static final ISO3166 CROATIA = new ISO3166("191", "HR", "HRV", "CROATIA (local name: Hrvatska)");
    public static final ISO3166 CUBA = new ISO3166("192", "CU", "CUB", "CUBA");
    public static final ISO3166 CYPRUS = new ISO3166("196", "CY", "CYP", "CYPRUS");
    public static final ISO3166 CZECH_REPUBLIC = new ISO3166("203", "CZ", "CZE", "CZECH REPUBLIC");
    public static final ISO3166 DENMARK = new ISO3166("208", "DK", "DNK", "DENMARK");
    public static final ISO3166 DJIBOUTI = new ISO3166("262", "DJ", "DJI", "DJIBOUTI");
    public static final ISO3166 DOMINICA = new ISO3166("212", "DM", "DMA", "DOMINICA");
    public static final ISO3166 DOMINICAN_REPUBLIC = new ISO3166("214", "DO", "DOM", "DOMINICAN REPUBLIC");
    public static final ISO3166 EAST_TIMOR = new ISO3166("626", "TL", "TLS", "EAST TIMOR");
    public static final ISO3166 ECUADOR = new ISO3166("218", "EC", "ECU", "ECUADOR");
    public static final ISO3166 EGYPT = new ISO3166("818", "EG", "EGY", "EGYPT");
    public static final ISO3166 EL_SALVADOR = new ISO3166("222", "SV", "SLV", "EL SALVADOR");
    public static final ISO3166 EQUATORIAL_GUINEA = new ISO3166("226", "GQ", "GNQ", "EQUATORIAL GUINEA");
    public static final ISO3166 ERITREA = new ISO3166("232", "ER", "ERI", "ERITREA");
    public static final ISO3166 ESTONIA = new ISO3166("233", "EE", "EST", "ESTONIA");
    public static final ISO3166 ETHIOPIA = new ISO3166("231", "ET", "ETH", "ETHIOPIA");
    public static final ISO3166 FALKLAND_ISLANDS = new ISO3166("238", "FK", "FLK", "FALKLAND ISLANDS (MALVINAS)");
    public static final ISO3166 FAROE_ISLANDS = new ISO3166("234", "FO", "FRO", "FAROE ISLANDS");
    public static final ISO3166 FIJI = new ISO3166("242", "FJ", "FJI", "FIJI");
    public static final ISO3166 FINLAND = new ISO3166("246", "FI", "FIN", "FINLAND");
    public static final ISO3166 FRANCE = new ISO3166("250", "FR", "FRA", "FRANCE");
    public static final ISO3166 FRANCE_METROPOLITAN = new ISO3166("249", "FX", "FXX", "FRANCE, METROPOLITAN");
    public static final ISO3166 FRENCH_GUIANA = new ISO3166("254", "GF", "GUF", "FRENCH GUIANA");
    public static final ISO3166 FRENCH_POLYNESIA = new ISO3166("258", "PF", "PYF", "FRENCH POLYNESIA");
    public static final ISO3166 FRENCH_SOUTHERN_TERRITORIES = new ISO3166("260", "TF", "ATF", "FRENCH SOUTHERN TERRITORIES");
    public static final ISO3166 GABON = new ISO3166("266", "GA", "GAB", "GABON");
    public static final ISO3166 GAMBIA = new ISO3166("270", "GM", "GMB", "GAMBIA");
    public static final ISO3166 GEORGIA = new ISO3166("268", "GE", "GEO", "GEORGIA");
    public static final ISO3166 GERMANY = new ISO3166("276", "DE", "DEU", "GERMANY");
    public static final ISO3166 GHANA = new ISO3166("288", "GH", "GHA", "GHANA");
    public static final ISO3166 GIBRALTAR = new ISO3166("292", "GI", "GIB", "GIBRALTAR");
    public static final ISO3166 GREECE = new ISO3166("300", "GR", "GRC", "GREECE");
    public static final ISO3166 GREENLAND = new ISO3166("304", "GL", "GRL", "GREENLAND");
    public static final ISO3166 GRENADA = new ISO3166("308", "GD", "GRD", "GRENADA");
    public static final ISO3166 GUADELOUPE = new ISO3166("312", "GP", "GLP", "GUADELOUPE");
    public static final ISO3166 GUAM = new ISO3166("316", "GU", "GUM", "GUAM");
    public static final ISO3166 GUATEMALA = new ISO3166("320", "GT", "GTM", "GUATEMALA");
    public static final ISO3166 GUERNSEY = new ISO3166("831", "GG", "GGY", "GUERNSEY");
    public static final ISO3166 GUINEA = new ISO3166("324", "GN", "GIN", "GUINEA");
    public static final ISO3166 GUINEA_BISSAU = new ISO3166("624", "GW", "GNB", "GUINEA-BISSAU");
    public static final ISO3166 GUYANA = new ISO3166("328", "GY", "GUY", "GUYANA");
    public static final ISO3166 HAITI = new ISO3166("332", "HT", "HTI", "HAITI");
    public static final ISO3166 HEARD_AND_MCDONALD_ISLANDS = new ISO3166("334", "HM", "HMD", "HEARD AND MCDONALD ISLANDS");
    public static final ISO3166 HONDURAS = new ISO3166("340", "HN", "HND", "HONDURAS");
    public static final ISO3166 HONG_KONG = new ISO3166("344", "HK", "HKG", "HONG KONG");
    public static final ISO3166 HUNGARY = new ISO3166("348", "HU", "HUN", "HUNGARY");
    public static final ISO3166 ICELAND = new ISO3166("352", "IS", "ISL", "ICELAND");
    public static final ISO3166 INDIA = new ISO3166("356", "IN", "IND", "INDIA");
    public static final ISO3166 INDONESIA = new ISO3166("360", "ID", "IDN", "INDONESIA");
    public static final ISO3166 IRAN = new ISO3166("364", "IR", "IRN", "IRAN (ISLAMIC REPUBLIC OF)");
    public static final ISO3166 IRAQ = new ISO3166("368", "IQ", "IRQ", "IRAQ");
    public static final ISO3166 IRELAND = new ISO3166("372", "IE", "IRL", "IRELAND");
    public static final ISO3166 ISLE_OF_MAN = new ISO3166("833", "IM", "IMN", "ISLE OF MAN");
    public static final ISO3166 ISRAEL = new ISO3166("376", "IL", "ISR", "ISRAEL");
    public static final ISO3166 ITALY = new ISO3166("380", "IT", "ITA", "ITALY");
    public static final ISO3166 JAMAICA = new ISO3166("388", "JM", "JAM", "JAMAICA");
    public static final ISO3166 JAPAN = new ISO3166("392", "JP", "JPN", "JAPAN");
    public static final ISO3166 JERSEY = new ISO3166("832", "JE", "JEY", "JERSEY");
    public static final ISO3166 JORDAN = new ISO3166("400", "JO", "JOR", "JORDAN");
    public static final ISO3166 KAZAKHSTAN = new ISO3166("398", "KZ", "KAZ", "KAZAKHSTAN");
    public static final ISO3166 KENYA = new ISO3166("404", "KE", "KEN", "KENYA");
    public static final ISO3166 KOSOVO = new ISO3166("999", "XK", "XKX", "KOSOVO");
    public static final ISO3166 KIRIBATI = new ISO3166("296", "KI", "KIR", "KIRIBATI");
    public static final ISO3166 DEMOCRATIC_PEOPLES_REPUBLIC_OF_KOREA = new ISO3166("408", "KP", "PRK", "KOREA, DEMOCRATIC PEOPLE'S REPUBLIC OF");
    public static final ISO3166 REPUBLIC_OF_KOREA = new ISO3166("410", "KR", "KOR", "KOREA, REPUBLIC OF");
    public static final ISO3166 KUWAIT = new ISO3166("414", "KW", "KWT", "KUWAIT");
    public static final ISO3166 KYRGYZSTAN = new ISO3166("417", "KG", "KGZ", "KYRGYZSTAN");
    public static final ISO3166 LAO_PEOPLES_DEMOCRATIC_REPUBLIC = new ISO3166("418", "LA", "LAO", "LAO PEOPLE'S DEMOCRATIC REPUBLIC");
    public static final ISO3166 LATVIA = new ISO3166("428", "LV", "LVA", "LATVIA");
    public static final ISO3166 LEBANON = new ISO3166("422", "LB", "LBN", "LEBANON");
    public static final ISO3166 LESOTHO = new ISO3166("426", "LS", "LSO", "LESOTHO");
    public static final ISO3166 LIBERIA = new ISO3166("430", "LR", "LBR", "LIBERIA");
    public static final ISO3166 LIBYAN_ARAB_JAMAHIRIYA = new ISO3166("434", "LY", "LBY", "LIBYAN ARAB JAMAHIRIYA");
    public static final ISO3166 LIECHTENSTEIN = new ISO3166("438", "LI", "LIE", "LIECHTENSTEIN");
    public static final ISO3166 LITHUANIA = new ISO3166("440", "LT", "LTU", "LITHUANIA");
    public static final ISO3166 LUXEMBOURG = new ISO3166("442", "LU", "LUX", "LUXEMBOURG");
    public static final ISO3166 MACAU = new ISO3166("446", "MO", "MAC", "MACAU");
    public static final ISO3166 MACAO = new ISO3166("446", "MO", "MAC", "MACAO");
    public static final ISO3166 MACEDONIA = new ISO3166("807", "MK", "MKD", "MACEDONIA, THE FORMER YUGOSLAV REPUBLIC OF");
    public static final ISO3166 MADAGASCAR = new ISO3166("450", "MG", "MDG", "MADAGASCAR");
    public static final ISO3166 MALAWI = new ISO3166("454", "MW", "MWI", "MALAWI");
    public static final ISO3166 MALAYSIA = new ISO3166("458", "MY", "MYS", "MALAYSIA");
    public static final ISO3166 MALDIVES = new ISO3166("462", "MV", "MDV", "MALDIVES");
    public static final ISO3166 MALI = new ISO3166("466", "ML", "MLI", "MALI");
    public static final ISO3166 MALTA = new ISO3166("470", "MT", "MLT", "MALTA");
    public static final ISO3166 MARSHALL_ISLANDS = new ISO3166("584", "MH", "MHL", "MARSHALL ISLANDS");
    public static final ISO3166 MARTINIQUE = new ISO3166("474", "MQ", "MTQ", "MARTINIQUE");
    public static final ISO3166 MAURITANIA = new ISO3166("478", "MR", "MRT", "MAURITANIA");
    public static final ISO3166 MAURITIUS = new ISO3166("480", "MU", "MUS", "MAURITIUS");
    public static final ISO3166 MAYOTTE = new ISO3166("175", "YT", "MYT", "MAYOTTE");
    public static final ISO3166 MEXICO = new ISO3166("484", "MX", "MEX", "MEXICO");
    public static final ISO3166 MICRONESIA = new ISO3166("583", "FM", "FSM", "MICRONESIA, FEDERATED STATES OF");
    public static final ISO3166 MOLDOVA = new ISO3166("498", "MD", "MDA", "MOLDOVA, REPUBLIC OF");
    public static final ISO3166 MONACO = new ISO3166("492", "MC", "MCO", "MONACO");
    public static final ISO3166 MONGOLIA = new ISO3166("496", "MN", "MNG", "MONGOLIA");
    public static final ISO3166 MONTENEGRO = new ISO3166("499", "ME", "MNE", "MONTENEGRO");
    public static final ISO3166 MONTSERRAT = new ISO3166("500", "MS", "MSR", "MONTSERRAT");
    public static final ISO3166 MOROCCO = new ISO3166("504", "MA", "MAR", "MOROCCO");
    public static final ISO3166 MOZAMBIQUE = new ISO3166("508", "MZ", "MOZ", "MOZAMBIQUE");
    public static final ISO3166 MYANMAR = new ISO3166("104", "MM", "MMR", "MYANMAR");
    public static final ISO3166 NAMIBIA = new ISO3166("516", "NA", "NAM", "NAMIBIA");
    public static final ISO3166 NAURU = new ISO3166("520", "NR", "NRU", "NAURU");
    public static final ISO3166 NEPAL = new ISO3166("524", "NP", "NPL", "NEPAL");
    public static final ISO3166 NETHERLANDS = new ISO3166("528", "NL", "NLD", "NETHERLANDS");
    public static final ISO3166 NETHERLANDS_ANTILLES = new ISO3166("530", "AN", "ANT", "NETHERLANDS ANTILLES");
    public static final ISO3166 NEW_CALEDONIA = new ISO3166("540", "NC", "NCL", "NEW CALEDONIA");
    public static final ISO3166 NEW_ZEALAND = new ISO3166("554", "NZ", "NZL", "NEW ZEALAND");
    public static final ISO3166 NICARAGUA = new ISO3166("558", "NI", "NIC", "NICARAGUA");
    public static final ISO3166 NIGER = new ISO3166("562", "NE", "NER", "NIGER");
    public static final ISO3166 NIGERIA = new ISO3166("566", "NG", "NGA", "NIGERIA");
    public static final ISO3166 NIUE = new ISO3166("570", "NU", "NIU", "NIUE");
    public static final ISO3166 NORFOLK_ISLAND = new ISO3166("574", "NF", "NFK", "NORFOLK ISLAND");
    public static final ISO3166 NORTHERN_MARIANA_ISLANDS = new ISO3166("580", "MP", "MNP", "NORTHERN MARIANA ISLANDS");
    public static final ISO3166 NORWAY = new ISO3166("578", "NO", "NOR", "NORWAY");
    public static final ISO3166 OMAN = new ISO3166("512", "OM", "OMN", "OMAN");
    public static final ISO3166 PAKISTAN = new ISO3166("586", "PK", "PAK", "PAKISTAN");
    public static final ISO3166 PALAU = new ISO3166("585", "PW", "PLW", "PALAU");
    public static final ISO3166 PALESTINIAN = new ISO3166("275", "PS", "PSE", "PALESTINIAN TERRITORY, OCCUPIED");
    public static final ISO3166 PANAMA = new ISO3166("591", "PA", "PAN", "PANAMA");
    public static final ISO3166 PAPUA_NEW_GUINEA = new ISO3166("598", "PG", "PNG", "PAPUA NEW GUINEA");
    public static final ISO3166 PARAGUAY = new ISO3166("600", "PY", "PRY", "PARAGUAY");
    public static final ISO3166 PERU = new ISO3166("604", "PE", "PER", "PERU");
    public static final ISO3166 PHILIPPINES = new ISO3166("608", "PH", "PHL", "PHILIPPINES");
    public static final ISO3166 PITCAIRN = new ISO3166("612", "PN", "PCN", "PITCAIRN");
    public static final ISO3166 POLAND = new ISO3166("616", "PL", "POL", "POLAND");
    public static final ISO3166 PORTUGAL = new ISO3166("620", "PT", "PRT", "PORTUGAL");
    public static final ISO3166 PUERTO_RICO = new ISO3166("630", "PR", "PRI", "PUERTO RICO");
    public static final ISO3166 QATAR = new ISO3166("634", "QA", "QAT", "QATAR");
    public static final ISO3166 REUNION = new ISO3166("638", "RE", "REU", "REUNION");
    public static final ISO3166 ROMANIA = new ISO3166("642", "RO", "ROU", "ROMANIA");
    public static final ISO3166 RUSSIA = new ISO3166("643", "RU", "RUS", "RUSSIAN FEDERATION");
    public static final ISO3166 RWANDA = new ISO3166("646", "RW", "RWA", "RWANDA");
    public static final ISO3166 SAINT_BARTHELEMY = new ISO3166("652", "BL", "BLM", "SAINT BARTH\u00c9LEMY");
    public static final ISO3166 SAINT_HELENA = new ISO3166("654", "SH", "SHN", "SAINT HELENA, ASCENSION AND TRISTAN DA CUNHA");
    public static final ISO3166 SAINT_KITTS_AND_NEVIS = new ISO3166("659", "KN", "KNA", "SAINT KITTS AND NEVIS");
    public static final ISO3166 SAINT_LUCIA = new ISO3166("662", "LC", "LCA", "SAINT LUCIA");
    public static final ISO3166 SAINT_MARTIN = new ISO3166("663", "MF", "MAF", "SAINT MARTIN (FRENCH PART");
    public static final ISO3166 SAINT_PIERRE_AND_MIQUELON = new ISO3166("666", "PM", "SPM", "SAINT PIERRE AND MIQUELON");
    public static final ISO3166 SAINT_VINCENT_AND_THE_GRENADINES = new ISO3166("670", "VC", "VCT", "SAINT VINCENT AND THE GRENADINES");
    public static final ISO3166 SAMOA = new ISO3166("882", "WS", "WSM", "SAMOA");
    public static final ISO3166 SAN_MARINO = new ISO3166("674", "SM", "SMR", "SAN MARINO");
    public static final ISO3166 SAO_TOME_AND_PRINCIPE = new ISO3166("678", "ST", "STP", "SAO TOME AND PRINCIPE");
    public static final ISO3166 SAUDI_ARABIA = new ISO3166("682", "SA", "SAU", "SAUDI ARABIA");
    public static final ISO3166 SENEGAL = new ISO3166("686", "SN", "SEN", "SENEGAL");
    public static final ISO3166 SERBIA_AND_MONTENEGRO = new ISO3166("891", "CS", "SCG", "SERBIA AND MONTENEGRO");
    public static final ISO3166 SERBIA = new ISO3166("688", "RS", "SRB", "SERBIA");
    public static final ISO3166 SEYCHELLES = new ISO3166("690", "SC", "SYC", "SEYCHELLES");
    public static final ISO3166 SIERRA_LEONE = new ISO3166("694", "SL", "SLE", "SIERRA LEONE");
    public static final ISO3166 SINGAPORE = new ISO3166("702", "SG", "SGP", "SINGAPORE");
    public static final ISO3166 SINT_MAARTEN = new ISO3166("534", "SX", "SXM", "SINT MAARTEN (DUTCH PART)");
    public static final ISO3166 SLOVAKIA = new ISO3166("703", "SK", "SVK", "SLOVAKIA (Slovak Republic)");
    public static final ISO3166 SLOVENIA = new ISO3166("705", "SI", "SVN", "SLOVENIA");
    public static final ISO3166 SOLOMON_ISLANDS = new ISO3166("090", "SB", "SLB", "SOLOMON ISLANDS");
    public static final ISO3166 SOMALIA = new ISO3166("706", "SO", "SOM", "SOMALIA");
    public static final ISO3166 SOUTH_AFRICA = new ISO3166("710", "ZA", "ZAF", "SOUTH AFRICA");
    public static final ISO3166 SOUTH_GEORGIA_AND_THE_SOUTH_SANDWICH_ISLANDS = new ISO3166("239", "GS", "SGS", "SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS");
    public static final ISO3166 SOUTH_SUDAN = new ISO3166("728", "SS", "SSD", "SOUTH SUDAN");
    public static final ISO3166 SPAIN = new ISO3166("724", "ES", "ESP", "SPAIN");
    public static final ISO3166 SRI_LANKA = new ISO3166("144", "LK", "LKA", "SRI LANKA");
    public static final ISO3166 ST_HELENA = new ISO3166("654", "SH", "SHN", "ST. HELENA");
    public static final ISO3166 ST_PIERRE_AND_MIQUELON = new ISO3166("666", "PM", "SPM", "ST. PIERRE AND MIQUELON");
    public static final ISO3166 SUDAN = new ISO3166("736", "SD", "SDN", "SUDAN");
    public static final ISO3166 SURINAME = new ISO3166("740", "SR", "SUR", "SURINAME");
    public static final ISO3166 SVALBARD_AND_JAN_MAYEN_ISLANDS = new ISO3166("744", "SJ", "SJM", "SVALBARD AND JAN MAYEN ISLANDS");
    public static final ISO3166 SWAZILAND = new ISO3166("748", "SZ", "SWZ", "SWAZILAND");
    public static final ISO3166 SWEDEN = new ISO3166("752", "SE", "SWE", "SWEDEN");
    public static final ISO3166 SWITZERLAND = new ISO3166("756", "CH", "CHE", "SWITZERLAND");
    public static final ISO3166 SYRIAN_ARAB_REPUBLIC = new ISO3166("760", "SY", "SYR", "SYRIAN ARAB REPUBLIC");
    public static final ISO3166 TAIWAN = new ISO3166("158", "TW", "TWN", "TAIWAN, PROVINCE OF CHINA");
    public static final ISO3166 TAJIKISTAN = new ISO3166("762", "TJ", "TJK", "TAJIKISTAN");
    public static final ISO3166 TANZANIA = new ISO3166("834", "TZ", "TZA", "TANZANIA, UNITED REPUBLIC OF");
    public static final ISO3166 THAILAND = new ISO3166("764", "TH", "THA", "THAILAND");
    public static final ISO3166 TIMOR_LESTE = new ISO3166("626", "TL", "TLS", "TIMOR-LESTE");
    public static final ISO3166 TOGO = new ISO3166("768", "TG", "TGO", "TOGO");
    public static final ISO3166 TOKELAU = new ISO3166("772", "TK", "TKL", "TOKELAU");
    public static final ISO3166 TONGA = new ISO3166("776", "TO", "TON", "TONGA");
    public static final ISO3166 TRINIDAD_AND_TOBAGO = new ISO3166("780", "TT", "TTO", "TRINIDAD AND TOBAGO");
    public static final ISO3166 TUNISIA = new ISO3166("788", "TN", "TUN", "TUNISIA");
    public static final ISO3166 TURKEY = new ISO3166("792", "TR", "TUR", "TURKEY");
    public static final ISO3166 TURKMENISTAN = new ISO3166("795", "TM", "TKM", "TURKMENISTAN");
    public static final ISO3166 TURKS_AND_CAICOS_ISLANDS = new ISO3166("796", "TC", "TCA", "TURKS AND CAICOS ISLANDS");
    public static final ISO3166 TUVALU = new ISO3166("798", "TV", "TUV", "TUVALU");
    public static final ISO3166 UGANDA = new ISO3166("800", "UG", "UGA", "UGANDA");
    public static final ISO3166 UKRAINE = new ISO3166("804", "UA", "UKR", "UKRAINE");
    public static final ISO3166 UNITED_ARAB_EMIRATES = new ISO3166("784", "AE", "ARE", "UNITED ARAB EMIRATES");
    public static final ISO3166 UNITED_KINGDOM = new ISO3166("826", "GB", "GBR", "UNITED KINGDOM");
    public static final ISO3166 UNITED_STATES = new ISO3166("840", "US", "USA", "UNITED STATES");
    public static final ISO3166 UNITED_STATES_MINOR_OUTLYING_ISLANDS = new ISO3166("581", "UM", "UMI", "UNITED STATES MINOR OUTLYING ISLANDS");
    public static final ISO3166 URUGUAY = new ISO3166("858", "UY", "URY", "URUGUAY");
    public static final ISO3166 UZBEKISTAN = new ISO3166("860", "UZ", "UZB", "UZBEKISTAN");
    public static final ISO3166 VANUATU = new ISO3166("548", "VU", "VUT", "VANUATU");
    public static final ISO3166 VATICAN_CITY = new ISO3166("336", "VA", "VAT", "VATICAN CITY STATE (HOLY SEE)");
    public static final ISO3166 VENEZUELA = new ISO3166("862", "VE", "VEN", "VENEZUELA");
    public static final ISO3166 VIET_NAM = new ISO3166("704", "VN", "VNM", "VIET NAM");
    public static final ISO3166 VIRGIN_ISLANDS_BRITISH = new ISO3166("092", "VG", "VGB", "VIRGIN ISLANDS (BRITISH)");
    public static final ISO3166 VIRGIN_ISLANDS_US = new ISO3166("850", "VI", "VIR", "VIRGIN ISLANDS (U.S.)");
    public static final ISO3166 WALLIS_AND_FUTUNA_ISLANDS = new ISO3166("876", "WF", "WLF", "WALLIS AND FUTUNA ISLANDS");
    public static final ISO3166 WESTERN_SAHARA = new ISO3166("732", "EH", "ESH", "WESTERN SAHARA");
    public static final ISO3166 YEMEN = new ISO3166("887", "YE", "YEM", "YEMEN");
    public static final ISO3166 YUGOSLAVIA = new ISO3166("891", "YU", "YUG", "YUGOSLAVIA");
    public static final ISO3166 ZAMBIA = new ISO3166("894", "ZM", "ZMB", "ZAMBIA");
    public static final ISO3166 ZIMBABWE = new ISO3166("716", "ZW", "ZWE", "ZIMBABWE");
    private static final ISO3166[] CONSTANT_LIST = ISO3166.buildConstantList();
    private static final Map m_countryToLanguageMap = ISO3166.buildCountryToLanguageMap();
    private static final Map m_countriesByName = new HashMap(CONSTANT_LIST.length);
    private static final Map m_countriesBy2 = new HashMap(CONSTANT_LIST.length);
    private static final Map m_countriesBy3 = new HashMap(CONSTANT_LIST.length);
    private static final Map m_countriesByNumber = new HashMap(CONSTANT_LIST.length);
    private static final ISO3166 m_defaultCountry;
    private final String m_number;
    private final String m_a2;
    private final String m_a3;
    private final String m_name;

    public ISO3166(String number, String a2, String a3) {
        this(number, a2, a3, "");
    }

    public ISO3166(String number, String a2, String a3, String name) {
        if (a2.length() != 2 || a3.length() != 3) {
            throw new IllegalArgumentException();
        }
        this.m_number = number;
        this.m_a2 = a2.toUpperCase();
        this.m_a3 = a3.toUpperCase();
        this.m_name = name.toUpperCase();
    }

    public String getCountryNumber() {
        return this.m_number;
    }

    public String getISO2Country() {
        return this.m_a2;
    }

    public String getISO3Country() {
        return this.m_a3;
    }

    public String getDisplayCountry() {
        return this.getDisplayCountry(null);
    }

    public String getDisplayCountry(Locale inLocale) {
        if (inLocale == null) {
            return this.m_name;
        }
        String[] languages = ISO3166.getLanguagesForCountry(this);
        Locale loc = languages.length == 0 ? Locale.getDefault() : new Locale(languages[0], this.m_a2);
        String name = loc.getDisplayCountry(inLocale);
        if (name == null) {
            return this.m_name;
        }
        return name;
    }

    public static String[] getLanguagesForCountry(ISO3166 country) {
        String[] result = (String[])m_countryToLanguageMap.get(country.m_a2);
        if (result == null) {
            result = new String[]{};
        }
        return result;
    }

    public static ISO3166[] getISOCountries() {
        return CONSTANT_LIST;
    }

    public static ISO3166 findCountryByName(String countryName) {
        if (countryName == null) {
            return null;
        }
        return (ISO3166)m_countriesByName.get(countryName.toUpperCase());
    }

    public static ISO3166 findCountryByISO2(String iso2Abbrev) {
        if (iso2Abbrev == null) {
            return null;
        }
        return (ISO3166)m_countriesBy2.get(iso2Abbrev.toUpperCase());
    }

    public static ISO3166 findCountryByISO3(String iso3Abbrev) {
        if (iso3Abbrev == null) {
            return null;
        }
        return (ISO3166)m_countriesBy3.get(iso3Abbrev.toUpperCase());
    }

    public static ISO3166 findCountryByNumber(String isoNumCode) {
        return (ISO3166)m_countriesByNumber.get(isoNumCode);
    }

    public static ISO3166 getDefault() {
        return m_defaultCountry;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ISO3166)) {
            return false;
        }
        ISO3166 other = (ISO3166)obj;
        return this.m_number.equals(other.m_number) && this.m_a2.equals(other.m_a2) && this.m_a3.equals(other.m_a3) && this.m_name.equals(other.m_name);
    }

    public int hashCode() {
        int result = 17;
        result = result * 37 + this.m_number.hashCode();
        result = result * 37 + this.m_a2.hashCode();
        result = result * 37 + this.m_a3.hashCode();
        result = result * 37 + this.m_name.hashCode();
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(25);
        sb.append("[");
        sb.append(this.m_number);
        sb.append(", ");
        sb.append(this.m_a2);
        sb.append(", ");
        sb.append(this.m_a3);
        sb.append(", ");
        sb.append(this.m_name);
        sb.append("]");
        return sb.toString();
    }

    private static final ISO3166[] buildConstantList() {
        return new ISO3166[]{ALAND_ISLANDS, AFGHANISTAN, ALBANIA, ALGERIA, AMERICAN_SAMOA, ANDORRA, ANGOLA, ANGUILLA, ANTARCTICA, ANTIGUA_AND_BARBUDA, ARGENTINA, ARMENIA, ARUBA, AUSTRALIA, AUSTRIA, AZERBAIJAN, BAHAMAS, BAHRAIN, BANGLADESH, BARBADOS, BELARUS, BELGIUM, BELIZE, BENIN, BERMUDA, BHUTAN, BOLIVIA, BOSNIA_AND_HERZEGOWINA, BONAIR, BOTSWANA, BOUVET_ISLAND, BRAZIL, BRITISH_INDIAN_OCEAN_TERRITORY, BRUNEI_DARUSSALAM, BULGARIA, BURKINA_FASO, BURUNDI, CAMBODIA, CAMEROON, CANADA, CAPE_VERDE, CAYMAN_ISLANDS, CENTRAL_AFRICAN_REPUBLIC, CHAD, CHILE, CHINA, CHRISTMAS_ISLAND, COCOS_ISLANDS, COLOMBIA, COMOROS, CONGO, CONGO_DEMOCRATIC_REPUBLIC, COOK_ISLANDS, COSTA_RICA, COTE_DIVOIRE, CURACAO, CROATIA, CUBA, CYPRUS, CZECH_REPUBLIC, DENMARK, DJIBOUTI, DOMINICA, DOMINICAN_REPUBLIC, ECUADOR, EGYPT, EL_SALVADOR, EQUATORIAL_GUINEA, ERITREA, ESTONIA, ETHIOPIA, FALKLAND_ISLANDS, FAROE_ISLANDS, FIJI, FINLAND, FRANCE, FRENCH_GUIANA, FRENCH_POLYNESIA, FRENCH_SOUTHERN_TERRITORIES, GABON, GAMBIA, GEORGIA, GERMANY, GHANA, GIBRALTAR, GREECE, GREENLAND, GRENADA, GUADELOUPE, GUAM, GUATEMALA, GUERNSEY, GUINEA, GUINEA_BISSAU, GUYANA, HAITI, HEARD_AND_MCDONALD_ISLANDS, HONDURAS, HONG_KONG, HUNGARY, ICELAND, INDIA, INDONESIA, IRAN, IRAQ, IRELAND, ISLE_OF_MAN, ISRAEL, ITALY, JAMAICA, JAPAN, JERSEY, JORDAN, KAZAKHSTAN, KENYA, KIRIBATI, DEMOCRATIC_PEOPLES_REPUBLIC_OF_KOREA, REPUBLIC_OF_KOREA, KUWAIT, KYRGYZSTAN, KOSOVO, LAO_PEOPLES_DEMOCRATIC_REPUBLIC, LATVIA, LEBANON, LESOTHO, LIBERIA, LIBYAN_ARAB_JAMAHIRIYA, LIECHTENSTEIN, LITHUANIA, LUXEMBOURG, MACAO, MACEDONIA, MADAGASCAR, MALAWI, MALAYSIA, MALDIVES, MALI, MALTA, MARSHALL_ISLANDS, MARTINIQUE, MAURITANIA, MAURITIUS, MAYOTTE, MEXICO, MICRONESIA, MOLDOVA, MONACO, MONGOLIA, MONTENEGRO, MONTSERRAT, MOROCCO, MOZAMBIQUE, MYANMAR, NAMIBIA, NAURU, NEPAL, NETHERLANDS, NETHERLANDS_ANTILLES, NEW_CALEDONIA, NEW_ZEALAND, NICARAGUA, NIGER, NIGERIA, NIUE, NORFOLK_ISLAND, NORTHERN_MARIANA_ISLANDS, NORWAY, OMAN, PAKISTAN, PALAU, PALESTINIAN, PANAMA, PAPUA_NEW_GUINEA, PARAGUAY, PERU, PHILIPPINES, PITCAIRN, POLAND, PORTUGAL, PUERTO_RICO, QATAR, REUNION, ROMANIA, RUSSIA, RWANDA, SAINT_BARTHELEMY, SAINT_HELENA, SAINT_KITTS_AND_NEVIS, SAINT_LUCIA, SAINT_MARTIN, SAINT_PIERRE_AND_MIQUELON, SAINT_VINCENT_AND_THE_GRENADINES, SAMOA, SAN_MARINO, SAO_TOME_AND_PRINCIPE, SAUDI_ARABIA, SENEGAL, SERBIA, SEYCHELLES, SIERRA_LEONE, SINGAPORE, SINT_MAARTEN, SLOVAKIA, SLOVENIA, SOLOMON_ISLANDS, SOMALIA, SOUTH_AFRICA, SOUTH_GEORGIA_AND_THE_SOUTH_SANDWICH_ISLANDS, SOUTH_SUDAN, SPAIN, SRI_LANKA, SUDAN, SURINAME, SVALBARD_AND_JAN_MAYEN_ISLANDS, SWAZILAND, SWEDEN, SWITZERLAND, SYRIAN_ARAB_REPUBLIC, TAIWAN, TAJIKISTAN, TANZANIA, THAILAND, TIMOR_LESTE, TOGO, TOKELAU, TONGA, TRINIDAD_AND_TOBAGO, TUNISIA, TURKEY, TURKMENISTAN, TURKS_AND_CAICOS_ISLANDS, TUVALU, UGANDA, UKRAINE, UNITED_ARAB_EMIRATES, UNITED_KINGDOM, UNITED_STATES, UNITED_STATES_MINOR_OUTLYING_ISLANDS, URUGUAY, UZBEKISTAN, VANUATU, VATICAN_CITY, VENEZUELA, VIET_NAM, VIRGIN_ISLANDS_BRITISH, VIRGIN_ISLANDS_US, WALLIS_AND_FUTUNA_ISLANDS, WESTERN_SAHARA, YEMEN, ZAMBIA, ZIMBABWE};
    }

    private static final Map buildCountryToLanguageMap() {
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        result.put("AD", new String[]{"fr", "es"});
        result.put("AE", new String[]{"ar", "en"});
        result.put("AF", new String[]{"ps"});
        result.put("AG", new String[]{"en"});
        result.put("AI", new String[]{"rn"});
        result.put("AL", new String[]{"sq"});
        result.put("AM", new String[]{"hy", "ru"});
        result.put("AN", new String[]{"nl", "en"});
        result.put("AO", new String[]{"pt"});
        result.put("AR", new String[]{"es"});
        result.put("AS", new String[]{"en", "sm"});
        result.put("AT", new String[]{"de"});
        result.put("AU", new String[]{"en"});
        result.put("AW", new String[]{"nl", "en"});
        result.put("AX", new String[]{"sv"});
        result.put("AZ", new String[]{"az", "hy", "ru"});
        result.put("BA", new String[]{"sr", "sh", "hr", "sl", "mk", "sq"});
        result.put("BB", new String[]{"en"});
        result.put("BD", new String[]{"bn", "hi", "bh", "en"});
        result.put("BE", new String[]{"fr", "nl", "de"});
        result.put("BF", new String[]{"fr"});
        result.put("BG", new String[]{"bg", "tr"});
        result.put("BH", new String[]{"ar", "en"});
        result.put("BI", new String[]{"rn", "fr", "sw"});
        result.put("BJ", new String[]{"fr"});
        result.put("BL", new String[]{"fr"});
        result.put("BM", new String[]{"en"});
        result.put("BN", new String[]{"ms", "en", "zh"});
        result.put("BO", new String[]{"es", "ay", "qu"});
        result.put("BR", new String[]{"pt"});
        result.put("BQ", new String[]{"nl"});
        result.put("BS", new String[]{"en"});
        result.put("BT", new String[]{"dz", "en", "ne"});
        result.put("BV", new String[]{"no"});
        result.put("BW", new String[]{"en", "tn"});
        result.put("BY", new String[]{"be", "ru"});
        result.put("BZ", new String[]{"en", "es"});
        result.put("CA", new String[]{"en", "fr"});
        result.put("CC", new String[]{"en"});
        result.put("CF", new String[]{"fr", "sg"});
        result.put("CD", new String[]{"fr"});
        result.put("CG", new String[]{"fr"});
        result.put("CH", new String[]{"fr", "de", "it", "rm"});
        result.put("CI", new String[]{"fr"});
        result.put("CK", new String[]{"mi", "en"});
        result.put("CL", new String[]{"es"});
        result.put("CM", new String[]{"en", "fr"});
        result.put("CN", new String[]{"zh", "bo"});
        result.put("CO", new String[]{"es"});
        result.put("CR", new String[]{"es"});
        result.put("CU", new String[]{"es"});
        result.put("CV", new String[]{"pt"});
        result.put("CX", new String[]{"en"});
        result.put("CY", new String[]{"el", "tr", "en"});
        result.put("CW", new String[]{"nl"});
        result.put("CZ", new String[]{"cs", "sk"});
        result.put("DE", new String[]{"de"});
        result.put("DJ", new String[]{"ar", "fr", "so"});
        result.put("DK", new String[]{"da"});
        result.put("DM", new String[]{"en", "fr"});
        result.put("DO", new String[]{"es"});
        result.put("DZ", new String[]{"ar", "fr"});
        result.put("EC", new String[]{"es", "qu"});
        result.put("EE", new String[]{"et", "ru"});
        result.put("EG", new String[]{"ar", "en", "fr"});
        result.put("EH", new String[]{"ar", "fr", "it"});
        result.put("ER", new String[]{"am", "ti", "ar", "en", "it"});
        result.put("ES", new String[]{"es", "eu", "ca", "gl"});
        result.put("ET", new String[]{"am", "ar", "en"});
        result.put("FI", new String[]{"fi", "sv"});
        result.put("FJ", new String[]{"en", "fj", "hi"});
        result.put("FK", new String[]{"en"});
        result.put("FM", new String[]{"en"});
        result.put("FO", new String[]{"fo", "da"});
        result.put("FR", new String[]{"fr", "eu", "br", "co"});
        result.put("FX", new String[]{"fr"});
        result.put("GA", new String[]{"fr"});
        result.put("GB", new String[]{"en", "gd", "cy"});
        result.put("GD", new String[]{"en", "fr"});
        result.put("GE", new String[]{"ka", "hy", "ru"});
        result.put("GF", new String[]{"fr"});
        result.put("GH", new String[]{"en"});
        result.put("GI", new String[]{"en", "es"});
        result.put("GL", new String[]{"da", "ik", "kl"});
        result.put("GM", new String[]{"en", "wo"});
        result.put("GN", new String[]{"fr"});
        result.put("GP", new String[]{"fr", "en"});
        result.put("GQ", new String[]{"es"});
        result.put("GR", new String[]{"el"});
        result.put("GT", new String[]{"es"});
        result.put("GU", new String[]{"en"});
        result.put("GW", new String[]{"pt"});
        result.put("GY", new String[]{"en", "hi", "ur"});
        result.put("HK", new String[]{"zh", "en"});
        result.put("HN", new String[]{"es"});
        result.put("HR", new String[]{"hr"});
        result.put("HT", new String[]{"fr"});
        result.put("HU", new String[]{"hu"});
        result.put("ID", new String[]{"in", "en", "nl"});
        result.put("IE", new String[]{"en", "ga"});
        result.put("IL", new String[]{"iw", "ar", "ji"});
        result.put("IN", new String[]{"hi", "en", "gu", "kn", "ks", "ml", "mr", "ne", "or", "pa", "sa", "ta", "te"});
        result.put("IO", new String[]{"en"});
        result.put("IQ", new String[]{"ar", "ku", "tk"});
        result.put("IR", new String[]{"fa", "ar", "ku"});
        result.put("IS", new String[]{"is"});
        result.put("IT", new String[]{"it", "fr", "de"});
        result.put("JM", new String[]{"en"});
        result.put("JO", new String[]{"ar"});
        result.put("JP", new String[]{"ja"});
        result.put("KE", new String[]{"en", "sw"});
        result.put("XK", new String[]{"en"});
        result.put("KG", new String[]{"ky"});
        result.put("KH", new String[]{"km"});
        result.put("KI", new String[]{"en"});
        result.put("KM", new String[]{"fr", "ar"});
        result.put("KN", new String[]{"en"});
        result.put("KP", new String[]{"ko"});
        result.put("KR", new String[]{"ko"});
        result.put("KW", new String[]{"ar", "en"});
        result.put("KY", new String[]{"en"});
        result.put("KZ", new String[]{"kk", "ru"});
        result.put("LA", new String[]{"lo", "fr"});
        result.put("LB", new String[]{"ar", "en", "fr"});
        result.put("LC", new String[]{"en", "fr"});
        result.put("LI", new String[]{"de"});
        result.put("LK", new String[]{"ta", "si", "en"});
        result.put("LR", new String[]{"en"});
        result.put("LS", new String[]{"st", "en"});
        result.put("LT", new String[]{"lt", "ru", "pl"});
        result.put("LU", new String[]{"fr", "de"});
        result.put("LV", new String[]{"lv", "lt", "ru"});
        result.put("LY", new String[]{"ar", "en", "it"});
        result.put("MA", new String[]{"ar", "fr", "es"});
        result.put("MC", new String[]{"fr", "en", "it"});
        result.put("MD", new String[]{"mo", "ro", "bg"});
        result.put("MF", new String[]{"fr"});
        result.put("MG", new String[]{"mg", "en", "fr"});
        result.put("MK", new String[]{"mk", "sh", "tr"});
        result.put("ML", new String[]{"fr"});
        result.put("MM", new String[]{"my"});
        result.put("MN", new String[]{"mn", "ru"});
        result.put("MO", new String[]{"zh", "pt"});
        result.put("MQ", new String[]{"fr"});
        result.put("MR", new String[]{"ar", "fr"});
        result.put("MS", new String[]{"en"});
        result.put("MT", new String[]{"mt", "en", "it"});
        result.put("MU", new String[]{"en", "fr", "hi"});
        result.put("MW", new String[]{"en"});
        result.put("MX", new String[]{"es"});
        result.put("MY", new String[]{"ms", "en"});
        result.put("MZ", new String[]{"pt"});
        result.put("NA", new String[]{"en", "af", "de"});
        result.put("NE", new String[]{"fr", "ha"});
        result.put("NF", new String[]{"en"});
        result.put("NG", new String[]{"en", "ha", "yo"});
        result.put("NI", new String[]{"es"});
        result.put("NL", new String[]{"nl", "fy"});
        result.put("NO", new String[]{"no"});
        result.put("NP", new String[]{"ne"});
        result.put("NR", new String[]{"na", "en"});
        result.put("NU", new String[]{"en"});
        result.put("NZ", new String[]{"en", "mi"});
        result.put("OM", new String[]{"ar", "en"});
        result.put("PA", new String[]{"es", "en"});
        result.put("PE", new String[]{"es", "qu", "ay"});
        result.put("PF", new String[]{"fr"});
        result.put("PG", new String[]{"en"});
        result.put("PH", new String[]{"en", "tl", "es"});
        result.put("PK", new String[]{"ur", "en", "ps", "pa", "sd"});
        result.put("PL", new String[]{"pl"});
        result.put("PM", new String[]{"fr", "en"});
        result.put("PN", new String[]{"en"});
        result.put("PR", new String[]{"es", "en"});
        result.put("PT", new String[]{"pt"});
        result.put("PW", new String[]{"en"});
        result.put("PY", new String[]{"es", "gn"});
        result.put("QA", new String[]{"ar", "en"});
        result.put("RE", new String[]{"fr", "ta"});
        result.put("RO", new String[]{"ro", "hu"});
        result.put("RU", new String[]{"ru"});
        result.put("RW", new String[]{"en", "fr", "rw"});
        result.put("SA", new String[]{"ar"});
        result.put("SB", new String[]{"en"});
        result.put("SC", new String[]{"en", "fr"});
        result.put("SD", new String[]{"ar", "su"});
        result.put("SE", new String[]{"sv"});
        result.put("SG", new String[]{"zh", "en", "ms", "ta"});
        result.put("SH", new String[]{"en"});
        result.put("SI", new String[]{"sl"});
        result.put("SJ", new String[]{"no"});
        result.put("SK", new String[]{"sk", "hu", "pl", "sh"});
        result.put("SL", new String[]{"en"});
        result.put("SM", new String[]{"it"});
        result.put("SN", new String[]{"fr"});
        result.put("SO", new String[]{"ar", "en", "it", "so"});
        result.put("SR", new String[]{"nl", "en", "es", "hi"});
        result.put("SS", new String[]{"en"});
        result.put("ST", new String[]{"pt"});
        result.put("SV", new String[]{"es"});
        result.put("SX", new String[]{"nl", "en"});
        result.put("SY", new String[]{"ar"});
        result.put("SZ", new String[]{"en", "ss"});
        result.put("TC", new String[]{"en"});
        result.put("TD", new String[]{"fr", "ar"});
        result.put("TF", new String[]{"fr"});
        result.put("TG", new String[]{"fr"});
        result.put("TH", new String[]{"th"});
        result.put("TJ", new String[]{"tg", "ru", "uz"});
        result.put("TK", new String[]{"en", "mi"});
        result.put("TL", new String[]{"pt"});
        result.put("TM", new String[]{"tk", "ru"});
        result.put("TN", new String[]{"ar"});
        result.put("TO", new String[]{"en", "to"});
        result.put("TR", new String[]{"tr", "ku"});
        result.put("TT", new String[]{"en"});
        result.put("TV", new String[]{"en"});
        result.put("TW", new String[]{"zh"});
        result.put("TZ", new String[]{"en", "sw"});
        result.put("UA", new String[]{"uk", "ru"});
        result.put("UG", new String[]{"en", "sw"});
        result.put("UM", new String[]{"en"});
        result.put("US", new String[]{"en", "es"});
        result.put("UY", new String[]{"es"});
        result.put("UZ", new String[]{"uz", "ru"});
        result.put("VA", new String[]{"la", "it"});
        result.put("VC", new String[]{"en"});
        result.put("VE", new String[]{"es"});
        result.put("VG", new String[]{"en"});
        result.put("VI", new String[]{"en"});
        result.put("VN", new String[]{"vi", "zh", "fr"});
        result.put("VU", new String[]{"en", "fr", "bi"});
        result.put("WF", new String[]{"fr"});
        result.put("WS", new String[]{"en", "sm"});
        result.put("YE", new String[]{"ar"});
        result.put("YT", new String[]{"fr", "mg", "sw"});
        result.put("YU", new String[]{"sr", "sh", "mk", "hu"});
        result.put("ZA", new String[]{"af", "en"});
        result.put("ZM", new String[]{"en"});
        result.put("ZW", new String[]{"en", "sn"});
        return result;
    }

    static {
        for (int n = 0; n < CONSTANT_LIST.length; ++n) {
            m_countriesByName.put(ISO3166.CONSTANT_LIST[n].m_name, CONSTANT_LIST[n]);
            m_countriesBy2.put(ISO3166.CONSTANT_LIST[n].m_a2, CONSTANT_LIST[n]);
            m_countriesBy3.put(ISO3166.CONSTANT_LIST[n].m_a3, CONSTANT_LIST[n]);
            m_countriesByNumber.put(ISO3166.CONSTANT_LIST[n].m_number, CONSTANT_LIST[n]);
        }
        m_defaultCountry = ISO3166.findCountryByISO3(Locale.getDefault().getISO3Country());
    }
}

