/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.utils;

import com.mapinfo.mapmarker.utils.IRandomAccessStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class RandomAccessStreamImpl
implements IRandomAccessStream {
    private static final int BUFFER_SIZE = 2048;
    private RandomAccessFile m_stream;
    private FileChannel m_channel;
    private ByteBuffer m_buffer;
    private long m_position;
    private boolean m_bPendingWrites;
    private int m_maxBufferPosition;

    protected RandomAccessStreamImpl(File file) throws IOException {
        this.m_stream = new RandomAccessFile(file, "rw");
        this.m_channel = this.m_stream.getChannel();
        this.m_buffer = ByteBuffer.allocate(2048);
        this.m_channel.read(this.m_buffer);
        this.m_buffer.position(0);
        this.m_bPendingWrites = false;
        this.m_position = 0L;
        this.m_maxBufferPosition = 0;
    }

    @Override
    public final void seek(long offset) throws IOException {
        if (this.checkBounds(offset)) {
            this.adjustBufferPosition(this.computeNewPosition(offset));
        } else {
            if (this.m_bPendingWrites) {
                this.write();
            }
            this.m_channel.position(offset);
            this.m_buffer.clear();
            this.m_channel.read(this.m_buffer);
            this.m_buffer.position(0);
            this.m_maxBufferPosition = 0;
            this.m_position = offset;
        }
    }

    @Override
    public final long getFilePointer() throws IOException {
        return this.m_position + (long)this.m_buffer.position();
    }

    @Override
    public final long length() throws IOException {
        long channelLength = this.m_channel.size();
        if (this.m_position + 2048L > channelLength) {
            int currentPos = this.m_buffer.position();
            int currentMax = this.m_maxBufferPosition > currentPos ? this.m_maxBufferPosition : currentPos;
            long internalSize = this.m_position + (long)currentMax;
            return internalSize > channelLength ? internalSize : channelLength;
        }
        return channelLength;
    }

    public final int skipBytes(int n) throws IOException {
        long currentOffset = this.getFilePointer();
        long remainder = this.length() - currentOffset;
        if (remainder < (long)n) {
            this.seek(currentOffset + remainder);
            return (int)remainder;
        }
        this.seek(currentOffset + (long)n);
        return n;
    }

    public final void flush() throws IOException {
        if (this.m_bPendingWrites) {
            this.write();
        }
        this.m_channel.force(true);
    }

    public final void close() throws IOException {
        this.flush();
        this.m_channel.close();
        this.m_stream.close();
        this.m_buffer.clear();
        this.m_channel = null;
        this.m_buffer = null;
    }

    public final void write(int b) throws IOException {
        if (this.m_buffer.remaining() == 0) {
            this.write();
        }
        this.m_buffer.put((byte)b);
        this.m_bPendingWrites = true;
    }

    public final byte readByte() throws IOException {
        if (this.m_buffer.remaining() < 1) {
            this.seek(this.getFilePointer());
        }
        return this.m_buffer.get();
    }

    public final void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    public final void write(byte[] bytes, int offset, int length) throws IOException {
        while (length > this.m_buffer.remaining()) {
            int remaining = this.m_buffer.remaining();
            this.m_buffer.put(bytes, offset, remaining);
            offset += remaining;
            length -= remaining;
            this.write();
        }
        this.m_buffer.put(bytes, offset, length);
        this.m_bPendingWrites = true;
    }

    public final void readFully(byte[] bytes, int offset, int length) throws IOException {
        while (length > this.m_buffer.remaining()) {
            int remaining = this.m_buffer.remaining();
            this.m_buffer.get(bytes, offset, remaining);
            offset += remaining;
            length -= remaining;
            this.seek(this.getFilePointer());
        }
        this.m_buffer.get(bytes, offset, length);
    }

    public final void readFully(byte[] bytes) throws IOException {
        this.readFully(bytes, 0, bytes.length);
    }

    private void write() throws IOException {
        ByteBuffer buffer;
        if (this.m_maxBufferPosition > this.m_buffer.position()) {
            this.m_buffer.position(this.m_maxBufferPosition);
        }
        if (this.m_buffer.remaining() != 0) {
            int newLimit = this.m_buffer.position();
            this.m_buffer.position(0);
            buffer = this.m_buffer.slice();
            buffer.limit(newLimit);
        } else {
            buffer = this.m_buffer;
        }
        this.m_channel.position(this.m_position);
        buffer.position(0);
        this.m_channel.write(buffer);
        this.m_buffer.clear();
        this.m_position = this.m_channel.position();
        this.m_channel.read(this.m_buffer);
        this.m_buffer.position(0);
        this.m_maxBufferPosition = 0;
        this.m_bPendingWrites = false;
    }

    private boolean checkBounds(long offset) {
        int newPos = this.computeNewPosition(offset);
        return newPos >= 0 && newPos < this.m_buffer.limit();
    }

    private int computeNewPosition(long offset) {
        return (int)(offset - this.m_position);
    }

    private void adjustBufferPosition(int newPosition) {
        if (newPosition < this.m_buffer.position() && this.m_maxBufferPosition < this.m_buffer.position()) {
            this.m_maxBufferPosition = this.m_buffer.position();
        }
        this.m_buffer.position(newPosition);
    }
}

