/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.utils;

import com.mapinfo.mapmarker.utils.ReadOnlyNIODataAccess;
import com.mapinfo.mapmarker.utils.SeekableDataInput;
import com.mapinfo.mapmarker.utils.SeekableDataInputUtilities;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UTFDataFormatException;

public class SeekableDataInputNIO
extends ReadOnlyNIODataAccess
implements SeekableDataInput {
    private static final int DEFAULT_BUFFER_SIZE = 2048;
    long m_length;

    public SeekableDataInputNIO(File file) throws FileNotFoundException, IOException {
        this(file, 2048);
    }

    public SeekableDataInputNIO(File file, int bufferSize) throws FileNotFoundException, IOException {
        this(file, bufferSize, true);
    }

    public SeekableDataInputNIO(File file, boolean bDirect) throws IOException {
        this(file, 2048, bDirect);
    }

    public SeekableDataInputNIO(File file, int bufferSize, boolean bDirect) throws IOException {
        super(file, bufferSize, bDirect);
        this.m_length = file.length();
    }

    @Override
    public long length() {
        return this.m_length;
    }

    @Override
    public long getFilePointer() throws IOException {
        return super.position();
    }

    @Override
    public void seek(long pos) throws IOException {
        super.position(pos);
    }

    @Override
    public long binarySearch(long floor, long ceiling, int recSize, int target) throws IOException {
        return SeekableDataInputUtilities.binarySearch((SeekableDataInput)this, floor, ceiling, recSize, target);
    }

    @Override
    public long binarySearch(long floor, long ceiling, int recSize, byte[] target) throws IOException {
        return SeekableDataInputUtilities.binarySearch((SeekableDataInput)this, floor, ceiling, recSize, target);
    }

    @Override
    public String readUTF() throws IOException {
        int utflen = this.readUnsignedShort();
        StringBuffer str = new StringBuffer(utflen);
        byte[] bytearr = new byte[utflen];
        int count = 0;
        this.readFully(bytearr, 0, utflen);
        block5: while (count < utflen) {
            int c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    str.append((char)c);
                    continue block5;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str.append((char)((c & 0x1F) << 6 | char2 & 0x3F));
                    continue block5;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str.append((char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0));
                    continue block5;
                }
            }
            throw new UTFDataFormatException();
        }
        return str.toString();
    }
}

