/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.utils;

import com.mapinfo.mapmarker.utils.SeekableDataInput;
import com.mapinfo.mapmarker.utils.SeekableDataInputUtilities;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UTFDataFormatException;

public class SeekableDataInputStream
implements SeekableDataInput {
    private final File m_file;
    private final int m_bufferSize;
    private DataInputStream m_in;
    private int m_pointer = 0;
    private long m_length;

    public SeekableDataInputStream(File file) throws FileNotFoundException {
        this(file, 2048);
    }

    public SeekableDataInputStream(File file, int bufferSize) throws FileNotFoundException {
        this.m_file = file;
        this.m_bufferSize = bufferSize;
        this.m_in = new DataInputStream(new BufferedInputStream(new FileInputStream(file), this.m_bufferSize));
        this.m_length = file.length();
    }

    @Override
    public long length() {
        return this.m_length;
    }

    private void reset() throws IOException {
        this.m_in.close();
        this.m_in = new DataInputStream(new BufferedInputStream(new FileInputStream(this.m_file), this.m_bufferSize));
        this.m_pointer = 0;
    }

    @Override
    public void close() throws IOException {
        this.m_in.close();
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.m_pointer;
    }

    @Override
    public void seek(long pos) throws IOException {
        if (pos > (long)this.m_pointer) {
            this.skipBytes((int)pos - this.m_pointer);
        } else if (pos < (long)this.m_pointer) {
            this.reset();
            this.skipBytes((int)pos);
        }
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.m_in.readFully(b);
        this.m_pointer += b.length;
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.m_in.readFully(b, off, len);
        this.m_pointer += len;
    }

    @Override
    public int skipBytes(int n) throws IOException {
        int result = this.m_in.skipBytes(n);
        this.m_pointer += result;
        return result;
    }

    @Override
    public boolean readBoolean() throws IOException {
        ++this.m_pointer;
        return this.m_in.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        ++this.m_pointer;
        return this.m_in.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        ++this.m_pointer;
        return this.m_in.readUnsignedByte();
    }

    @Override
    public short readShort() throws IOException {
        this.m_pointer += 2;
        return this.m_in.readShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        this.m_pointer += 2;
        return this.m_in.readUnsignedShort();
    }

    @Override
    public char readChar() throws IOException {
        this.m_pointer += 2;
        return this.m_in.readChar();
    }

    @Override
    public int readInt() throws IOException {
        this.m_pointer += 4;
        return this.m_in.readInt();
    }

    @Override
    public long readLong() throws IOException {
        this.m_pointer += 8;
        return this.m_in.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        this.m_pointer += 4;
        return this.m_in.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        this.m_pointer += 8;
        return this.m_in.readDouble();
    }

    @Override
    public String readLine() throws IOException {
        StringBuffer input = new StringBuffer();
        int c = -1;
        boolean eol = false;
        block4: while (!eol) {
            byte by = this.readByte();
            c = by;
            switch (by) {
                case -1: 
                case 10: {
                    eol = true;
                    continue block4;
                }
                case 13: {
                    eol = true;
                    if (this.readByte() == 10) continue block4;
                    this.seek(this.m_pointer);
                    continue block4;
                }
            }
            input.append((char)c);
        }
        if (c == -1 && input.length() == 0) {
            return null;
        }
        return input.toString();
    }

    @Override
    public String readUTF() throws IOException {
        int utflen = this.readUnsignedShort();
        StringBuffer str = new StringBuffer(utflen);
        byte[] bytearr = new byte[utflen];
        int count = 0;
        this.readFully(bytearr, 0, utflen);
        block5: while (count < utflen) {
            int c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    str.append((char)c);
                    continue block5;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str.append((char)((c & 0x1F) << 6 | char2 & 0x3F));
                    continue block5;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str.append((char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0));
                    continue block5;
                }
            }
            throw new UTFDataFormatException();
        }
        return str.toString();
    }

    @Override
    public long binarySearch(long floor, long ceiling, int recSize, int target) throws IOException {
        return SeekableDataInputUtilities.binarySearch((SeekableDataInput)this, floor, ceiling, recSize, target);
    }

    @Override
    public long binarySearch(long floor, long ceiling, int recSize, byte[] target) throws IOException {
        return SeekableDataInputUtilities.binarySearch((SeekableDataInput)this, floor, ceiling, recSize, target);
    }
}

