/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.utils;

import com.mapinfo.mapmarker.utils.SeekableDataInput;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;

public class SeekableDataInputUtilities {
    public static long binarySearch(SeekableDataInput input, long floor, long ceiling, int recSize, byte[] target) throws IOException {
        int keyRelation = 0;
        byte[] temp = new byte[target.length];
        if (floor < 0L || ceiling <= 0L || floor >= ceiling || ceiling <= floor) {
            return -1L;
        }
        long low = floor;
        long high = ceiling;
        while (high > low) {
            long probe = (high / (long)recSize + low / (long)recSize) / 2L * (long)recSize;
            input.seek(probe);
            input.readFully(temp);
            keyRelation = SeekableDataInputUtilities.compare(target, temp);
            if (keyRelation == 0) {
                high = probe;
                break;
            }
            if (keyRelation < 0) {
                if (low == probe) {
                    low += (long)recSize;
                    continue;
                }
                low = probe;
                continue;
            }
            high = probe;
        }
        if (high == ceiling || keyRelation != 0) {
            return -1L;
        }
        return high;
    }

    public static long binarySearch(SeekableDataInput input, long floor, long ceiling, int recSize, int target) throws IOException {
        return SeekableDataInputUtilities.binarySearch(input, floor, ceiling, recSize, SeekableDataInputUtilities.makeByteArray(target));
    }

    private static byte[] makeByteArray(int source) {
        if (source < 0) {
            throw new UnsupportedOperationException("source must be non-negative");
        }
        byte[] intBytes = BigInteger.valueOf(source).toByteArray();
        int intBytesLength = intBytes.length;
        byte[] finalBytes = new byte[4];
        Arrays.fill(finalBytes, (byte)0);
        System.arraycopy(intBytes, 0, finalBytes, 4 - intBytesLength, intBytesLength);
        return finalBytes;
    }

    private static int compare(byte[] target, byte[] current) {
        int l = target.length;
        if (l != current.length) {
            throw new UnsupportedOperationException("cannot compare keys that are not equal length.");
        }
        for (int i = 0; i < l; ++i) {
            int targetByte = target[i] & 0xFF;
            int currentByte = current[i] & 0xFF;
            if (targetByte < currentByte) {
                return 1;
            }
            if (targetByte <= currentByte) continue;
            return -1;
        }
        return 0;
    }
}

