/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.utils;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class StringWithTokens {
    private final LinkedList m_list = new LinkedList();

    public StringWithTokens(String orig) {
        this(orig, null);
    }

    public StringWithTokens(String orig, String tokenString) {
        if (orig != null && orig.length() != 0) {
            StringTokenizer st = tokenString != null ? new StringTokenizer(orig, tokenString) : new StringTokenizer(orig);
            while (st.hasMoreTokens()) {
                this.m_list.add(st.nextToken());
            }
        }
    }

    public String getFirstToken() {
        if (this.m_list.size() != 0) {
            return (String)this.m_list.getFirst();
        }
        return null;
    }

    public String getLastToken() {
        if (this.m_list.size() != 0) {
            return (String)this.m_list.getLast();
        }
        return null;
    }

    public String getToken(int i) {
        return (String)this.m_list.get(i);
    }

    public void insert(int i, String newToken) {
        if (i >= this.size()) {
            this.m_list.add(newToken);
            return;
        }
        this.m_list.add(" ");
        int endstart = this.size() - 1;
        for (int pos = endstart - 1; pos >= i; --pos) {
            this.setToken(pos + 1, this.getToken(pos));
        }
        this.setToken(i, newToken);
    }

    public String toString() {
        return this.toStringWithSep(' ');
    }

    public String toStringWithSep(char sep) {
        if (this.m_list.size() == 0) {
            return "";
        }
        if (this.m_list.size() == 1) {
            return this.getFirstToken();
        }
        StringBuffer buf = new StringBuffer();
        Iterator i = this.m_list.iterator();
        while (i.hasNext()) {
            buf.append((String)i.next());
            if (!i.hasNext()) continue;
            buf.append(sep);
        }
        return buf.toString();
    }

    public String setToken(int idx, String newToken) {
        return this.m_list.set(idx, newToken);
    }

    public int size() {
        return this.m_list.size();
    }

    public String removeFirst() {
        return (String)this.m_list.removeFirst();
    }

    public String removeLast() {
        return (String)this.m_list.removeLast();
    }

    public String remove(int index) {
        return (String)this.m_list.remove(index);
    }

    public boolean isEmpty() {
        return this.m_list.isEmpty();
    }

    public void clear() {
        this.m_list.clear();
    }

    public TokenIterator iterator() {
        return new TokenIterator(this.m_list.iterator());
    }

    public static class TokenIterator {
        private final Iterator m_i;

        private TokenIterator(Iterator i) {
            this.m_i = i;
        }

        public boolean hasNext() {
            return this.m_i.hasNext();
        }

        public String next() {
            return (String)this.m_i.next();
        }

        public void remove() {
            this.m_i.remove();
        }
    }
}

