/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.utils;

import com.mapinfo.mapmarker.utils.ISO3166;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class VersionDescriptor {
    private final ISO3166[] m_supportedCountries;
    private final Map m_countryVersionMap;
    private final String m_coreVersion;

    protected VersionDescriptor(Map countryVersionMap, String coreVersion) {
        this.m_supportedCountries = VersionDescriptor.buildCountriesFromMap(countryVersionMap);
        this.m_countryVersionMap = new HashMap(countryVersionMap.size());
        this.m_countryVersionMap.putAll(countryVersionMap);
        this.m_coreVersion = coreVersion;
    }

    public final ISO3166[] getSupportedCountries() {
        return this.m_supportedCountries;
    }

    public final String getVersion(ISO3166 country) {
        return (String)this.m_countryVersionMap.get(country);
    }

    public final String getCoreVersion() {
        return this.m_coreVersion;
    }

    public boolean isSupported(ISO3166 country) {
        return this.m_countryVersionMap.keySet().contains(country);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(50);
        String lineSeparator = System.getProperty("line.separator");
        sb.append(lineSeparator);
        sb.append("Core Version: ");
        sb.append(this.m_coreVersion);
        for (int n = 0; n < this.m_supportedCountries.length; ++n) {
            sb.append(lineSeparator);
            sb.append("Plugin Loaded For: ");
            sb.append(this.m_supportedCountries[n].getDisplayCountry());
            sb.append(" (");
            sb.append(this.m_supportedCountries[n].getISO3Country());
            sb.append(" - ");
            sb.append((String)this.m_countryVersionMap.get(this.m_supportedCountries[n]));
            sb.append(")");
        }
        return sb.toString();
    }

    private static final ISO3166[] buildCountriesFromMap(Map countryVersionMap) {
        ISO3166[] result = new ISO3166[countryVersionMap.size()];
        int index = 0;
        Iterator i = countryVersionMap.keySet().iterator();
        while (i.hasNext()) {
            result[index++] = (ISO3166)i.next();
        }
        return result;
    }
}

