#  This is a sample configuration file for Acu4GL for DB2.  This file
#  should be inserted into your standard COBOL configuration file
#  (\etc\cblconfig by default)

#  This file assumes that you are running from the sample/acu4gl directory.
#  This particular file is used by the demo program, and so needs some
#  extra variables.

DEFAULT-HOST		DB2

#  Illegal data will be converted to nulls by default.  Uncomment the
#  following line to cause illegal data to be converted to valid data

#4GL_ILLEGAL_DATA	Converted

#  The DB2 API has limited transaction management.  There is a commit
#  capability, and a rollback capability, but no start transaction
#  capability.  The commit or rollback is essentially done since the last
#  commit.  The following variable determines what the Acu4GL for DB2
#  interface will do on a start transaction:  a non-zero value will
#  issue a commit to the DB2 API, while a 0 value (the default) will do
#  nothing.  This has the affect that, if you set this to a non-zero value,
#  a commit or rollback will affect only the record written since the last
#  start, while if you don't set this, or set it to a value of 0, a
#  commit or rollback will affect records written since the last commit.

#A_DB2_COMMIT_ON_BEGIN	1

#  The following 2 variables should really be queried for and set within
#  a COBOL program.  But if you need to have a password for multiple people
#  and don't care that anyone can see this, uncomment the following 2 lines
#  and add a default login name and password.

#A_DB2_LOGIN
#A_DB2_PASSWD

#  The following variable determines what datasource to use when connecting
#  to an DB2 database.

#A_DB2_DATASOURCE

#  The following variable points to a file that can be used to allow the
#  end-user site to map database-dependent error messages to standard
#  COBOL error codes.  See the example file (DB2.err) that comes with
#  the distribution.

A_DB2_ERROR_MAP_FILE	../etc/DB2.err

# The following variable lets you store data that uses the
# BINARY directive as hexadecimal encoded CHAR types.  This 
# will allow you to work around some restrictions with the binary type.

A_DB2_USE_CHAR_FOR_BINARY	1

