#       This file must be customized when GeoTAX is installed.
#       Then it must be sourced using the C-shell built-in command
#       "source" to set up the environment for GeoTAX activity
#       each time you log in to your UNIX system.
#
# NOTE: This file is only for C-shell.  For Bourne type shells;
#       e.g., sh, ksh, bash, use the bin/setup file.
#
#       The following variables must almost always be changed:

setenv G1SYS 'OTHER'
# AIX, DGUX, HPUX, OSF1, SCO, SGI,
# SOLARIS, SUNBSD, ULTRIX or OTHER

setenv G1PROD 'gtx'

setenv G1PRODNAME 'GeoTAX'

setenv G1DIR '/usr/g1'
# Full path to Group 1 tree

#       The remaining lines do not normally need to be changed.
#       You may want to delete any that are already defined for
#       your environment by your system administrator, such as
#       G1RTS or LD_LIBRARY_PATH.  If you have any questions,
#       please contact your system administrator first, then
#       if necessary, contact Group 1 Software Technical Support.

# Full path to COBOL Runtime System (normal)
setenv G1RTS 'acucorp'

setenv G1GTX "$G1DIR/$G1PROD"   # Full path to GeoTAX tree
setenv G1GTXDB "$G1DIR/db"      # Full path to GeoTAX database files
                                # Change this if you installed into a
                                # non-default directory

setenv G1DB "$G1GTXDB"		# Set for api

setenv G1JOB sample             # Default run configuration ID -
                                #   cannot exceed six characters
setenv G1MAIL `logname`         # User to be notified of EOJ by mail
setenv G1TMP "$G1GTX"           # Full path to temp space
setenv G1MAILER mail

#===============================================================================
# Environment variables needed by the MSP scripts:

# Setup G1ECHO for stdout
switch ($G1SYS)
case SOLARIS|SUNBSD:
                setenv G1ECHO /usr/5bin/echo
                breaksw
case LINUX:
                setenv G1ECHO 'echo -e'
                breaksw
default:
                setenv G1ECHO echo
                breaksw
endsw

setenv G1MAIL `logname`         # User to be notified of EOJ by mail
setenv G1MAILER 'mail'          # System mail program (normal)

if ( $G1SYS == 'SCO' || $G1SYS == 'HPUX' ) then
     setenv G1CP 'cp'                   # cp command (SCO, HP/UX)
else
     setenv G1CP 'cp -p'                # cp command (normal)
endif

setenv G1JOB 'tbd'              # Default run configuration ID -
                                #   cannot exceed six characters
setenv G1TMP "$G1GTX"           # Full path to temp space

#===============================================================================
# COBOL compile and run-time environment variables

if ( $G1SYS != 'HPUX' ) then 
        setenv LD_LIBRARY_PATH "$G1RTS/lib:${G1GTX}/lib"
endif 

if ( $G1SYS != 'HPUX' ) then 
        setenv LIBPATH "$G1RTS/lib:/usr:/usr/lib:${G1GTX}/lib"
endif 

if ( $G1SYS == 'HPUX' ) then
        setenv SHLIB_PATH "$G1RTS/lib:${G1GTX}/lib"
endif

setenv G1PRODPATH "$G1GTX"
# AcuCOBOL-specific configuration ==============================================       
source ${G1PRODPATH}/bin/setuprts.csh
switch ($G1SYS)
case HPUX:
        setenv SHARED_LIBRARY_LIST ${SHARED_LIBRARY_LIST}:libgeostanMT.sl:libspatialMT.sl:libgdlMT.sl:libgtxlic.sl ;;
        breaksw
default:
        setenv SHARED_LIBRARY_LIST ${SHARED_LIBRARY_LIST}:libgeostanMT.so:libspatialMT.so:libgdlMT.so:libgtxlic.so ;;
        breaksw
endsw
#===============================================================================
# GeoTAX Data Files
#===============================================================================
setenv DD_GTBMPRM "$G1GTX/data/$G1JOB.gcbmprm" # input parameter record file

setenv DD_GTBMNAM "$G1GTX/data/$G1JOB.gcbmnam" # N/A input file
setenv DD_GTBMCOK "$G1GTX/data/$G1JOB.gcbmcok"
setenv DD_GTBMNCO "$G1GTX/data/$G1JOB.gcbmnco"
setenv DD_GCBMOUT "$G1GTX/data/$G1JOB.gcbmout" # N/A output file
setenv DD_GCBMREJ "$G1GTX/data/$G1JOB.gcbmrej" # N/A output reject file
setenv DD_GTBMPLC "$G1GTX/data/$G1JOB.gcbmplc"

setenv DD_PRNTRPT "$G1GTX/data/$G1JOB.prntrpt" # prntrpt file
setenv DD_PRNTXLG "$G1GTX/data/$G1JOB.prntxlg" # prntxlg file

#===============================================================================
# GeoTAX Databases 
#===============================================================================
setenv GTGSADR "$G1GTXDB"                         # Path to Address Database
setenv GTGSZP4 "$G1GTXDB/us.z9"                   # Zip Plus 4 Database
setenv GTBDCOU="$G1GTXDB/cousub.txb"              # County file
setenv GTBDPLC="$G1GTXDB/place.txb"               # Place file
setenv DD_GTMASTR "$G1GTXDB/gtmastr"              # GeoTax Database

setenv GTGSLIC "$G1GTXDB/license.lic"             # License file  
setenv DD_GTGSPAS "$G1GTXDB/gtgspas.lic"          # License Password file     
setenv DD_G1GTAUX "$G1GTXDB/g1gtaux"              # User Auxiliary File
setenv DD_G1GTAX2 "$G1GTXDB/g1gtax2"              # GTX Auxiliary File
setenv DD_G1GTXSN "$G1GTXDB/g1gtssn"              # State Supplied Street Names
setenv DD_G1GTXSD "$G1GTXDB/g1gtssd"              # State Supplied Details
setenv DD_G1GTXST "$G1GTXDB/g1gtsst"              # State Supplied Table Data
setenv DD_G1GTGSN "$G1GTXDB/g1gtgsn"              # State Supplied Street Names (TS-158 format)
setenv DD_G1GTGSD "$G1GTXDB/g1gtgsd"              # State Supplied Details (TS-158 format)
setenv DD_G1GTGST "$G1GTXDB/g1gtgst"              # State Supplied Table Data (TS-158 format)

setenv DD_GTTAXW "$G1GTXDB/gttaxw"                # Taxware File
setenv DD_GTTAXRT "$G1GTXDB/gttaxrt"              # Pitney Bowes Tax Rate File
setenv DD_GTMSTR2 "$G1GTXDB/gtmstr2"              # New GeoTAX cross reference

# Confidence File (optional)
setenv GTZ5GSB="$G1GTXDB/zip5.gsb"              # File for Confidence Code retrieval
setenv GTGCNTY="$G1GTXDB/counties.gsb           # County Confidence Code file

# Boundary Files
setenv GTBDIPD "$G1GTXDB/ipd.txb"           	  # Boundary File for Insurance Premium Districts
setenv GTBDPAY "$G1GTXDB/pay.txb"           	  # Boundary File for Payroll Tax Districts
setenv GTBDPTD "$G1GTXDB/ptd.txb"           	  # Boundary File for Property Tax Districts
setenv GTBDSPD "$G1GTXDB/spd.txb"           	  # Boundary File for Special Purpose Districts
setenv GTBDUSR "$G1GTXDB/gtbdusr"                 # Optional User Defined Boundary file

setenv DD_G1GTPTC="$G1GTXDB/g1gtptc"		  # Optional Payroll Tax Correspondence file

#===============================================================================

# Add G1RTS to PATH
setenv PATH ${G1RTS}/bin:${PATH}
