@echo off

rem (c) Copyright 2019 Micro Focus or one of its affiliates.
rem
rem The only warranties for products and services of Micro Focus and its
rem affiliates and licensors ("Micro Focus") are set forth in the express
rem warranty statements accompanying such products and services. Nothing
rem herein should be construed as constituting an additional warranty.
rem Micro Focus shall not be liable for technical or editorial errors or
rem omissions contained herein. The information contained herein is subject
rem to change without notice.
rem
rem Contains Confidential Information. Except as specifically indicated
rem otherwise, a valid license is required for possession, use or copying.
rem Consistent with FAR 12.211 and 12.212, Commercial Computer Software,
rem Computer Software Documentation, and Technical Data for Commercial
rem Items are licensed to the U.S. Government under vendor's standard
rem commercial license.

rem This script will set the environment for using ACUCOBOL-GT
rem It can set the environment for a 32-bit or 64-bit development
rem system or a 32-bit or 64-bit runtime system.
rem It depends on the registry entries created by the ACU installer.
rem If those are missing, chances are good that this won't do anything
rem reasonable.

rem The usage is:
rem setenv [32|64] [dev] [version]
rem We default to a 32-bit runtime system pointing to the version in
rem the registry value DefaultVersion

setlocal

set BITS=32
set DEV=0
set SHOWDEV=runtime
set VERS=

if not "%ACUCOBOL%" == "" goto alreadyset

:nextarg
if "%1" == "32" goto setbits32
if "%1" == "64" goto setbits64
if "%1" == "dev" goto setdev
if "%1" == "DEV" goto setdev
if not "%1" == "" goto setvers
if not "%VERS%" == "" goto startup

rem Version was not given - try to determine it from the registry
for /f "usebackq skip=2 tokens=2*" %%I in (`reg query "HKLM\SOFTWARE\Wow6432Node\Micro Focus\ACUCOBOL-GT" /v DefaultVersion 2^>nul`) do set VERS=%%J

rem ---  The 32-bit registry does not exist. Assume this is a 32-bit machine.
for /f "usebackq skip=2 tokens=2*" %%I in (`reg query "HKLM\SOFTWARE\Micro Focus\ACUCOBOL-GT" /v DefaultVersion 2^>nul`) do set VERS=%%J
if not "%VERS%" == "" goto startup
goto missingvers

goto startup

:setbits32
set BITS=32
shift
goto nextarg

:setbits64
set BITS=64
shift
goto nextarg

:setdev
set DEV=1
set SHOWDEV=development
shift
goto nextarg

:setvers
set VERS=%1
shift
goto nextarg

:startup

echo Setting up a %BITS%-bit %SHOWDEV% system for version %VERS%

if %DEV% == 0 goto set_runpath

    rem ---  DEVDIR always uses the 32-bit compiler
    rem ---  First check the 32-bit registry on a 64-bit machine
    for /f "usebackq skip=2 tokens=2*" %%I in (`reg query "HKLM\SOFTWARE\Wow6432Node\Micro Focus\ACUCOBOL-GT\%VERS%" /v PathName 2^>nul`) do set DEVDIR=%%J
    if not "%DEVDIR%" == "" goto set_runpath

    rem ---  The 32-bit registry does not exist. Assume this is a 32-bit machine.
    for /f "usebackq skip=2 tokens=2*" %%I in (`reg query "HKLM\SOFTWARE\Micro Focus\ACUCOBOL-GT\%VERS%" /v PathName 2^>nul`) do set DEVDIR=%%J
    if "%DEVDIR%" == "" goto missingreg

:set_runpath
    if %BITS% == 32 goto set32runpath
    rem ---  Check the 64-bit registry on a 64-bit machine (required if
    rem ---  we want to use a 64-bit runtime!)
    for /f "usebackq skip=2 tokens=2*" %%I in (`reg query "HKLM\SOFTWARE\Micro Focus\ACUCOBOL-GT\%VERS%" /v PathName 2^>nul`) do set ACUCOBOL=%%J
    if "%ACUCOBOL%" == "" goto missingreg
    goto setpath

:set32runpath
    rem ---  First check the 32-bit registry on a 64-bit machine
    for /f "usebackq skip=2 tokens=2*" %%I in (`reg query "HKLM\SOFTWARE\Wow6432Node\Micro Focus\ACUCOBOL-GT\%VERS%" /v PathName 2^>nul`) do set ACUCOBOL=%%J
    if not "%ACUCOBOL%" == "" goto setpath
    rem ---  The 32-bit registry does not exist. Assume this is a 32-bit machine.
    for /f "usebackq skip=2 tokens=2*" %%I in (`reg query "HKLM\SOFTWARE\Micro Focus\ACUCOBOL-GT\%VERS%" /v PathName 2^>nul`) do set ACUCOBOL=%%J
    if "%ACUCOBOL%" == "" goto missingreg
    goto setpath

:setpath
set RUNPATH=%ACUCOBOL%\bin
if %DEV% == 0 goto exportrunpath
set DEVPATH=%DEVDIR%\bin
if "%DEVPATH%" == "%RUNPATH%" set ADDPATH=%RUNPATH%
if not "%DEVPATH%" == "%RUNPATH%" set ADDPATH=%RUNPATH%;%DEVPATH%
set COPYPATH=%DEVDIR%\sample\def;%DEVDIR%\sample\xmlext;%COPYPATH%

rem The following works because cmd.exe resolves the entire command line
rem before executing it. So the "set" commands will set the appropriate
rem variables to the right value after the "endlocal" executes
echo Setting ACUCOBOL, COPYPATH, and PATH variables
endlocal & set ACUCOBOL=%ACUCOBOL%& set COPYPATH=%COPYPATH%& set PATH=%ADDPATH%;%PATH%& set CBLMODE=%BITS%
goto alldone

:exportrunpath
echo Setting PATH variable
endlocal & set ACUCOBOL=%ACUCOBOL%& set PATH=%RUNPATH%;%PATH%
goto alldone

:missingvers
echo Error! Version was not specified on the command line, and is not available
echo from the registry.
goto alldone

:missingreg
echo Internal error! Unable to find required registry entries
goto alldone

:alreadyset
echo The ACUCOBOL environment variable is alread set. Have you executed this already?
echo ACUCOBOL = %ACUCOBOL%
goto alldone

:alldone
