@ECHO OFF
::    This batch file is used to invoke the PB Tax Rate data-
::    base Load Program when running under Windows. The inputs
::    are sequential data files fed through the GTLDRTE program
::    from the %G1GTX%\lib area. All output data files are placed
::    into the %G1DB% directory. The input data should be placed
::    in the %G1GTX%\data directory and should be named PBRT.ASC.
::    A log file is placed in the %G1GTX%\data directory.

setLocal EnableExtensions
setlocal EnableDelayedExpansion

::  If running under the Spectrum ETM environment, %G1GTX%
::  will be set from %G1DCG%, %G1DB% will be set to %G1DCGDB% and in the following line enable_g1dcg
::  should be set to "yes".
    SET enable_g1dcg="yes"

    IF !enable_g1dcg! == "yes" (
      IF DEFINED G1DCG (
        IF EXIST "%G1DCG%\server\modules\gtx" (
          SET G1GTX=%G1DCG%\server\modules\gtx
          SET WRUN_EXE=!G1GTX!\acushare\wrun32
        ) ELSE (
          ECHO ***** ERROR ***** 
          ECHO Cannot find ETM directory, %G1DCG%\server\modules\gtx.
          ECHO Is the ETM module installed and the G1DCG environment variable set correctly?
          exit /b 1
        )
      ) ELSE (
        ECHO ***** ERROR ***** 
        ECHO The G1DCG environment variable is not set.
        exit /b 1
      )

      IF DEFINED G1DCGDB (
        IF EXIST "%G1DCGDB%" (
          SET G1DB=%G1DCGDB%
        ) ELSE (
          ECHO ***** ERROR ***** 
          ECHO Cannot find database directory, %G1DCGDB%.
          ECHO Is the ETM module installed and the G1DCGDB environment variable set correctly?
          exit /b 1
        )
      ) ELSE (
        ECHO ***** ERROR ***** 
        ECHO The G1DCGDB environment variable is not set.
        ECHO G1DCGDB should be set to the database directory where you want the data file to be loaded.
        exit /b 1
      )
    ) ELSE (
      SET WRUN_EXE=%G1GTX%\Runtime\wrun32
    )

    IF ."%G1DB%" == .""  GOTO G1DBERR
    IF ."%G1GTX%" == ."" GOTO G1GTXERR

::  Create the destination directory if it does not exist
    IF NOT EXIST "%G1DB%" MKDIR "%G1DB%"

::  Create a new process environment
    PUSHD "%G1GTX%\lib"

:: Configuration parameters

    SET CODE_PREFIX=^;"%G1GTX%\lib"
    SET SHARED_LIBRARY_PREFIX="%G1GTX%\lib"
::    SET SHARED_LIBRARY_LIST=G1PIOMGR.dll
    SET FILE_ALIAS_PREFIX=DD_;""


::  Set the DD for the execution log
    SET DD_PRNTRPT=%G1GTX%\data\LDTAXRTE.RPT
    SET DD_PRNTXLG=%G1GTX%\data\LDTAXRTE.XLG

::  Set the Input Data Definitions - change to the actual location
::  and file names
    SET DD_SEQRTE=%G1GTX%\data\PBRT.ASC

::  Set the Output Indexed File Data Definitions
    SET DD_GTTAXRT=%G1DB%\GTTAXRT

:STARTRUN
::    CLS

::  Run the Database Load program
    IF NOT EXIST "%DD_SEQRTE%" GOTO NOFILE
    ECHO **************************************************************
    ECHO Start GeoTAX PB TAX RATE Database Load Processing.
    ECHO Start GeoTAX PB TAX RATE Database Load Processing. > "%G1GTX%\data\LDTAXRTE.XLG"
    ECHO **************************************************************
    ECHO    Start GeoTAX PB TAX RATE Database Load.
    ECHO    Start GeoTAX PB TAX RATE Database Load.>> "%G1GTX%\data\LDTAXRTE.XLG" 2>&1
    "%WRUN_EXE%" -e "%G1GTX%\data\LDTAXRTE.err" "%G1GTX%\lib\GTLDRTE.acu"
    ECHO **************************************************************
    ECHO End GeoTAX PB TAX RATE Database Load Processing.
    ECHO End GeoTAX PB TAX RATE Database Load Processing.>> "%G1GTX%\data\LDTAXRTE.XLG"
    ECHO **************************************************************
::  Leave the process environment
    POPD
    GOTO ENDJOB

:NOFILE
   ECHO ***** ERROR ***** 
   ECHO Missing Input File.
   ECHO Please check the location and name of the input Files
   ECHO and rerun this process.
   POPD
   GOTO ENDJOB

:NEWFILE
   ECHO ***** INFORMATION ***** 
   ECHO An existing GeoTAX LDTAXRTE.XLG File has been detected in the
   ECHO %G1DB% subdirectory.
   ECHO As a precaution, this process will terminate.
   ECHO Please delete, backup, move or rename the existing
   ECHO GeoTAX PB TAX RATE File and rerun this process.
   POPD
   GOTO ENDJOB

:G1GTXERR
   ECHO ***** INFORMATION ***** 
   ECHO The G1GTX environment is not set
   GOTO ENDJOB

:G1DBERR
   ECHO ***** INFORMATION ***** 
   ECHO The G1DB Database environment is not set
   GOTO ENDJOB

:ENDJOB
