@ECHO OFF
::    This batch file is used to copy the GeoTAX Boundary File when
::    running under Windows. The output data file is placed into the
::    %G1DB% directory.

setLocal EnableExtensions
setlocal EnableDelayedExpansion

::  If running under the Spectrum ETM environment, %G1GTX%
::  will be set from %G1DCG%, %G1DB% will be set to %G1DCGDB% and in the following line enable_g1dcg
::  should be set to "yes".
    SET enable_g1dcg="yes"

    IF !enable_g1dcg! == "yes" (
      IF DEFINED G1DCG (
        IF EXIST "%G1DCG%\server\modules\gtx" (
          SET G1GTX=%G1DCG%\server\modules\gtx
          SET WRUN_EXE=!G1GTX!\acushare\wrun32
        ) ELSE (
          ECHO ***** ERROR ***** 
          ECHO Cannot find ETM directory, %G1DCG%\server\modules\gtx.
          ECHO Is the ETM module installed and the G1DCG environment variable set correctly?
          exit /b 1
        )
      ) ELSE (
        ECHO ***** ERROR ***** 
        ECHO The G1DCG environment variable is not set.
        exit /b 1
      )

      IF DEFINED G1DCGDB (
        IF EXIST "%G1DCGDB%" (
          SET G1DB=%G1DCGDB%
        ) ELSE (
          ECHO ***** ERROR ***** 
          ECHO Cannot find database directory, %G1DCGDB%.
          ECHO Is the ETM module installed and the G1DCGDB environment variable set correctly?
          exit /b 1
        )
      ) ELSE (
        ECHO ***** ERROR ***** 
        ECHO The G1DCGDB environment variable is not set.
        ECHO G1DCGDB should be set to the database directory where you want the data file to be loaded.
        exit /b 1
      )
    ) ELSE (
      SET WRUN_EXE=%G1GTX%\Runtime\wrun32
    )

    IF ."%G1CD%" == .""  GOTO G1CDERR
    IF ."%G1DB%" == .""  GOTO G1DBERR

::  Create the destination directory if it does not exist
    IF NOT EXIST "%G1DB%" MKDIR "%G1DB%"

::  Set the Input Data Definition - change to the actual location
::  and file names
    SET SEQSPAT=%G1CD%*.txb

:STARTRUN
    CLS

::  Copy the GeoTAX Boundary File
    IF NOT EXIST "%SEQSPAT%" GOTO NOFILE
    ECHO **************************************************************
    ECHO Start GeoTAX Boundary File copy.
    ECHO **************************************************************
    COPY "%SEQSPAT%" "%G1DB%"
    ECHO **************************************************************
    ECHO End GeoTAX Boundary File copy.
    ECHO **************************************************************
::  Leave the process environment
    GOTO ENDJOB

:NOFILE
   ECHO ***** ERROR ***** 
   ECHO Missing Input File(s).
   ECHO The inputs are expected on G1CD which is now set to %G1CD%.
   ECHO Please check the location and name of the input file
   ECHO and rerun this process.
   POPD
   GOTO ENDJOB

:G1DBERR
   ECHO ***** INFORMATION ***** 
   ECHO The G1DB Database environment is not set
   GOTO ENDJOB

:G1CDERR
   ECHO ***** INFORMATION ***** 
   ECHO The G1CD CD-ROM environment is not set
   GOTO ENDJOB

:ENDJOB
