@ECHO OFF
::    This batch file is used to invoke the GeoTAX utility to create the
::    auxiliary 2 file to override entries in the GeoTAX database. To
::    specify a different input file, change the SEQAUX environment
::    variable below.
::    A log file and report file is placed in the %G1GTX%\data directory.

setLocal EnableExtensions
setlocal EnableDelayedExpansion

::  If running under the Spectrum ETM environment, %G1GTX%
::  will be set from %G1DCG%, %G1DB% will be set to %G1DCGDB% and in the following line enable_g1dcg
::  should be set to "yes".
    SET enable_g1dcg="yes"

    IF !enable_g1dcg! == "yes" (
      IF DEFINED G1DCG (
        IF EXIST "%G1DCG%\server\modules\gtx" (
          SET G1GTX=%G1DCG%\server\modules\gtx
          SET WRUN_EXE=!G1GTX!\acushare\wrun32
        ) ELSE (
          ECHO ***** ERROR ***** 
          ECHO Cannot find ETM directory, %G1DCG%\server\modules\gtx.
          ECHO Is the ETM module installed and the G1DCG environment variable set correctly?
          exit /b 1
        )
      ) ELSE (
        ECHO ***** ERROR ***** 
        ECHO The G1DCG environment variable is not set.
        exit /b 1
      )

      IF DEFINED G1DCGDB (
        IF EXIST "%G1DCGDB%" (
          SET G1DB=%G1DCGDB%
        ) ELSE (
          ECHO ***** ERROR ***** 
          ECHO Cannot find database directory, %G1DCGDB%.
          ECHO Is the ETM module installed and the G1DCGDB environment variable set correctly?
          exit /b 1
        )
      ) ELSE (
        ECHO ***** ERROR ***** 
        ECHO The G1DCGDB environment variable is not set.
        ECHO G1DCGDB should be set to the database directory where you want the data file to be loaded.
        exit /b 1
      )
    ) ELSE (
      SET WRUN_EXE=%G1GTX%\Runtime\wrun32
    )

    IF ."%G1GTX%" == ."" GOTO G1GTXERR

::  Create the destination directory if it does not exist
    IF NOT EXIST "%G1DB%" MKDIR "%G1DB%"

:: Configuration parameters

    SET CODE_PREFIX=^;"%G1GTX%\lib"
    SET SHARED_LIBRARY_PREFIX="%G1GTX%\lib"
    SET SHARED_LIBRARY_LIST=G1PIOMGR.dll
    SET FILE_ALIAS_PREFIX=DD_;""

::  Set the Input Data Definition - change to the actual location
::  and file name
    SET DD_SEQAUX=%G1GTX%\data\SEQAUX2.ASC

::  Set the Output Data Definitions

    SET DD_G1GTAX2=%G1DB%\G1GTAX2

    SET DD_PRNTXLG=%G1GTX%\data\MAKEAUX2.XLG
    SET DD_PRNTRPT=%G1GTX%\data\MAKEAUX2.RPT

:STARTRUN
    CLS

::  Run the Create Database program

    if not exist %DD_SEQAUX% GOTO NOFILE
    ECHO **************************************************************
    ECHO Start GeoTAX Auxiliary 2 File Processing.
    ECHO Start GeoTAX Auxiliary 2 File Processing. > "%G1GTX%\data\MAKEAUX2.LOG"
    ECHO **************************************************************
    PUSHD "%G1GTX%\lib"
    "%WRUN_EXE%" "%G1GTX%\lib\GTAX2BLD.acu"
    POPD
    ECHO **************************************************************
    ECHO End GeoTAX Auxiliary 2 File Processing.
    ECHO End GeoTAX Auxiliary 2 File Processing.>> "%G1GTX%\data\MAKEAUX2.LOG"
    ECHO **************************************************************
    GOTO ENDJOB

:NOFILE
    ECHO ***** ERROR ***** 
    ECHO Missing auxiliary file.
    ECHO Please specify the correct location and name
    ECHO of the auxiliary file to load.
    GOTO ENDJOB

:G1GTXERR
   ECHO ***** INFORMATION ***** 
   ECHO The G1GTX environment is not set
   GOTO ENDJOB

:ENDJOB
