000001*   PLATFORM = UNIX                                               SETVARS
000002*   OPSYS    = NT                                                 SETVARS
000003*   CODESET  = ASCII                                              SETVARS
000004*   PRODUCT  = GTX                                                SETVARS
000005*   ENVIRON  = BATCH                                              SETVARS
000006*   COMPILER = MICROFOC                                           SETVARS
000007*   TERMIO   = MICROFOC                                           SETVARS
000008*%I CBLSHEL /SMPLEXOP/                                            SMPLEXOP
000009*%I DIALECT                                                       CBLSHEL
000010*%X DIALECT                                                       CBLSHEL
000011 IDENTIFICATION DIVISION.                                         CBLSHEL
000012 PROGRAM-ID. SMPLEXOP.                                            CBLSHEL
000013 DATE-COMPILED.                                                   CBLSHEL
000014*%I GROUP1                                                        CBLSHEL
000015                                                                  GROUP1
000016** =========================================================== ** GROUP1
000017*                                                               * GROUP1
000018*                             GEOTAX                            * GROUP1
000019*                       RELEASE 7.6 MOD 00                      * GROUP1
000020*                                                               * GROUP1
000021*  AUTHOR.                                                      * GROUP1
000022*     PITNEY BOWES SOFTWARE INC                                 * GROUP1
000023*     ALL RIGHTS RESERVED.                                      * GROUP1
000024*     SUITE 200                                                 * GROUP1
000025*     4200 PARLIAMENT PLACE                                     * GROUP1
000026*     LANHAM, MD 20706-1844                                     * GROUP1
000027*                                                               * GROUP1
000028*     PROGRAMS AND DESIGN (C) COPYRIGHT 1990-2019               * GROUP1
000029*     PITNEY BOWES SOFTWARE INC                                 * GROUP1
000030*                                                               * GROUP1
000031*  THE FOLLOWING MATERIAL CONTAINS TRADE SECRETS AND            * GROUP1
000032*  CONFIDENTIAL INFORMATION AND REPRESENTS THE PROPERTY OF      * GROUP1
000033*  PITNEY BOWES SOFTWARE INC AND SHOULD BE MAINTAINED IN STRICT * GROUP1
000034*  CONFIDENCE.                                                  * GROUP1
000035*                                                               * GROUP1
000036** =========================================================== ** GROUP1
000037                                                                  GROUP1
000038*%X GROUP1                                                        CBLSHEL
000039 ENVIRONMENT DIVISION.                                            CBLSHEL
000040 CONFIGURATION SECTION.                                           CBLSHEL
000041*%I @@SOURCE                                                      CBLSHEL
000042 SOURCE-COMPUTER. UNIX.                                           @@SOURCE
000043*%X @@SOURCE                                                      CBLSHEL
000044*%I @@OBJECT                                                      CBLSHEL
000045 OBJECT-COMPUTER. UNIX.                                           @@OBJECT
000046*%X @@OBJECT                                                      CBLSHEL
000047*%I @@SPECNM                                                      CBLSHEL
000048*%X @@SPECNM                                                      CBLSHEL
000049 INPUT-OUTPUT SECTION.                                            CBLSHEL
000050 FILE-CONTROL.                                                    CBLSHEL
000051*%X CBLSHEL /SMPLEXOP/                                            SMPLEXOP
000052                                                                  SMPLEXOP
000053**==============================================================**SMPLEXOP
000054*                                                                *SMPLEXOP
000055*  THIS SAMPLE PROGRAM SHOWS HOW TO CODE AN EXITOP PROGRAM FOR   *SMPLEXOP
000056*  THE GROUP1 CODE-1 PLUS PRODUCT.  THIS PROGRAM IS DESIGNED TO  *SMPLEXOP
000057*  COMPARE THE GIVEN ADDRESS TO THE MATCHED ADDRESS CODE-1 PLUS  *SMPLEXOP
000058*  DETERMINED.  ANY DIFFERENCES WILL BE REPORTED TO THE OUTPUT   *SMPLEXOP
000059*  FILE AND A COUNT WILL BE KEPT.  THIS SPECIFIC PROGRAM  HAS    *SMPLEXOP
000060*  BEEN DESIGNED TO FUNCTION WITH THE STANDARD NAME AND ADDRESS  *SMPLEXOP
000061*  FILE, THE IVPFILE, SHIPPED WITH CODE-1 PLUS.  IT CAN BE       *SMPLEXOP
000062*  MODIFIED TO WORK WITH YOUR SPECIFIC NAME AND ADDRESS FILE.    *SMPLEXOP
000063*                                                                *SMPLEXOP
000064*  THE LINKAGE TO THIS PROGRAM FOLLOWS A STANDARD LAYOUT USED    *SMPLEXOP
000065*  FOR ALL GROUP 1 EXITOP PROGRAMS.                              *SMPLEXOP
000066*  THIS LAYOUT IS AS FOLLOWS:                                    *SMPLEXOP
000067*                                                                *SMPLEXOP
000068*    PARAMETER 1 - FUNCTION TO BE EXECUTED (LENGTH: 1)           *SMPLEXOP
000069*                   POSITION 1:                                  *SMPLEXOP
000070*                     O - OPEN                                   *SMPLEXOP
000071*                     W - WRITE                                  *SMPLEXOP
000072*                     C - CLOSE                                  *SMPLEXOP
000073*                                                                *SMPLEXOP
000074*    PARAMETER 2 - FILE NAME TO WHICH THE CURRENT RECORD WILL    *SMPLEXOP
000075*                  BE PROCESSED TO AFTER THE RETURN FROM THIS    *SMPLEXOP
000076*                  EXIT PROGRAM (LENGTH: 7)                      *SMPLEXOP
000077*                   POSITION 1 TO 7: (FOR CODE-1 PLUS)           *SMPLEXOP
000078*                     C1BMCOK - CODED OK FILE                    *SMPLEXOP
000079*                     C1BMNCO - NOT CODED FILE                   *SMPLEXOP
000080*                     C1BMIZP - NOT CODED DUE TO INPUT ZIP       *SMPLEXOP
000081*                               MISMATCH FILE                    *SMPLEXOP
000082*                     C1BMZP4 - SUBSET OF C1BMCOK CONTAINING     *SMPLEXOP
000083*                               VALID ZIP+4 CODES                *SMPLEXOP
000084*                                                                *SMPLEXOP
000085*    PARAMETER 3 - CURRENT RECORD TO BE PROCESSED LENGTH IS USER *SMPLEXOP
000086*                  DEFINED FOR THE NOTED FILES LISTED FOR THE    *SMPLEXOP
000087*                  PARAMETER 2 ABOVE (LENGTH: USER DEFINED)      *SMPLEXOP
000088*                                                                *SMPLEXOP
000089*    PARAMETER 4 - THE EXITOP CONTROL RECORD USED TO ACTIVATE    *SMPLEXOP
000090*                  THIS ROUTINE (LENGTH: 80)                     *SMPLEXOP
000091*                   POSITION 1 TO 6:                             *SMPLEXOP
000092*                     LITERAL - "EXITOP"                         *SMPLEXOP
000093*                   POSITION 7:                                  *SMPLEXOP
000094*                     FILLER                                     *SMPLEXOP
000095*                   POSITION 8 TO 15:                            *SMPLEXOP
000096*                     NAME OF THIS ROUTINE                       *SMPLEXOP
000097*                   POSITION 16 TO 17:                           *SMPLEXOP
000098*                     FILLER                                     *SMPLEXOP
000099*                   POSITION 18 TO 80:                           *SMPLEXOP
000100*                     USER DEFINED PARAMETERS SPECIFIC TO THIS   *SMPLEXOP
000101*                     ROUTINE                                    *SMPLEXOP
000102*                                                                *SMPLEXOP
000103*  NOTE THAT THE FOLLOWING EXTERNAL FILES ARE USED:              *SMPLEXOP
000104*                                                                *SMPLEXOP
000105*    SMPLEXOP - THIS PROGRAM                                     *SMPLEXOP
000106*                                                                *SMPLEXOP
000107*        SMPLOUT - OUTPUT REPORT FILE                            *SMPLEXOP
000108*                                                                *SMPLEXOP
000109**==============================================================**SMPLEXOP
000110                                                                  SMPLEXOP
000111                                                                  SMPLEXOP
000112     SELECT SMPLOUT                                               SMPLEXOP
000113       ASSIGN TO EXTERNAL SMPLOUT                                 SMPLEXOP
000114       ORGANIZATION IS SEQUENTIAL                                 SMPLEXOP
000115       FILE STATUS OUTPUT-FILE-STATUS                             SMPLEXOP
000116     .                                                            SMPLEXOP
000117                                                                  SMPLEXOP
000118 DATA DIVISION.                                                   CBLSHEL
000119 FILE SECTION.                                                    CBLSHEL
000120                                                                  SMPLEXOP
000121 FD  SMPLOUT                                                      SMPLEXOP
000122     RECORD CONTAINS 80 CHARACTERS                                SMPLEXOP
000123     LABEL RECORD IS STANDARD                                     SMPLEXOP
000124     DATA RECORD IS OUTPUT-RECORD.                                SMPLEXOP
000125 01  OUTPUT-RECORD.                                               SMPLEXOP
000126     05  TYPE-REC                PIC X(9).                        SMPLEXOP
000127     05  FILLER                  PIC X.                           SMPLEXOP
000128     05  PRT-LINE                PIC X(70).                       SMPLEXOP
000129                                                                  SMPLEXOP
000130 WORKING-STORAGE SECTION.                                         CBLSHEL
000131                                                                  CBLSHEL
000132                                                                  SMPLEXOP
000133 01  FILLER                      PIC X(80)  VALUE                 SMPLEXOP
000134     "SMPLEXOP WORKING STORAGE SECTION BEGINS HERE".              SMPLEXOP
000135                                                                  SMPLEXOP
000136 01  OUTPUT-FILE-STATUS          PIC X(2)   VALUE SPACES.         SMPLEXOP
000137                                                                  SMPLEXOP
000138 01  WS-EOF                      PIC X      VALUE SPACE.          SMPLEXOP
000139 01  WS-ERROR-OPENING            PIC X      VALUE SPACE.          SMPLEXOP
000140 01  COUNTERS-SWITCHES.                                           SMPLEXOP
000141     05  C-S.                                                     SMPLEXOP
000142         10  FATAL-FLAG          PIC X      VALUE "N".            SMPLEXOP
000143             88  FATAL-ERROR                VALUE "Y".            SMPLEXOP
000144         10  FIRST-FLAG          PIC X      VALUE "Y".            SMPLEXOP
000145             88  FIRST-TIME                 VALUE "Y".            SMPLEXOP
000146         10  CLOSE-FLAG          PIC X      VALUE "Y".            SMPLEXOP
000147             88  FIRST-CLOSE                VALUE "Y".            SMPLEXOP
000148         10  DIFFERENCES-FLAG    PIC X      VALUE "N".            SMPLEXOP
000149             88  DIFFERENCES-FOUND          VALUE "Y".            SMPLEXOP
000150         10  REC-READ-CNTR       PIC S9(9)  COMP VALUE +0.        SMPLEXOP
000151         10  PS-POS              PIC S9(5)  COMP VALUE +0.        SMPLEXOP
000152         10  END-POS             PIC S9(5)  COMP VALUE +0.        SMPLEXOP
000153         10  IA-LEN              PIC S9(5)  COMP VALUE +0.        SMPLEXOP
000154         10  AST-POS             PIC S9(5)  COMP VALUE +0.        SMPLEXOP
000155         10  MISMATCHES          PIC S9(5)  COMP VALUE +0.        SMPLEXOP
000156         10  EDIT-MASK           PIC ZZZ,ZZZ,ZZ9.                 SMPLEXOP
000157     05  COMPARE-FLAGS.                                           SMPLEXOP
000158         10  ADDR1-FLAG          PIC X(1)   VALUE "N".            SMPLEXOP
000159             88 COMPARE-ADDR1               VALUE "Y".            SMPLEXOP
000160         10  ADDR2-FLAG          PIC X(1)   VALUE "N".            SMPLEXOP
000161             88 COMPARE-ADDR2               VALUE "Y".            SMPLEXOP
000162         10  CITY-FLAG           PIC X(1)   VALUE "N".            SMPLEXOP
000163             88 COMPARE-CITY                VALUE "Y".            SMPLEXOP
000164         10  STATE-FLAG          PIC X(1)   VALUE "N".            SMPLEXOP
000165             88 COMPARE-STATE               VALUE "Y".            SMPLEXOP
000166         10  ZIP-FLAG            PIC X(1)   VALUE "N".            SMPLEXOP
000167             88 COMPARE-ZIP                 VALUE "Y".            SMPLEXOP
000168         10  ZP4-FLAG            PIC X(1)   VALUE "N".            SMPLEXOP
000169             88 COMPARE-ZIP-ADDON           VALUE "Y".            SMPLEXOP
000170                                                                  SMPLEXOP
000171 01  SMPLEXOP-TITLE.                                              SMPLEXOP
000172     05  FILLER                  PIC X(80)  VALUE                 SMPLEXOP
000173         "SMPLEXOP - Sample Compare Addresses EXITOP Program".    SMPLEXOP
000174                                                                  SMPLEXOP
000175 01  RECORD-ID-LINE.                                              SMPLEXOP
000176     05  FILLER                  PIC X(24)  VALUE                 SMPLEXOP
000177                                 "Error on record number:".       SMPLEXOP
000178     05  RECORD-NUMBER           PIC ZZZ,ZZZ,ZZ9 VALUE ZERO.      SMPLEXOP
000179     05  FILLER                  PIC X(20)  VALUE                 SMPLEXOP
000180                                 "  Destination File:".           SMPLEXOP
000181     05  RECORD-FILE             PIC X(8)   VALUE SPACES.         SMPLEXOP
000182                                                                  SMPLEXOP
000183 01  HOLD-AREAS.                                                  SMPLEXOP
000184     05  ERROR-HOLD              PIC X(200) VALUE SPACES.         SMPLEXOP
000185                                                                  SMPLEXOP
000186 01  FILLER                      PIC X(80)  VALUE                 SMPLEXOP
000187     "SMPLEXOP WORKING STORAGE SECTION ENDS HERE".                SMPLEXOP
000188                                                                  SMPLEXOP
000189 LINKAGE SECTION.                                                 SMPLEXOP
000190                                                                  SMPLEXOP
000191 01  EXITOP-FUNCTION.                                             SMPLEXOP
000192     05  EXITOP-FUNCTION-BYTE       PIC X.                        SMPLEXOP
000193         88  IS-OPEN                        VALUE "O".            SMPLEXOP
000194         88  IS-WRITE                       VALUE "W".            SMPLEXOP
000195         88  IS-CLOSE                       VALUE "C".            SMPLEXOP
000196                                                                  SMPLEXOP
000197 01  EXITOP-FILE.                                                 SMPLEXOP
000198     05  EXITOP-FILE-ACTIVATOR.                                   SMPLEXOP
000199         88  IS-COK                         VALUE "C1BMCOK".      SMPLEXOP
000200         88  IS-NCO                         VALUE "C1BMNCO".      SMPLEXOP
000201         88  IS-IZP                         VALUE "C1BMIZP".      SMPLEXOP
000202         88  IS-ZP4                         VALUE "C1BMZP4".      SMPLEXOP
000203         10  FILLER              PIC X(4).                        SMPLEXOP
000204         10  EXITOP-FILE-ACT     PIC X(3).                        SMPLEXOP
000205                                                                  SMPLEXOP
000206 01  EXITOP-RECORD.                                               SMPLEXOP
000207     05  FILLER                  PIC X(70).                       SMPLEXOP
000208     05  EXITOP-INPUT-ADDRESS.                                    SMPLEXOP
000209         10  EXITOP-IN-ADDR1     PIC X(35).                       SMPLEXOP
000210         10  EXITOP-IN-ADDR2     PIC X(35).                       SMPLEXOP
000211         10  EXITOP-IN-CITY      PIC X(20).                       SMPLEXOP
000212         10  EXITOP-IN-STATE     PIC X(02).                       SMPLEXOP
000213         10  EXITOP-IN-ZIP       PIC X(05).                       SMPLEXOP
000214         10  EXITOP-IN-ZP4       PIC X(04).                       SMPLEXOP
000215     05  FILLER                  PIC X(85).                       SMPLEXOP
000216     05  EXITOP-OUTPUT-ADDRESS.                                   SMPLEXOP
000217         10  EXITOP-OUT-ADDR1    PIC X(35).                       SMPLEXOP
000218         10  EXITOP-OUT-ADDR2    PIC X(35).                       SMPLEXOP
000219         10  EXITOP-OUT-CITY     PIC X(20).                       SMPLEXOP
000220         10  EXITOP-OUT-STATE    PIC X(02).                       SMPLEXOP
000221         10  EXITOP-OUT-ZIP      PIC X(05).                       SMPLEXOP
000222         10  EXITOP-OUT-ZP4      PIC X(04).                       SMPLEXOP
000223     05  FILLER                  PIC X(85).                       SMPLEXOP
000224                                                                  SMPLEXOP
000225 01  EXITOP-CONTROL-CARD.                                         SMPLEXOP
000226     05  EXITOP-CARD-IMAGE.                                       SMPLEXOP
000227         10  FILLER              PIC X(7).                        SMPLEXOP
000228         10  EXITOP-RTN          PIC X(8).                        SMPLEXOP
000229         10  FILLER              PIC X(2).                        SMPLEXOP
000230     05  EXITOP-COMPARE-FLAGS.                                    SMPLEXOP
000231         10  EXITOP-ADDR1-FLAG   PIC X(1).                        SMPLEXOP
000232         10  FILLER              PIC X(1).                        SMPLEXOP
000233         10  EXITOP-ADDR2-FLAG   PIC X(1).                        SMPLEXOP
000234         10  FILLER              PIC X(1).                        SMPLEXOP
000235         10  EXITOP-CITY-FLAG    PIC X(1).                        SMPLEXOP
000236         10  FILLER              PIC X(1).                        SMPLEXOP
000237         10  EXITOP-STATE-FLAG   PIC X(1).                        SMPLEXOP
000238         10  FILLER              PIC X(1).                        SMPLEXOP
000239         10  EXITOP-ZIP-FLAG     PIC X(1).                        SMPLEXOP
000240         10  FILLER              PIC X(1).                        SMPLEXOP
000241         10  EXITOP-ZP4-FLAG     PIC X(1).                        SMPLEXOP
000242     05  FILLER                  PIC X(52).                       SMPLEXOP
000243                                                                  SMPLEXOP
000244*%I SETVARS                                                            GP1
000245*%X SETVARS                                                            GP1
000246*%I SMPLEXOP /SMPLEXOP/                                                GP1
000247 PROCEDURE DIVISION USING EXITOP-FUNCTION                         SMPLEXOP
000248                          EXITOP-FILE                             SMPLEXOP
000249                          EXITOP-RECORD                           SMPLEXOP
000250                          EXITOP-CONTROL-CARD.                    SMPLEXOP
000251                                                                  SMPLEXOP
000252*%I BEGSR /MAINLINE/                                              SMPLEXOP
000253 MAINLINE-RTN.                                                    BEGSR
000254*%X BEGSR /MAINLINE/                                              SMPLEXOP
000255                                                                  SMPLEXOP
000256     IF FIRST-TIME AND IS-OPEN                                    SMPLEXOP
000257       PERFORM INIT1T-RTN THRU INIT1T-EXIT                        SMPLEXOP
000258       IF FATAL-ERROR                                             SMPLEXOP
000259*%I RETURN99                                                      SMPLEXOP
000260     MOVE 99 TO RETURN-CODE                                       RETURN99
000261     STOP RUN                                                     RETURN99
000262                                                                  RETURN99
000263*%X RETURN99                                                      SMPLEXOP
000264       END-IF                                                     SMPLEXOP
000265     END-IF                                                       SMPLEXOP
000266                                                                  SMPLEXOP
000267     IF IS-WRITE                                                  SMPLEXOP
000268       PERFORM PROCESS-INPUT-FILE-RTN                             SMPLEXOP
000269          THRU PROCESS-INPUT-FILE-EXIT                            SMPLEXOP
000270       IF FATAL-ERROR                                             SMPLEXOP
000271*%I RETURN99                                                      SMPLEXOP
000272     MOVE 99 TO RETURN-CODE                                       RETURN99
000273     STOP RUN                                                     RETURN99
000274                                                                  RETURN99
000275*%X RETURN99                                                      SMPLEXOP
000276       END-IF                                                     SMPLEXOP
000277     END-IF                                                       SMPLEXOP
000278                                                                  SMPLEXOP
000279     IF IS-CLOSE AND FIRST-CLOSE                                  SMPLEXOP
000280       PERFORM CLOSE-RTN THRU CLOSE-EXIT                          SMPLEXOP
000281       IF FATAL-ERROR                                             SMPLEXOP
000282*%I RETURN99                                                      SMPLEXOP
000283     MOVE 99 TO RETURN-CODE                                       RETURN99
000284     STOP RUN                                                     RETURN99
000285                                                                  RETURN99
000286*%X RETURN99                                                      SMPLEXOP
000287       END-IF                                                     SMPLEXOP
000288     END-IF                                                       SMPLEXOP
000289                                                                  SMPLEXOP
000290*%I RETURN                                                        SMPLEXOP
000291     EXIT PROGRAM                                                 RETURN
000292*%X RETURN                                                        SMPLEXOP
000293     .                                                            SMPLEXOP
000294*%I ENDSR /MAINLINE/                                              SMPLEXOP
000295 MAINLINE-EXIT. EXIT.                                             ENDSR
000296*%X ENDSR /MAINLINE/                                              SMPLEXOP
000297                                                                  SMPLEXOP
000298*%I BEGSR /NEVER/                                                 SMPLEXOP
000299 NEVER-RTN.                                                       BEGSR
000300*%X BEGSR /NEVER/                                                 SMPLEXOP
000301     DISPLAY "SMPLEXOP SHOULD NEVER REACH HERE"                   SMPLEXOP
000302     STOP RUN                                                     SMPLEXOP
000303     .                                                            SMPLEXOP
000304*%I ENDSR /NEVER/                                                 SMPLEXOP
000305 NEVER-EXIT. EXIT.                                                ENDSR
000306*%X ENDSR /NEVER/                                                 SMPLEXOP
000307                                                                  SMPLEXOP
000308**==============================================================**SMPLEXOP
000309* TEST INPUT RECORDS                                             *SMPLEXOP
000310**==============================================================**SMPLEXOP
000311*%I BEGSR /PROCESS-INPUT-FILE/                                    SMPLEXOP
000312 PROCESS-INPUT-FILE-RTN.                                          BEGSR
000313*%X BEGSR /PROCESS-INPUT-FILE/                                    SMPLEXOP
000314                                                                  SMPLEXOP
000315     IF IS-ZP4                                                    SMPLEXOP
000316        GO TO PROCESS-INPUT-FILE-EXIT                             SMPLEXOP
000317     END-IF                                                       SMPLEXOP
000318                                                                  SMPLEXOP
000319     ADD 1       TO REC-READ-CNTR                                 SMPLEXOP
000320     MOVE SPACES TO ERROR-HOLD                                    SMPLEXOP
000321*    MOVE LENGTH OF EXITOP-INPUT-ADDRESS TO IA-LEN                SMPLEXOP
000322     MOVE +101                           TO IA-LEN                SMPLEXOP
000323     MOVE "N"    TO DIFFERENCES-FLAG                              SMPLEXOP
000324                                                                  SMPLEXOP
000325*** PROCESS  RECORD ***                                           SMPLEXOP
000326                                                                  SMPLEXOP
000327     IF COMPARE-ADDR1                                             SMPLEXOP
000328        IF EXITOP-IN-ADDR1 NOT = EXITOP-OUT-ADDR1                 SMPLEXOP
000329          MOVE "Y" TO DIFFERENCES-FLAG                            SMPLEXOP
000330        END-IF                                                    SMPLEXOP
000331     END-IF                                                       SMPLEXOP
000332                                                                  SMPLEXOP
000333     IF COMPARE-ADDR2                                             SMPLEXOP
000334        IF EXITOP-IN-ADDR2 NOT = EXITOP-OUT-ADDR2                 SMPLEXOP
000335          MOVE "Y" TO DIFFERENCES-FLAG                            SMPLEXOP
000336        END-IF                                                    SMPLEXOP
000337     END-IF                                                       SMPLEXOP
000338                                                                  SMPLEXOP
000339     IF COMPARE-CITY                                              SMPLEXOP
000340        IF EXITOP-IN-CITY NOT = EXITOP-OUT-CITY                   SMPLEXOP
000341          MOVE "Y" TO DIFFERENCES-FLAG                            SMPLEXOP
000342        END-IF                                                    SMPLEXOP
000343     END-IF                                                       SMPLEXOP
000344                                                                  SMPLEXOP
000345     IF COMPARE-STATE                                             SMPLEXOP
000346        IF EXITOP-IN-STATE NOT = EXITOP-OUT-STATE                 SMPLEXOP
000347          MOVE "Y" TO DIFFERENCES-FLAG                            SMPLEXOP
000348        END-IF                                                    SMPLEXOP
000349     END-IF                                                       SMPLEXOP
000350                                                                  SMPLEXOP
000351     IF COMPARE-ZIP                                               SMPLEXOP
000352        IF EXITOP-IN-ZIP NOT = EXITOP-OUT-ZIP                     SMPLEXOP
000353          MOVE "Y" TO DIFFERENCES-FLAG                            SMPLEXOP
000354        END-IF                                                    SMPLEXOP
000355     END-IF                                                       SMPLEXOP
000356                                                                  SMPLEXOP
000357     IF COMPARE-ZIP-ADDON                                         SMPLEXOP
000358        IF EXITOP-IN-ZP4 NOT = EXITOP-OUT-ZP4                     SMPLEXOP
000359          MOVE "Y" TO DIFFERENCES-FLAG                            SMPLEXOP
000360        END-IF                                                    SMPLEXOP
000361     END-IF                                                       SMPLEXOP
000362                                                                  SMPLEXOP
000363     IF DIFFERENCES-FOUND                                         SMPLEXOP
000364       ADD 1       TO  MISMATCHES                                 SMPLEXOP
000365       PERFORM VARYING AST-POS FROM 1 BY 1                        SMPLEXOP
000366*        UNTIL AST-POS > LENGTH OF EXITOP-INPUT-ADDRESS           SMPLEXOP
000367         UNTIL AST-POS > IA-LEN                                   SMPLEXOP
000368         IF EXITOP-INPUT-ADDRESS(AST-POS:1) NOT =                 SMPLEXOP
000369            EXITOP-OUTPUT-ADDRESS(AST-POS:1)                      SMPLEXOP
000370           MOVE "*" TO ERROR-HOLD(AST-POS:1)                      SMPLEXOP
000371         END-IF                                                   SMPLEXOP
000372       END-PERFORM                                                SMPLEXOP
000373       MOVE SPACES         TO OUTPUT-RECORD                       SMPLEXOP
000374       PERFORM OUTPUT-RECORD-RTN THRU OUTPUT-RECORD-EXIT          SMPLEXOP
000375       MOVE REC-READ-CNTR         TO RECORD-NUMBER                SMPLEXOP
000376       MOVE EXITOP-FILE-ACTIVATOR TO RECORD-FILE                  SMPLEXOP
000377       MOVE RECORD-ID-LINE        TO OUTPUT-RECORD                SMPLEXOP
000378       PERFORM OUTPUT-RECORD-RTN THRU OUTPUT-RECORD-EXIT          SMPLEXOP
000379       MOVE 1 TO PS-POS                                           SMPLEXOP
000380       PERFORM PRINT-REPORT-LINES-RTN                             SMPLEXOP
000381          THRU PRINT-REPORT-LINES-EXIT                            SMPLEXOP
000382         UNTIL PS-POS > IA-LEN                                    SMPLEXOP
000383            OR FATAL-ERROR                                        SMPLEXOP
000384     END-IF                                                       SMPLEXOP
000385     .                                                            SMPLEXOP
000386*%I ENDSR /PROCESS-INPUT-FILE/                                    SMPLEXOP
000387 PROCESS-INPUT-FILE-EXIT. EXIT.                                   ENDSR
000388*%X ENDSR /PROCESS-INPUT-FILE/                                    SMPLEXOP
000389                                                                  SMPLEXOP
000390**==============================================================**SMPLEXOP
000391* FORMAT AND PRINT DIFFERENCE REPORT LINES                       *SMPLEXOP
000392**==============================================================**SMPLEXOP
000393*%I BEGSR /PRINT-REPORT-LINES/                                    SMPLEXOP
000394 PRINT-REPORT-LINES-RTN.                                          BEGSR
000395*%X BEGSR /PRINT-REPORT-LINES/                                    SMPLEXOP
000396                                                                  SMPLEXOP
000397     IF  (PS-POS + 70) < IA-LEN                                   SMPLEXOP
000398       MOVE 70 TO END-POS                                         SMPLEXOP
000399     ELSE                                                         SMPLEXOP
000400       COMPUTE END-POS = IA-LEN - PS-POS                          SMPLEXOP
000401     END-IF                                                       SMPLEXOP
000402                                                                  SMPLEXOP
000403     IF ERROR-HOLD(PS-POS:END-POS) NOT = SPACES                   SMPLEXOP
000404       MOVE SPACES       TO OUTPUT-RECORD                         SMPLEXOP
000405       MOVE " IN ADDR:"  TO TYPE-REC                              SMPLEXOP
000406       MOVE EXITOP-INPUT-ADDRESS(PS-POS:END-POS) TO PRT-LINE      SMPLEXOP
000407       PERFORM OUTPUT-RECORD-RTN    THRU OUTPUT-RECORD-EXIT       SMPLEXOP
000408       MOVE SPACES       TO OUTPUT-RECORD                         SMPLEXOP
000409       MOVE "OUT ADDR:"  TO TYPE-REC                              SMPLEXOP
000410       MOVE EXITOP-OUTPUT-ADDRESS(PS-POS:END-POS) TO PRT-LINE     SMPLEXOP
000411       PERFORM OUTPUT-RECORD-RTN    THRU OUTPUT-RECORD-EXIT       SMPLEXOP
000412       MOVE SPACES       TO OUTPUT-RECORD                         SMPLEXOP
000413       MOVE "    DIFF:"  TO TYPE-REC                              SMPLEXOP
000414       MOVE ERROR-HOLD(PS-POS:END-POS) TO PRT-LINE                SMPLEXOP
000415       PERFORM OUTPUT-RECORD-RTN    THRU OUTPUT-RECORD-EXIT       SMPLEXOP
000416     END-IF                                                       SMPLEXOP
000417     ADD 70 TO PS-POS                                             SMPLEXOP
000418     .                                                            SMPLEXOP
000419*%I ENDSR /PRINT-REPORT-LINES/                                    SMPLEXOP
000420 PRINT-REPORT-LINES-EXIT. EXIT.                                   ENDSR
000421*%X ENDSR /PRINT-REPORT-LINES/                                    SMPLEXOP
000422                                                                  SMPLEXOP
000423**==============================================================**SMPLEXOP
000424* WRITES COMPARISON OUTPUT                                       *SMPLEXOP
000425**==============================================================**SMPLEXOP
000426*%I BEGSR /OUTPUT-RECORD/                                         SMPLEXOP
000427 OUTPUT-RECORD-RTN.                                               BEGSR
000428*%X BEGSR /OUTPUT-RECORD/                                         SMPLEXOP
000429                                                                  SMPLEXOP
000430     WRITE OUTPUT-RECORD                                          SMPLEXOP
000431                                                                  SMPLEXOP
000432     IF OUTPUT-FILE-STATUS NOT = ZEROS                            SMPLEXOP
000433       DISPLAY "***ERROR WRITING SMPLOUT*** ",                    SMPLEXOP
000434                "FILE STATUS  = "                                 SMPLEXOP
000435                OUTPUT-FILE-STATUS                                SMPLEXOP
000436       MOVE "Y" TO FATAL-FLAG                                     SMPLEXOP
000437     END-IF                                                       SMPLEXOP
000438     .                                                            SMPLEXOP
000439*%I ENDSR /OUTPUT-RECORD/                                         SMPLEXOP
000440 OUTPUT-RECORD-EXIT. EXIT.                                        ENDSR
000441*%X ENDSR /OUTPUT-RECORD/                                         SMPLEXOP
000442                                                                  SMPLEXOP
000443**==============================================================**SMPLEXOP
000444* VALIDATE INPUT PARAMETERS                                      *SMPLEXOP
000445**==============================================================**SMPLEXOP
000446*%I BEGSR /INIT1T/                                                SMPLEXOP
000447 INIT1T-RTN.                                                      BEGSR
000448*%X BEGSR /INIT1T/                                                SMPLEXOP
000449     MOVE "N" TO FIRST-FLAG                                       SMPLEXOP
000450                                                                  SMPLEXOP
000451     OPEN OUTPUT SMPLOUT                                          SMPLEXOP
000452                                                                  SMPLEXOP
000453     IF OUTPUT-FILE-STATUS NOT = ZEROS                            SMPLEXOP
000454       DISPLAY "***ERROR OPENING SMPLOUT*** ",                    SMPLEXOP
000455                "FILE STATUS  = "                                 SMPLEXOP
000456                OUTPUT-FILE-STATUS                                SMPLEXOP
000457       MOVE "Y" TO FATAL-FLAG                                     SMPLEXOP
000458     END-IF                                                       SMPLEXOP
000459                                                                  SMPLEXOP
000460     IF NOT FATAL-ERROR                                           SMPLEXOP
000461       PERFORM EDIT-EXITOP-CC-RTN THRU EDIT-EXITOP-CC-EXIT        SMPLEXOP
000462     END-IF                                                       SMPLEXOP
000463                                                                  SMPLEXOP
000464     IF NOT FATAL-ERROR                                           SMPLEXOP
000465       PERFORM PRINT-CC-RTN THRU PRINT-CC-EXIT                    SMPLEXOP
000466     END-IF                                                       SMPLEXOP
000467     .                                                            SMPLEXOP
000468*%I ENDSR /INIT1T/                                                SMPLEXOP
000469 INIT1T-EXIT. EXIT.                                               ENDSR
000470*%X ENDSR /INIT1T/                                                SMPLEXOP
000471                                                                  SMPLEXOP
000472**==============================================================**SMPLEXOP
000473* EXITOP-CONTROL-CARD EDITING                                    *SMPLEXOP
000474**==============================================================**SMPLEXOP
000475*%I BEGSR /EDIT-EXITOP-CC/                                        SMPLEXOP
000476 EDIT-EXITOP-CC-RTN.                                              BEGSR
000477*%X BEGSR /EDIT-EXITOP-CC/                                        SMPLEXOP
000478*                                                                 SMPLEXOP
000479* ANY SPECIAL EDIT CONDITIONS OF THE EXITOP CONTROL CARD IS DONE  SMPLEXOP
000480* IN THIS ROUTINE.  ANY ERRORS IN THE CONTROL CARD SHOULD BE      SMPLEXOP
000481* CONSIDERED AS A FATAL ERROR.  THAT MEANS THE FATAL-FLAG SHOULD  SMPLEXOP
000482* SET TO "Y".                                                     SMPLEXOP
000483     IF EXITOP-ADDR1-FLAG = "Y"                                   SMPLEXOP
000484       MOVE EXITOP-ADDR1-FLAG TO ADDR1-FLAG                       SMPLEXOP
000485     END-IF                                                       SMPLEXOP
000486                                                                  SMPLEXOP
000487     IF EXITOP-ADDR2-FLAG = "Y"                                   SMPLEXOP
000488       MOVE EXITOP-ADDR2-FLAG TO ADDR2-FLAG                       SMPLEXOP
000489     END-IF                                                       SMPLEXOP
000490                                                                  SMPLEXOP
000491     IF EXITOP-CITY-FLAG = "Y"                                    SMPLEXOP
000492       MOVE EXITOP-CITY-FLAG  TO CITY-FLAG                        SMPLEXOP
000493     END-IF                                                       SMPLEXOP
000494                                                                  SMPLEXOP
000495     IF EXITOP-STATE-FLAG = "Y"                                   SMPLEXOP
000496       MOVE EXITOP-STATE-FLAG TO STATE-FLAG                       SMPLEXOP
000497     END-IF                                                       SMPLEXOP
000498                                                                  SMPLEXOP
000499     IF EXITOP-ZIP-FLAG = "Y"                                     SMPLEXOP
000500       MOVE EXITOP-ZIP-FLAG   TO ZIP-FLAG                         SMPLEXOP
000501     END-IF                                                       SMPLEXOP
000502                                                                  SMPLEXOP
000503     IF EXITOP-ZP4-FLAG = "Y"                                     SMPLEXOP
000504       MOVE EXITOP-ZP4-FLAG   TO ZP4-FLAG                         SMPLEXOP
000505     END-IF                                                       SMPLEXOP
000506     .                                                            SMPLEXOP
000507*%I ENDSR /EDIT-EXITOP-CC/                                        SMPLEXOP
000508 EDIT-EXITOP-CC-EXIT. EXIT.                                       ENDSR
000509*%X ENDSR /EDIT-EXITOP-CC/                                        SMPLEXOP
000510                                                                  SMPLEXOP
000511**==============================================================**SMPLEXOP
000512* PRINT THE CONTROL CARD INFORMATION                             *SMPLEXOP
000513**==============================================================**SMPLEXOP
000514*%I BEGSR /PRINT-CC/                                              SMPLEXOP
000515 PRINT-CC-RTN.                                                    BEGSR
000516*%X BEGSR /PRINT-CC/                                              SMPLEXOP
000517                                                                  SMPLEXOP
000518     MOVE SMPLEXOP-TITLE TO OUTPUT-RECORD                         SMPLEXOP
000519     PERFORM OUTPUT-RECORD-RTN    THRU OUTPUT-RECORD-EXIT         SMPLEXOP
000520                                                                  SMPLEXOP
000521     MOVE SPACES TO OUTPUT-RECORD                                 SMPLEXOP
000522     PERFORM OUTPUT-RECORD-RTN    THRU OUTPUT-RECORD-EXIT         SMPLEXOP
000523                                                                  SMPLEXOP
000524     MOVE "EXITOP Control Card:" TO OUTPUT-RECORD                 SMPLEXOP
000525     PERFORM OUTPUT-RECORD-RTN    THRU OUTPUT-RECORD-EXIT         SMPLEXOP
000526                                                                  SMPLEXOP
000527     MOVE EXITOP-CONTROL-CARD TO OUTPUT-RECORD                    SMPLEXOP
000528     PERFORM OUTPUT-RECORD-RTN    THRU OUTPUT-RECORD-EXIT         SMPLEXOP
000529                                                                  SMPLEXOP
000530     MOVE SPACES TO OUTPUT-RECORD                                 SMPLEXOP
000531     PERFORM OUTPUT-RECORD-RTN    THRU OUTPUT-RECORD-EXIT         SMPLEXOP
000532                                                                  SMPLEXOP
000533     MOVE SPACES TO OUTPUT-RECORD                                 SMPLEXOP
000534     STRING "Address Line 1 Checking: " ADDR1-FLAG                SMPLEXOP
000535            DELIMITED BY SIZE                                     SMPLEXOP
000536       INTO PRT-LINE                                              SMPLEXOP
000537     PERFORM OUTPUT-RECORD-RTN    THRU OUTPUT-RECORD-EXIT         SMPLEXOP
000538                                                                  SMPLEXOP
000539     MOVE SPACES TO OUTPUT-RECORD                                 SMPLEXOP
000540     STRING "Address Line 2 Checking: " ADDR2-FLAG                SMPLEXOP
000541            DELIMITED BY SIZE                                     SMPLEXOP
000542       INTO PRT-LINE                                              SMPLEXOP
000543     PERFORM OUTPUT-RECORD-RTN    THRU OUTPUT-RECORD-EXIT         SMPLEXOP
000544                                                                  SMPLEXOP
000545     MOVE SPACES TO OUTPUT-RECORD                                 SMPLEXOP
000546     STRING "     City Name Checking: " CITY-FLAG                 SMPLEXOP
000547            DELIMITED BY SIZE                                     SMPLEXOP
000548       INTO PRT-LINE                                              SMPLEXOP
000549     PERFORM OUTPUT-RECORD-RTN    THRU OUTPUT-RECORD-EXIT         SMPLEXOP
000550                                                                  SMPLEXOP
000551     MOVE SPACES TO OUTPUT-RECORD                                 SMPLEXOP
000552     STRING "         State Checking: " STATE-FLAG                SMPLEXOP
000553            DELIMITED BY SIZE                                     SMPLEXOP
000554       INTO PRT-LINE                                              SMPLEXOP
000555     PERFORM OUTPUT-RECORD-RTN    THRU OUTPUT-RECORD-EXIT         SMPLEXOP
000556                                                                  SMPLEXOP
000557     MOVE SPACES TO OUTPUT-RECORD                                 SMPLEXOP
000558     STRING "      ZIP Code Checking: " ZIP-FLAG                  SMPLEXOP
000559            DELIMITED BY SIZE                                     SMPLEXOP
000560       INTO PRT-LINE                                              SMPLEXOP
000561     PERFORM OUTPUT-RECORD-RTN    THRU OUTPUT-RECORD-EXIT         SMPLEXOP
000562                                                                  SMPLEXOP
000563     MOVE SPACES TO OUTPUT-RECORD                                 SMPLEXOP
000564     STRING "    ZIP+4 Code Checking: " ZP4-FLAG                  SMPLEXOP
000565            DELIMITED BY SIZE                                     SMPLEXOP
000566       INTO PRT-LINE                                              SMPLEXOP
000567     PERFORM OUTPUT-RECORD-RTN    THRU OUTPUT-RECORD-EXIT         SMPLEXOP
000568                                                                  SMPLEXOP
000569     MOVE SPACES TO OUTPUT-RECORD                                 SMPLEXOP
000570     PERFORM OUTPUT-RECORD-RTN    THRU OUTPUT-RECORD-EXIT         SMPLEXOP
000571     .                                                            SMPLEXOP
000572*%I ENDSR /PRINT-CC/                                              SMPLEXOP
000573 PRINT-CC-EXIT. EXIT.                                             ENDSR
000574*%X ENDSR /PRINT-CC/                                              SMPLEXOP
000575                                                                  SMPLEXOP
000576**==============================================================**SMPLEXOP
000577* WRAPUP PROCESSING                                              *SMPLEXOP
000578**==============================================================**SMPLEXOP
000579*%I BEGSR /CLOSE/                                                 SMPLEXOP
000580 CLOSE-RTN.                                                       BEGSR
000581*%X BEGSR /CLOSE/                                                 SMPLEXOP
000582     MOVE "N" TO CLOSE-FLAG                                       SMPLEXOP
000583     MOVE REC-READ-CNTR TO EDIT-MASK                              SMPLEXOP
000584     DISPLAY "***** " EDIT-MASK " Records Compared         "      SMPLEXOP
000585             " *****"                                             SMPLEXOP
000586                                                                  SMPLEXOP
000587     MOVE SPACES TO OUTPUT-RECORD                                 SMPLEXOP
000588     PERFORM OUTPUT-RECORD-RTN    THRU OUTPUT-RECORD-EXIT         SMPLEXOP
000589                                                                  SMPLEXOP
000590     STRING "***** " EDIT-MASK " Records Compared         "       SMPLEXOP
000591            " *****"                                              SMPLEXOP
000592            DELIMITED BY SIZE                                     SMPLEXOP
000593       INTO PRT-LINE                                              SMPLEXOP
000594                                                                  SMPLEXOP
000595     PERFORM OUTPUT-RECORD-RTN    THRU OUTPUT-RECORD-EXIT         SMPLEXOP
000596                                                                  SMPLEXOP
000597     MOVE MISMATCHES TO EDIT-MASK                                 SMPLEXOP
000598     DISPLAY "***** " EDIT-MASK " Total Mis-Matched Records"      SMPLEXOP
000599             " *****"                                             SMPLEXOP
000600                                                                  SMPLEXOP
000601     STRING "***** " EDIT-MASK " Total Mis-Matched Records"       SMPLEXOP
000602            " *****"                                              SMPLEXOP
000603            DELIMITED BY SIZE                                     SMPLEXOP
000604       INTO PRT-LINE                                              SMPLEXOP
000605                                                                  SMPLEXOP
000606     PERFORM OUTPUT-RECORD-RTN    THRU OUTPUT-RECORD-EXIT         SMPLEXOP
000607                                                                  SMPLEXOP
000608     CLOSE SMPLOUT                                                SMPLEXOP
000609                                                                  SMPLEXOP
000610     IF OUTPUT-FILE-STATUS NOT = ZEROS                            SMPLEXOP
000611       DISPLAY "***ERROR CLOSING SMPLOUT*** ",                    SMPLEXOP
000612                "FILE STATUS  = "                                 SMPLEXOP
000613                OUTPUT-FILE-STATUS                                SMPLEXOP
000614       MOVE "Y" TO FATAL-FLAG                                     SMPLEXOP
000615     END-IF                                                       SMPLEXOP
000616     .                                                            SMPLEXOP
000617*%I ENDSR /CLOSE/                                                 SMPLEXOP
000618 CLOSE-EXIT. EXIT.                                                ENDSR
000619*%X ENDSR /CLOSE/                                                 SMPLEXOP
000620*%X SMPLEXOP /SMPLEXOP/                                                GP1
