#!/bin/csh
# AcuCOBOL-specific configuration ==============================================       
setenv ACUCOBOL "$G1RTS"
setenv CODE_PREFIX ".:${G1PRODPATH}/lib"
setenv FILE_PREFIX ".:${G1PRODPATH}/data"
setenv FILE_ALIAS_PREFIX "DD_"
setenv CODE_CASE 0
setenv ERRORS_OK 1
setenv WARNINGS 0
setenv SCROLL ON
setenv SORTDIR "$G1TMP"
setenv A_TERMCAP "$G1RTS/etc/a_termcap"
setenv LOCK_OUTPUT 1
setenv IO_FLUSH_COUNT 0
#setenv USE_LARGE_FILE_API 1
setenv SHARED_LIBRARY_PREFIX "${G1PRODPATH}/lib"
switch ($G1SYS)
case HPUX:
        setenv SHARED_LIBRARY_LIST "G1PIOMGR.sl"
        breaksw
default:
        setenv SHARED_LIBRARY_LIST "G1PIOMGR.so"
        breaksw
endsw
#===============================================================================
# Check for acushare daemon
if ( $G1SYS == "LINUX" ) then
@ RTSRUNG = `ps -e -o user -o pid -o cmd --cols 180| grep 'acushare -start' | grep -v grep | wc -l | awk '{print $1}'`
else
@ RTSRUNG = `ps -ef | grep 'acushare -start' | grep -v grep | wc -l | awk '{print $1}'`
endif
switch ($RTSRUNG)
case 1:
	$G1ECHO "Acushare already running" >./acushare.log
        breaksw
default:
        $G1ECHO "Acushare not running. Starting Acushare in background"
        $G1RTS/bin/acushare -clean >& /dev/null
        $G1RTS/bin/acushare -start >./acushare.log
        breaksw
endsw
#===============================================================================

