#!/bin/sh

ENTITY_TYPE=$1
PWD_MGT_JAR=password-management-utility-24.1.jar

inputInstallType(){
	echo "    SPECTRUM INSTALLATION TYPE"
	echo " 1. Server only installation"
	echo " 2. DB only installation"
	echo " 3. Standard installation"

	read -p "Enter a choice from above: " installType
	
	while [ 1 ]
	do
		if [ "$installType" == '' ] 
		then
		  read -p "Blank value not allowed. Enter valid value: " installType
		  continue;
		else
		  case $installType in
			1)
				installMode="server"
				break;
			;;
			2)
				installMode="db"
				break;
			;;
			3)
				installMode="standard"
				break;
			;;
			*)
				read -p "Incorrect choice. Re-enter correct value: " installType
				continue;
			;;
		  esac
		fi
	done
}

promptOldPassword(){
read -s -p "Enter old password: " oldPassword
}

case "$ENTITY_TYPE" in
	"neo4j")
		echo ""
		echo "************************************************************"
		echo "********************** NEO password management *************"
		echo "************************************************************"
		
		oldPassword=""
		
		java --add-opens java.base/java.lang=ALL-UNNAMED --add-opens java.base/java.nio=ALL-UNNAMED --add-opens java.base/java.io=ALL-UNNAMED --add-opens java.base/java.util=ALL-UNNAMED --add-opens java.base/java.util.concurrent=ALL-UNNAMED --add-opens java.base/sun.net.www.protocol.http=ALL-UNNAMED --add-opens java.base/sun.nio.ch=ALL-UNNAMED -jar $PWD_MGT_JAR $ENTITY_TYPE "internal"
		result=$?
		if [ $result == "1" ]
		then
			promptOldPassword
		else
			oldPassword="auto"
		fi
		
		echo ""
		while [ 1 ]
		do
			read -s -p "Enter new password: " newPassword
			newPasswordLength=${#newPassword}
			echo ""
			if [ $newPasswordLength -lt 10 ]
			then
				echo "Password must contain minimum 10 characters."
			else
				break
			fi
		done
		
		echo ""
		read -p "Enter encryption key: " encryptionKey
		if [ "$encryptionKey" == '' ]
		then
			encryptionKey="internal"
		fi
		
		echo ""
		installMode="na"
		inputInstallType
		
		while [ 1 ]
		do
			read -p "Do you wish to continue to change password(y/n)? " agree
			if [ "$agree" == '' ] || [ $agree != 'Y' -a $agree != 'y' -a $agree != 'N' -a $agree != 'n' ]
			then
				continue;
			elif [ $agree == 'y' -o $agree == 'Y' ]
			then
				break;
			else
				echo "Password change aborted";
				exit;
			fi			
		done

		exec java --add-opens java.base/java.lang=ALL-UNNAMED --add-opens java.base/java.nio=ALL-UNNAMED --add-opens java.base/java.io=ALL-UNNAMED --add-opens java.base/java.util=ALL-UNNAMED --add-opens java.base/java.util.concurrent=ALL-UNNAMED --add-opens java.base/sun.net.www.protocol.http=ALL-UNNAMED --add-opens java.base/sun.nio.ch=ALL-UNNAMED -jar $PWD_MGT_JAR $ENTITY_TYPE $oldPassword $newPassword $encryptionKey $installMode
		
	;;        
	"index")
		echo ""
		echo "************************************************************"
		echo "********************** Index password management *************"
		echo "************************************************************"
		
		oldPassword=""
		
		java --add-opens java.base/java.lang=ALL-UNNAMED --add-opens java.base/java.nio=ALL-UNNAMED --add-opens java.base/java.io=ALL-UNNAMED --add-opens java.base/java.util=ALL-UNNAMED --add-opens java.base/java.util.concurrent=ALL-UNNAMED --add-opens java.base/sun.net.www.protocol.http=ALL-UNNAMED --add-opens java.base/sun.nio.ch=ALL-UNNAMED -jar $PWD_MGT_JAR $ENTITY_TYPE "internal"
		result=$?
		if [ $result == "1" ]
		then
			promptOldPassword
		else
			oldPassword="auto"
		fi
		
		echo ""
		while [ 1 ]
		do
			read -s -p "Enter new password: " newPassword
			newPasswordLength=${#newPassword}
			echo ""
			if [ $newPasswordLength -lt 10 ]
			then
				echo "Password must contain minimum 10 characters."
			else
				break
			fi
		done
		
		echo ""
		read -p "Enter encryption key: " encryptionKey
		if [ "$encryptionKey" == '' ]
		then
			encryptionKey="internal"
		fi
		
		echo ""	
		
		while [ 1 ]
		do
			installMode="na"
			inputInstallType
			if [ $installMode == "db" ]
			then
				echo ""
				echo "For Index DB only installation is not valid. Choose Server or Standard installation mode."
				echo ""
				continue;
			else
				break;
			fi
		done
		while [ 1 ]
		do
			read -p "Do you wish to continue to change password(y/n)? " agree
			if [ "$agree" == '' ] || [ $agree != 'Y' -a $agree != 'y' -a $agree != 'N' -a $agree != 'n' ]
			then
				continue;
			elif [ $agree == 'y' -o $agree == 'Y' ]
			then
				break;
			else
				echo "Password change aborted";
				exit;
			fi			
		done

		exec java --add-opens java.base/java.lang=ALL-UNNAMED --add-opens java.base/java.nio=ALL-UNNAMED --add-opens java.base/java.io=ALL-UNNAMED --add-opens java.base/java.util=ALL-UNNAMED --add-opens java.base/java.util.concurrent=ALL-UNNAMED --add-opens java.base/sun.net.www.protocol.http=ALL-UNNAMED --add-opens java.base/sun.nio.ch=ALL-UNNAMED -jar $PWD_MGT_JAR $ENTITY_TYPE $oldPassword $newPassword $encryptionKey $installMode
		
	;;
	"spatial")
		echo ""
		echo "***************************************************************************"
		echo "********************** Spatial Repository password management *************"
		echo "***************************************************************************"
		echo ""
		echo ""
		echo INFO : Configured database password length must be greater than 10 characters. It is recommended to use at least 20 characters. Password should be random and complex. If it is not please consider changing the password before running this utility.
		echo ""
		read -s -p "Enter password: " password
		echo ""
		exec java -jar ../modules/spatial/lib/encryption-utility-24.1.jar --p $password
	;;
	*)
	echo "************************************************************"
	echo "********************** UTILITY USAGE ***********************"
	echo "************************************************************"
	echo ""
	echo "The script takes one argument (case sensitive) which is the entity type. Command example below:"
	echo "<script> <entityType> ==> pmu.sh neo4j"
	echo ""
	echo "Valid values for entityType:"
	echo "neo4j  --> for changing password for neo4j repository"
	echo "index  --> for changing password for index"
	echo "spatial  --> for changing password for spatial's jackrabbit repository"
	;;
esac



