@echo off

SET entityType=%1
SET PWD_MGT_JAR=password-management-utility-24.1.jar

rem if no argument is passed, display usage info
if "x%entityType%x" == "xx" goto displayUsage

rem validate first argument value. if it does not contain valid values neo/elastic/jr then return with error
if not %entityType%==neo4j if not %entityType%==spatial if not %entityType%==index ^
echo ERROR: Invalid entityType value entered. Run script without argument for usage details. & exit /b -1

if %entityType%==neo4j (
goto NEO_ENTITY
)else if %entityType%==spatial (
goto JR_ENTITY
)else if %entityType%==index (
goto INDEX_ENTITY
else (
echo ERROR:Invalid entity type
)

:NEO_ENTITY
echo.
echo ************************************************************
echo ***************** NEO password management ******************
echo ************************************************************

echo.
set promptOldPassword=0
CALL :ISOLDPWDREQUIRED promptOldPassword

set oldPassword=
if %promptOldPassword% NEQ 0 (
	CALL :PROMPTFOROLDPASSWORD oldPassword
) else (
	set oldPassword=auto
)

echo.
:ENTER_NEW_PWD
set "psCommand=powershell -Command "$pword = read-host 'Enter New Password' -AsSecureString ; ^
    $BSTR=[System.Runtime.InteropServices.Marshal]::SecureStringToBSTR($pword); ^
        [System.Runtime.InteropServices.Marshal]::PtrToStringAuto($BSTR)""
for /f "usebackq delims=" %%p in (`%psCommand%`) do set newPassword=%%p

if "%newPassword%" == "" (
 	goto :ENTER_NEW_PWD
)

set pwdLengthCheck=%newPassword%
set plen=0
:VALIDATEPWDLENGTH
if not defined pwdLengthCheck (
	if %plen% LSS 10 (
		echo Password must contain minimum 10 characters.
		goto :ENTER_NEW_PWD
	)
	goto :break
)
set pwdLengthCheck=%pwdLengthCheck:~1%
set /a plen+=1
goto VALIDATEPWDLENGTH
:break

echo.
set /p encryptionKey=Enter encryption key (To use internal key proceed without entering value): 

if "%encryptionKey%" == "" (
	set encryptionKey=internal
)

echo.
echo      SPECTRUM INSTALLATION TYPE
echo   1. Server only installation
echo   2. DB only installation
echo   3. Standard installation

:installationType
echo.
set /p installType=Enter installation type: 
if "%installType%" == "1" ( 
	set installMode=server
) else (
	if "%installType%" == "2" (	
		if "%entityType%" == "index" (
			echo For Index DB only installation is not valid. Choose Server or Standard installation mode.
			goto :installationType
		)    
		set installMode=db
	) else (
		if "%installType%" == "3" (
			set installMode=standard
		) else (
			goto :installationType
		)
	)
)
)
echo.
set confirmation=1
call :CONFIRMATIONTOPROCEED confirmation
if %confirmation%==0 (
	echo Password change aborted
	exit /B 1
)

call java --add-opens java.base/java.lang=ALL-UNNAMED --add-opens java.base/java.nio=ALL-UNNAMED --add-opens java.base/java.io=ALL-UNNAMED --add-opens java.base/java.util=ALL-UNNAMED --add-opens java.base/java.util.concurrent=ALL-UNNAMED --add-opens java.base/sun.net.www.protocol.http=ALL-UNNAMED --add-opens java.base/sun.nio.ch=ALL-UNNAMED -jar %PWD_MGT_JAR% %entityType% %oldPassword% %newPassword% %encryptionKey% %installMode%

exit /B 1

:INDEX_ENTITY
echo.
echo ************************************************************
echo ***************** Index password management ******************
echo ************************************************************

echo.
set promptOldPassword=0
CALL :ISOLDPWDREQUIRED promptOldPassword

set oldPassword=
if %promptOldPassword% NEQ 0 (
	CALL :PROMPTFOROLDPASSWORD oldPassword
) else (
	set oldPassword=auto 
)

echo.
:ENTER_NEW_PWD
set "psCommand=powershell -Command "$pword = read-host 'Enter New Password' -AsSecureString ; ^
    $BSTR=[System.Runtime.InteropServices.Marshal]::SecureStringToBSTR($pword); ^
        [System.Runtime.InteropServices.Marshal]::PtrToStringAuto($BSTR)""
for /f "usebackq delims=" %%p in (`%psCommand%`) do set newPassword=%%p

if "%newPassword%" == "" (
 	goto :ENTER_NEW_PWD
)

set pwdLengthCheck=%newPassword%
set plen=0
:VALIDATEPWDLENGTH
if not defined pwdLengthCheck (
	if %plen% LSS 10 (
		echo Password must contain minimum 10 characters.
		goto :ENTER_NEW_PWD
	)
	goto :break
)
set pwdLengthCheck=%pwdLengthCheck:~1%
set /a plen+=1
goto VALIDATEPWDLENGTH
:break

echo.
set /p encryptionKey=Enter encryption key (To use internal key proceed without entering value): 

if "%encryptionKey%" == "" (
	set encryptionKey=internal
)

echo.
echo      SPECTRUM INSTALLATION TYPE
echo   1. Server only installation
echo   2. DB only installation
echo   3. Standard installation

:installationType
echo.
set /p installType=Enter installation type: 
if "%installType%" == "1" ( 
	set installMode=server
) else (
	if "%installType%" == "2" (
	    if "%entityType%" == "index" (
			echo For Index DB only installation is not valid. Choose Server or Standard installation mode.
			goto :installationType
		)
		set installMode=db
	) else (
		if "%installType%" == "3" (
			set installMode=standard
		) else (
			goto :installationType
		)
	)
)
)
echo.
set confirmation=1
call :CONFIRMATIONTOPROCEED confirmation
if %confirmation%==0 (
	echo Password change aborted
	exit /B 1
)

call java --add-opens java.base/java.lang=ALL-UNNAMED --add-opens java.base/java.nio=ALL-UNNAMED --add-opens java.base/java.io=ALL-UNNAMED --add-opens java.base/java.util=ALL-UNNAMED --add-opens java.base/java.util.concurrent=ALL-UNNAMED --add-opens java.base/sun.net.www.protocol.http=ALL-UNNAMED --add-opens java.base/sun.nio.ch=ALL-UNNAMED -jar %PWD_MGT_JAR% %entityType% %oldPassword% %newPassword% %encryptionKey% %installMode%

exit /B 1

:JR_ENTITY
echo ************************************************************
echo ********* Spatial Repository password management ***********
echo ************************************************************
echo.
echo INFO : Configured database password length must be greater than 10 characters. It is recommended to use at least 20 characters. Password should be random and complex. If it is not please consider changing the password before running this utility.
echo.
set "psCommand=powershell -Command "$pword = read-host 'Enter Password' -AsSecureString ; ^
    $BSTR=[System.Runtime.InteropServices.Marshal]::SecureStringToBSTR($pword); ^
        [System.Runtime.InteropServices.Marshal]::PtrToStringAuto($BSTR)""
for /f "usebackq delims=" %%p in (`%psCommand%`) do set password=%%p

if "%password%" == "" (
	echo "Password cannot be blank"
	exit /B 1
)

call java -jar ../modules/spatial/lib/encryption-utility-22.1.jar --p "%password%"
exit /B 1

:displayUsage
echo.
echo ************************************************************
echo ********************** UTILITY USAGE ***********************
echo ************************************************************
echo.
echo The script takes one argument (case sensitive) which is the entity type. Command example below:
echo "<script> <entityType> ==> pmu.bat neo4j"
echo.
echo Valid values for entityType:
echo "neo4j  --> for changing password for neo4j repository"
echo "index  --> for changing password for index"
echo "spatial  --> for changing password for spatial's jackrabbit repository"
exit /B 1


:CONFIRMATIONTOPROCEED
:WHILE
set /p agree=Do you wish to continue to change password (y/n)? 
if "%agree%" == "Y" (
	goto :BREAK
) else (
	if "%agree%" == "y" (
		goto :BREAK
	) else (
		if "%agree%" == "N" (
			set %~1=0
			exit /B 1
		) else (
			if "%agree%" == "n" (
				set %~1=0
				exit /B 1
			) else (
				goto :WHILE
				)
			)
		)
	)
:BREAK
EXIT /B 0

:PROMPTFOROLDPASSWORD
:ENTER_OLD_PWD
 	set "psCommand=powershell -Command "$pword = read-host 'Enter Old Password' -AsSecureString ; ^
     $BSTR=[System.Runtime.InteropServices.Marshal]::SecureStringToBSTR($pword); ^
          [System.Runtime.InteropServices.Marshal]::PtrToStringAuto($BSTR)""
 	for /f "usebackq delims=" %%p in (`%psCommand%`) do set opassword=%%p

	if "%opassword%" == "" (
		goto :ENTER_OLD_PWD
	)
	set %~1=%opassword%
)
EXIT /B 1

:ISOLDPWDREQUIRED
call java --add-opens java.base/java.lang=ALL-UNNAMED --add-opens java.base/java.nio=ALL-UNNAMED --add-opens java.base/java.io=ALL-UNNAMED --add-opens java.base/java.util=ALL-UNNAMED --add-opens java.base/java.util.concurrent=ALL-UNNAMED --add-opens java.base/sun.net.www.protocol.http=ALL-UNNAMED --add-opens java.base/sun.nio.ch=ALL-UNNAMED -jar %PWD_MGT_JAR% %entityType% internal
set %~1=%ERRORLEVEL%
EXIT /B 1
